/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils.search.executors;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CustomBeanWrappersQueryExecutor<Params extends SpringBeanSearchParameters>
extends QueryExecutorBase<SpringBeanPointer, Params> {
    public final void processQuery(@NotNull Params params, @NotNull Processor<SpringBeanPointer> consumer) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor", "processQuery"));
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        SpringXmlBeansIndex.processCustomBeans(params, (Processor<CustomBeanWrapper>)collectProcessor);
        for (CustomBeanWrapper customBeanWrapper : collectProcessor.getResults()) {
            if (this.processCustomBeanWrapper(params, consumer, customBeanWrapper)) continue;
            return;
        }
    }

    private boolean processCustomBeanWrapper(@NotNull Params params, @NotNull Processor<SpringBeanPointer> consumer, @NotNull CustomBeanWrapper wrapper) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor", "processCustomBeanWrapper"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor", "processCustomBeanWrapper"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor", "processCustomBeanWrapper"));
        }
        List customBeans = wrapper.getCustomBeans();
        for (CustomBean bean : customBeans) {
            if (!this.accept(params, bean) || !bean.isValid() || consumer.process((Object)BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean))) continue;
            return false;
        }
        return !this.acceptWrapper(params, wrapper) || consumer.process((Object)BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)wrapper));
    }

    protected abstract boolean accept(@NotNull Params var1, @NotNull CustomBean var2);

    protected abstract boolean acceptWrapper(@NotNull Params var1, @NotNull CustomBeanWrapper var2);

    public static class BeanName
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanName> {
        public static final BeanName INSTANCE = new BeanName();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanName parameters, @NotNull CustomBean bean) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanName", "accept"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanName", "accept"));
            }
            return parameters.getBeanName().equals(bean.getBeanName());
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanName parameters, @NotNull CustomBeanWrapper bean) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanName", "acceptWrapper"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanName", "acceptWrapper"));
            }
            return parameters.getBeanName().equals(bean.getBeanName());
        }
    }

    public static class AllWrappers
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanName> {
        public static final AllWrappers INSTANCE = new AllWrappers();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanName name, @NotNull CustomBean bean) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$AllWrappers", "accept"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$AllWrappers", "accept"));
            }
            return false;
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanName name, @NotNull CustomBeanWrapper bean) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$AllWrappers", "acceptWrapper"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$AllWrappers", "acceptWrapper"));
            }
            return true;
        }
    }

    public static class BeanClass
    extends CustomBeanWrappersQueryExecutor<SpringBeanSearchParameters.BeanClass> {
        public static final BeanClass INSTANCE = new BeanClass();

        @Override
        protected boolean accept(@NotNull SpringBeanSearchParameters.BeanClass parameters, @NotNull CustomBean bean) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanClass", "accept"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanClass", "accept"));
            }
            return parameters.matchesClass(bean.getBeanClass());
        }

        @Override
        protected boolean acceptWrapper(@NotNull SpringBeanSearchParameters.BeanClass aClass, @NotNull CustomBeanWrapper bean) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanClass", "acceptWrapper"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/search/executors/CustomBeanWrappersQueryExecutor$BeanClass", "acceptWrapper"));
            }
            return false;
        }
    }
}

