/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.context.impl;

import com.intellij.psi.PsiPackage;
import com.intellij.spring.model.jam.utils.filters.SpringContextExpressionFilterFactory;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBeanImpl;
import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBeansPackagesScanBeanImpl
extends DomSpringBeanImpl
implements SpringBeansPackagesScanBean,
SpringBeansPackagesScan {
    @NotNull
    public Set<PsiPackage> getPsiPackages() {
        GenericAttributeValue basePackage = this.getBasePackage();
        if (PlaceholderUtils.getInstance().isDefaultPlaceholder(basePackage.getRawText())) {
            Set<PsiPackage> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/context/impl/SpringBeansPackagesScanBeanImpl", "getPsiPackages"));
            }
            return set;
        }
        Collection packages = (Collection)basePackage.getValue();
        HashSet<PsiPackage> hashSet = packages == null ? Collections.emptySet() : new HashSet<PsiPackage>(packages);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/context/impl/SpringBeansPackagesScanBeanImpl", "getPsiPackages"));
        }
        return hashSet;
    }

    @NotNull
    public Set<SpringContextFilter.Exclude> getExcludeContextFilters() {
        Set set = ContainerUtil.map2Set((Collection)this.getExcludeFilters(), (Function)new Function<Filter, SpringContextFilter.Exclude>(){

            public SpringContextFilter.Exclude fun(Filter filter) {
                return SpringContextExpressionFilterFactory.createExcludeFilter(filter);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/context/impl/SpringBeansPackagesScanBeanImpl", "getExcludeContextFilters"));
        }
        return set;
    }

    @NotNull
    public Set<SpringContextFilter.Include> getIncludeContextFilters() {
        Set set = ContainerUtil.map2Set((Collection)this.getIncludeFilters(), (Function)new Function<Filter, SpringContextFilter.Include>(){

            public SpringContextFilter.Include fun(Filter filter) {
                return SpringContextExpressionFilterFactory.createIncludeFilter(filter);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/context/impl/SpringBeansPackagesScanBeanImpl", "getIncludeContextFilters"));
        }
        return set;
    }
}

