/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.PsiMethodCallFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.references.SpringBeanNamesReferenceProvider;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringBeanScopeReference;
import com.intellij.spring.references.SpringPlaceholderReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class SpringReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/references/SpringReferenceContributor", "registerReferenceProviders"));
        }
        SpringReferenceContributor.registerPsiClassReferences(registrar);
        SpringReferenceContributor.registerXmlContextReferenceProviders(registrar);
        SpringReferenceContributor.registerAnnoReferenceProviders(registrar);
    }

    private static void registerAnnoReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("org.springframework.context.annotation.Scope", "value"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringReferenceContributor$1", "getReferencesByElement"));
                }
                if (element instanceof PsiLiteralExpression) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanScopeReference((PsiLiteralExpression)element)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }, 100.0);
    }

    private static void registerXmlContextReferenceProviders(PsiReferenceRegistrar registrar) {
        PropertiesReferenceProvider propertiesReferenceProvider = new PropertiesReferenceProvider(false);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"code"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(new String[]{"http://www.springframework.org/tags"}), (ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter("message", "theme"))), 2)), (PsiReferenceProvider)propertiesReferenceProvider);
        PatternCondition<XmlAttributeValue> customBeanPattern = new PatternCondition<XmlAttributeValue>("customBeanId"){

            public boolean accepts(@NotNull XmlAttributeValue attributeValue, ProcessingContext context) {
                if (attributeValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/spring/references/SpringReferenceContributor$2", "accepts"));
                }
                CustomBeanWrapper element = (CustomBeanWrapper)DomUtil.findDomElement((PsiElement)attributeValue, CustomBeanWrapper.class);
                if (element == null) {
                    return false;
                }
                for (CustomBean customBean : element.getCustomBeans()) {
                    if (customBean.getIdAttribute() != attributeValue.getParent()) continue;
                    context.put((Object)"bean", (Object)customBean);
                    return true;
                }
                return false;
            }
        };
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile((ElementPattern)PsiJavaPatterns.virtualFile().ofType((FileType)StdFileTypes.XML))).inFile((ElementPattern)PlatformPatterns.psiFile(XmlFile.class).with((PatternCondition)new PatternCondition<XmlFile>("isSpringXmlFile"){

            public boolean accepts(@NotNull XmlFile file, ProcessingContext context) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/references/SpringReferenceContributor$4", "accepts"));
                }
                return SpringDomUtils.isSpringXml((XmlFile)file);
            }
        }))).with((PatternCondition)customBeanPattern), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringReferenceContributor$3", "getReferencesByElement"));
                }
                CustomBean bean = (CustomBean)context.get((Object)"bean");
                PsiReference[] psiReferenceArray = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)bean.getIdentifyingPsiElement())};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static void registerPsiClassReferences(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/references/SpringReferenceContributor", "registerPsiClassReferences"));
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().and((ElementPattern)new FilterPattern((ElementFilter)new ParentElementFilter((ElementFilter)new PsiMethodCallFilter("org.springframework.beans.factory.BeanFactory", SpringBeanNamesReferenceProvider.METHODS), 2))), (PsiReferenceProvider)new SpringBeanNamesReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.annotation.Resource", "name"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringReferenceContributor$5", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringReferenceContributor$5", "getReferencesByElement"));
                }
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
                PsiType type = PropertyUtil.getPropertyType((PsiMember)member);
                PsiClass required = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                String beanName = (String)((PsiLiteralExpression)element).getValue();
                boolean isFactoryBeanRef = false;
                if (StringUtil.isEmptyOrSpaces((String)beanName)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$5", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (beanName.startsWith("&")) {
                    beanName = beanName.substring(1);
                    isFactoryBeanRef = true;
                }
                TextRange range = TextRange.from((int)element.getText().indexOf(beanName), (int)beanName.length());
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference((PsiElement)((PsiLiteralExpression)element), range, required, isFactoryBeanRef){

                    public boolean isSoft() {
                        return true;
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$5", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
        PsiJavaElementPattern.Capture newExpressionCapture = PsiJavaPatterns.psiNewExpression((String[])new String[]{"org.springframework.context.support.ClassPathXmlApplicationContext", "org.springframework.core.io.ClassPathResource"});
        PsiJavaElementPattern.Capture capture = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().withSuperParent(2, (ElementPattern)newExpressionCapture), PsiJavaPatterns.psiExpression().withSuperParent(4, (ElementPattern)newExpressionCapture)});
        registrar.registerReferenceProvider((ElementPattern)capture, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/references/SpringReferenceContributor$6", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/references/SpringReferenceContributor$6", "getReferencesByElement"));
                }
                String s = ElementManipulators.getValueText((PsiElement)element);
                PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getClassPathReferences(SpringResourcesBuilder.create((PsiElement)element, (String)s).fromRoot(s.startsWith("/")).soft(false));
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/references/SpringReferenceContributor$6", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam((ElementPattern)PsiJavaPatterns.psiAnnotation().qName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.springframework.beans.factory.annotation.Value", "org.springframework.scheduling.annotation.Scheduled"}))), (PsiReferenceProvider)new SpringPlaceholderReferenceProvider());
    }
}

