/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SpringSpiManagerImpl
extends SpringSpiManager {
    private final Module myModule;

    public SpringSpiManagerImpl(Module module) {
        this.myModule = module;
    }

    public List<PropertiesFileImpl> getSpringFactoriesFiles(boolean includeTests) {
        return SpringCommonUtils.findConfigFilesInMetaInf((Module)this.myModule, (boolean)includeTests, (String)"spring.factories", PropertiesFileImpl.class);
    }

    public List<PsiClass> getClassesListValue(boolean includeTests, String key) {
        SmartList result = new SmartList();
        List<PropertiesFileImpl> configFiles = this.getSpringFactoriesFiles(includeTests);
        for (PropertiesFileImpl configFile : configFiles) {
            IProperty property = configFile.findPropertyByKey(key);
            PropertyValueImpl valueElement = SpringSpiManagerImpl.getPropertyValuePsiElement(property);
            if (valueElement == null) continue;
            for (PsiReference reference : valueElement.getReferences()) {
                PsiElement resolve;
                if (!(reference instanceof JavaClassReference) || !((resolve = reference.resolve()) instanceof PsiClass)) continue;
                result.add((PsiClass)resolve);
            }
        }
        return result;
    }

    @Nullable
    private static PropertyValueImpl getPropertyValuePsiElement(@Nullable IProperty property) {
        if (!(property instanceof PropertyImpl)) {
            return null;
        }
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }
}

