/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import org.jetbrains.annotations.NotNull;

class AndroidRemoteDbInfo {
    private final String myDeviceId;
    private final String myPackageName;
    private final String myDatabaseName;
    private final boolean myExternal;

    public AndroidRemoteDbInfo(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, boolean external) {
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidRemoteDbInfo", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidRemoteDbInfo", "<init>"));
        }
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "org/jetbrains/android/database/AndroidRemoteDbInfo", "<init>"));
        }
        this.myDeviceId = deviceId;
        this.myPackageName = packageName;
        this.myDatabaseName = databaseName;
        this.myExternal = external;
    }

    @NotNull
    public String getDeviceId() {
        String string = this.myDeviceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidRemoteDbInfo", "getDeviceId"));
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidRemoteDbInfo", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public String getDatabaseName() {
        String string = this.myDatabaseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidRemoteDbInfo", "getDatabaseName"));
        }
        return string;
    }

    public boolean isExternal() {
        return this.myExternal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidRemoteDbInfo info = (AndroidRemoteDbInfo)o;
        if (this.myExternal != info.myExternal) {
            return false;
        }
        if (!this.myDatabaseName.equals(info.myDatabaseName)) {
            return false;
        }
        if (!this.myDeviceId.equals(info.myDeviceId)) {
            return false;
        }
        return this.myPackageName.equals(info.myPackageName);
    }

    public int hashCode() {
        int result = this.myDeviceId.hashCode();
        result = 31 * result + this.myPackageName.hashCode();
        result = 31 * result + this.myDatabaseName.hashCode();
        result = 31 * result + (this.myExternal ? 1 : 0);
        return result;
    }
}

