/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import jetbrains.coverage.report.ClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleInfo {
    private final String myName;

    public ModuleInfo(String name) {
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean isEmpty() {
        return this.myName == null || this.myName.length() == 0;
    }

    public boolean isNullModule() {
        return this.myName == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleInfo that = (ModuleInfo)o;
        return !(this.myName == null ? that.myName != null : !this.myName.equals(that.myName));
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return "ModuleInfo{myName='" + this.myName + '\'' + '}';
    }

    @NotNull
    public static ModuleInfo fromClassInfo(@NotNull ClassInfo ci) {
        if (ci == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModuleInfo.fromClassInfo must not be null");
        }
        ModuleInfo moduleInfo = new ModuleInfo(ci.getModule());
        if (moduleInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModuleInfo.fromClassInfo must not return null");
        }
        return moduleInfo;
    }

    public static ModuleInfo newEmpty() {
        return new ModuleInfo(null);
    }

    @NotNull
    public String getPathNamePrefix() {
        String string = this.myName == null ? "" : this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModuleInfo.getPathNamePrefix must not return null");
        }
        return string;
    }
}

