/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

public abstract class ResolverProcessor<T extends GroovyResolveResult>
extends GrScopeProcessorWithHints {
    protected final PsiElement myPlace;
    private List<T> myCandidates;

    protected ResolverProcessor(@Nullable String name, @NotNull EnumSet<ElementClassHint.DeclarationKind> resolveTargets, @NotNull PsiElement place) {
        if (resolveTargets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTargets", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "<init>"));
        }
        super(name, resolveTargets);
        this.myPlace = place;
    }

    protected final void addCandidate(@NotNull T candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "addCandidate"));
        }
        PsiElement element = candidate.getElement();
        assert (element == null || element.isValid()) : ResolverProcessor.getElementInfo(element);
        if (this.myCandidates == null) {
            this.myCandidates = new ArrayList<T>();
        }
        this.myCandidates.add(candidate);
    }

    @NotNull
    private static String getElementInfo(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getElementInfo"));
        }
        String text = element instanceof LightElement ? ((context = element.getContext()) instanceof LightElement ? context.toString() : (context != null ? context.getText() : null)) : element.getText();
        String string = "invalid resolve candidate: " + element.getClass() + ", text: " + text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getElementInfo"));
        }
        return string;
    }

    @NotNull
    protected List<T> getCandidatesInternal() {
        List list = this.myCandidates == null ? Collections.emptyList() : this.myCandidates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidatesInternal"));
        }
        return list;
    }

    protected boolean isAccessible(@NotNull PsiNamedElement namedElement) {
        if (namedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedElement", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "isAccessible"));
        }
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(this.myPlace, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(this.myPlace, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(this.myPlace, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(@NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "isStaticsOK"));
        }
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, this.myPlace, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (this.myCandidates == null) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidates"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = this.myCandidates.toArray(new GroovyResolveResult[this.myCandidates.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "getCandidates"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/lang/resolve/processors/ResolverProcessor", "handleEvent"));
        }
    }

    public boolean hasCandidates() {
        return this.myCandidates != null;
    }

    public String toString() {
        return "NameHint: '" + this.myName + "', " + this.myResolveTargetKinds + ", Candidates: " + (this.myCandidates == null ? 0 : this.myCandidates.size());
    }
}

