/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final String myAnnotatedContent;
    @NotNull
    private final List<LineInfo> myLines;
    @NotNull
    private final List<VcsFileRevision> myRevisions;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull String annotatedContent, @NotNull List<LineInfo> lines, @NotNull List<VcsFileRevision> revisions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (annotatedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedContent", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "git4idea/annotate/GitFileAnnotation", "<init>"));
        }
        super(project);
        this.DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String doGetValue(LineInfo info) {
                Date date = info.getDate();
                return date == null ? "" : DateFormatUtil.formatPrettyDate((Date)date);
            }
        };
        this.REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                GitRevisionNumber revision = lineInfo.getRevision();
                return revision == null ? "" : String.valueOf(revision.getShortRev());
            }
        };
        this.AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                String author = lineInfo.getAuthor();
                return author == null ? "" : author;
            }
        };
        this.myProject = project;
        this.myFile = file;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        this.myBaseRevision = revision == null ? this.myVcs.getDiffProvider().getCurrentRevision(file) : revision;
        this.myAnnotatedContent = annotatedContent;
        this.myLines = lines;
        this.myRevisions = revisions;
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myLines.get(lineNumber);
        GitFileRevision fileRevision = info.myFileRevision;
        if (fileRevision != null) {
            return GitBundle.message("annotation.tool.tip", info.getRevision().asString(), info.getAuthor(), info.getDate(), fileRevision.getCommitMessage());
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myAnnotatedContent;
    }

    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisions.isEmpty();
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber).getRevision();
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    public Date getLineDate(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber).getDate();
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    public int getNumLines() {
        return this.myLines.size();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/annotate/GitFileAnnotation", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    static class LineInfo {
        private final Date myDate;
        private final GitRevisionNumber myRevision;
        private final GitFileRevision myFileRevision;
        private final String myAuthor;

        public LineInfo(Date date, GitRevisionNumber revision, GitFileRevision fileRevision, String author) {
            this.myDate = date;
            this.myRevision = revision;
            this.myFileRevision = fileRevision;
            this.myAuthor = author;
        }

        public Date getDate() {
            return this.myDate;
        }

        public GitRevisionNumber getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myAuthor;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevision(), (VirtualFile)GitFileAnnotation.this.myFile, (VcsKey)GitVcs.getKey());
            }
        }
    }
}

