/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.MessageBusUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import org.jetbrains.annotations.NotNull;

public class DataBus {
    public static final ExtensionPointName<DataConsumer> CONSUMER_EP = ExtensionPointName.create((String)"com.intellij.database.dataConsumer");
    public static final ExtensionPointName<DataProducer> PRODUCER_EP = ExtensionPointName.create((String)"com.intellij.database.dataProducer");
    public static final ExtensionPointName<DataAuditor> AUDITOR_EP = ExtensionPointName.create((String)"com.intellij.database.dataAuditor");
    private static final NotNullLazyKey<DataBus, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DataBus.class);
    private final MessageBus myMessageBus;

    DataBus(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "<init>"));
        }
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)this);
        Disposer.register((Disposable)project, (Disposable)MessageBusUtil.newMessageBusDisposer((MessageBus)this.myMessageBus));
        for (DataConsumer dataConsumer : (DataConsumer[])Extensions.getExtensions(CONSUMER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.RESPONSE_TOPIC, (Object)dataConsumer);
        }
        for (DataProducer dataProducer : (DataProducer[])Extensions.getExtensions(PRODUCER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.REQUEST_TOPIC, (Object)dataProducer);
        }
        for (DataAuditor dataAuditor : (DataAuditor[])Extensions.getExtensions(AUDITOR_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)dataAuditor);
        }
    }

    @NotNull
    public static MessageBus getDataBus(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "getDataBus"));
        }
        MessageBus messageBus = ((DataBus)DataBus.INSTANCE_KEY.getValue((UserDataHolder)project)).myMessageBus;
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "getDataBus"));
        }
        return messageBus;
    }

    @NotNull
    public static Producing shortCircuit(@NotNull Consuming messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/DataBus", "shortCircuit"));
        }
        Producing producing = (Producing)((Object)messageBus);
        if (producing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "shortCircuit"));
        }
        return producing;
    }

    public static void addRootAuditor(@NotNull Project project, DataAuditor auditor, Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "addRootAuditor"));
        }
        DataBus.getDataBus(project).connect(disposable).subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)auditor);
    }

    @NotNull
    public static DataAuditor getRootAuditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "getRootAuditor"));
        }
        DataAuditor dataAuditor = (DataAuditor)DataBus.getDataBus(project).syncPublisher(DatabaseTopics.AUDIT_TOPIC);
        if (dataAuditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "getRootAuditor"));
        }
        return dataAuditor;
    }

    public static interface Producing {
        public DataConsumer getDataConsumer();

        public DataAuditor getDataAuditor();

        public void addProducer(@NotNull DataProducer var1);

        public void beforeProducerRemove(@NotNull DataProducer var1);

        public void afterProducerRemove(@NotNull DataProducer var1);
    }

    public static interface Consuming {
        public Consuming filterFor(@NotNull DataRequest.OwnerEx var1);

        public DataProducer getDataProducer();

        public void addConsumer(@NotNull DataConsumer var1);

        public void addAuditor(@NotNull DataAuditor var1);
    }
}

