/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.dbm.common.DbmNode;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.util.SmartList;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class DumpModelEntityDebugAction
extends DumbAwareAction {
    private transient boolean useSurrogates = false;

    public void update(AnActionEvent e) {
        boolean ok = false;
        DataContext context = e.getDataContext();
        Set<DbElement> selection = DumpModelEntityDebugAction.getSelection(context);
        for (DbElement element : selection) {
            DbmNode node = DumpModelEntityDebugAction.originOf(element);
            if (node == null) continue;
            ok = true;
            break;
        }
        e.getPresentation().setEnabledAndVisible(ok);
    }

    public void actionPerformed(AnActionEvent e) {
        SmartList elementsToShow = new SmartList();
        DataContext context = e.getDataContext();
        Set<DbElement> selection = DumpModelEntityDebugAction.getSelection(context);
        for (DbElement element : selection) {
            DbmNode node = DumpModelEntityDebugAction.originOf(element);
            if (node == null) continue;
            elementsToShow.add(node);
        }
        if (elementsToShow.isEmpty()) {
            return;
        }
        Dump dump = new Dump((Collection<DbmNode>)elementsToShow);
        dump.doIt();
    }

    @NotNull
    private static Set<DbElement> getSelection(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/DumpModelEntityDebugAction", "getSelection"));
        }
        Set<DbElement> set = DatabaseView.getSelectedElements(context, DbElement.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DumpModelEntityDebugAction", "getSelection"));
        }
        return set;
    }

    private static DbmNode originOf(DbElement element) {
        DbElement el = element;
        while (el != null) {
            if (el instanceof DbmNode) {
                return (DbmNode)el;
            }
            Object delegate = el.getDelegate();
            if (delegate instanceof DbmNode) {
                return (DbmNode)delegate;
            }
            el = delegate instanceof DbElement ? (DbElement)delegate : null;
        }
        return null;
    }

    private final class Dump
    implements Disposable {
        private Collection<DbmNode> nodes;
        private final EditorFactory editorFactory;
        private final Document document;
        private final Editor viewer;
        private RefreshAction refreshAction;
        private transient boolean ready;

        public Dump(Collection<DbmNode> nodes) {
            if (nodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/database/actions/DumpModelEntityDebugAction$Dump", "<init>"));
            }
            this.ready = false;
            this.nodes = nodes;
            this.editorFactory = EditorFactory.getInstance();
            this.document = this.editorFactory.createDocument((CharSequence)"");
            this.viewer = this.editorFactory.createViewer(this.document);
        }

        public void doIt() {
            JComponent viewerComponent = this.viewer.getComponent();
            viewerComponent.setMinimumSize(new Dimension(200, 200));
            viewerComponent.setPreferredSize(new Dimension(500, 500));
            ToggleAction withSurrogatesAction = new ToggleAction("with synthetic stuff", "Include auto-generated objects and names", AllIcons.Webreferences.Server){

                public boolean isSelected(AnActionEvent e) {
                    return DumpModelEntityDebugAction.this.useSurrogates;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    DumpModelEntityDebugAction.this.useSurrogates = state;
                    Dump.this.populateDocument();
                }
            };
            this.refreshAction = new RefreshAction("Refresh", "", AllIcons.Actions.Refresh){

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(Dump.this.ready);
                }

                public void actionPerformed(AnActionEvent e) {
                    Dump.this.populateDocument();
                }
            };
            this.refreshAction.registerShortcutOn(viewerComponent);
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Smth", (ActionGroup)new DefaultActionGroup(new AnAction[]{withSurrogatesAction, this.refreshAction}), true);
            toolbar.setTargetComponent(viewerComponent);
            DialogBuilder dia = new DialogBuilder();
            dia.setTitle("Database Model Dump");
            dia.setNorthPanel(toolbar.getComponent());
            dia.setCenterPanel(viewerComponent);
            dia.setPreferredFocusComponent(this.viewer.getContentComponent());
            dia.addDisposable((Disposable)this);
            dia.setDimensionServiceKey(DumpModelEntityDebugAction.class.getSimpleName());
            dia.showNotModal();
            this.populateDocument();
        }

        private synchronized void populateDocument() {
            this.ready = false;
            final CodeTextBuilder ctb = new CodeTextBuilder();
            for (DbmNode element : this.nodes) {
                DbmUtil.describeRecursively(ctb, element, DumpModelEntityDebugAction.this.useSurrogates);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Dump.this.document.setText((CharSequence)ctb.toString());
                }
            });
            this.ready = true;
        }

        public void dispose() {
            this.editorFactory.releaseEditor(this.viewer);
        }
    }
}

