/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

public class ExplainPlanAction
extends QueryActionBase {
    @Override
    protected void invokeImpl(@NotNull AnActionEvent e, final JdbcConsole console, @NotNull JdbcConsoleProvider.Info info) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ExplainPlanAction", "invokeImpl"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/actions/ExplainPlanAction", "invokeImpl"));
        }
        final ExplainPlanProvider provider = ExplainPlanProvider.getProviderByClassName(console.getDataSource().getExplainPlanConfiguration().getProviderClass());
        if (provider == ExplainPlanProvider.NULL_PROVIDER) {
            return;
        }
        JdbcConsoleProvider.chooseStatements(info, "No query found", false, new Consumer<ScriptModel<?>>(){

            public void consume(ScriptModel<?> scriptModel) {
                ScriptModel<?> adjusted = provider.adjustModel(scriptModel);
                if (!console.beforeExecuteQueries(adjusted)) {
                    return;
                }
                for (ScriptModel.StatementIt it : adjusted.statements().asCursor()) {
                    try {
                        String text = it.text(console.getPStorage(), Conditions.alwaysFalse());
                        ExplainPlanAction.this.explainStatement(provider, console, text);
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage().contains("@NotNull")) {
                            throw ex;
                        }
                        Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)"Explain Plan Error");
                    }
                    catch (UnsupportedOperationException ex) {
                        Messages.showErrorDialog((Project)console.getProject(), (String)ex.getMessage(), (String)"Explain Plan Error");
                    }
                }
            }
        });
    }

    protected void explainStatement(@NotNull ExplainPlanProvider provider, final @NotNull JdbcConsole console, @NotNull String statement) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/actions/ExplainPlanAction", "explainStatement"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/actions/ExplainPlanAction", "explainStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/actions/ExplainPlanAction", "explainStatement"));
        }
        DataRequest.RawRequest request = provider.createExplainRequest(console, new Consumer<PlanModel>(){

            public void consume(final PlanModel model) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        console.showPlan(model);
                    }
                });
            }
        }, console.getDataSource(), statement, false);
        if (request == null) {
            return;
        }
        console.getMessageBus().getDataProducer().processRequest(request);
    }

    public static class Raw
    extends ExplainPlanAction {
        @Override
        protected void explainStatement(@NotNull ExplainPlanProvider provider, final @NotNull JdbcConsole console, @NotNull String script) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/actions/ExplainPlanAction$Raw", "explainStatement"));
            }
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/actions/ExplainPlanAction$Raw", "explainStatement"));
            }
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/actions/ExplainPlanAction$Raw", "explainStatement"));
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            StringBuilder sb = new StringBuilder();
            final DdlBuilder builder = new DdlBuilder(sb);
            builder.applyCodeStyle(console.getProject());
            dialect.sqlExplainPlan(builder, script, false);
            AsyncPromise<Void> promise = this.execute(console, builder.getStatement(), true);
            builder.clear();
            dialect.sqlPostExplainPlan(builder, false);
            promise.processed((Consumer)new Consumer<Void>(){

                public void consume(Void aVoid) {
                    this.execute(console, builder.getStatement(), false);
                }
            });
        }

        private AsyncPromise<Void> execute(@NotNull JdbcConsole console, @NotNull String script, boolean stopOnError) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/actions/ExplainPlanAction$Raw", "execute"));
            }
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/actions/ExplainPlanAction$Raw", "execute"));
            }
            SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)console.getProject());
            PsiFile psi = PsiFileFactory.getInstance((Project)console.getProject()).createFileFromText("a.sql", console.getLanguageConsole().getLanguage(), (CharSequence)script);
            ScriptModel model = facade.createScriptModel(psi);
            return this.perform(console, model.statements().asCursor().transform(ScriptModelUtil.TO_TEXT).iterator(), stopOnError);
        }

        AsyncPromise<Void> perform(final @NotNull JdbcConsole console, final @NotNull Iterator<String> it, final boolean stopOnError) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/actions/ExplainPlanAction$Raw", "perform"));
            }
            if (it == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/database/actions/ExplainPlanAction$Raw", "perform"));
            }
            if (!it.hasNext()) {
                return null;
            }
            String query = it.next();
            if (StringUtil.isEmptyOrSpaces((String)query)) {
                return this.perform(console, it, stopOnError);
            }
            DataRequest request = DataRequest.newRequest(console, console.getCurrentTx(), query);
            Consumer<Void> next = new Consumer<Void>(){

                public void consume(Void o) {
                    this.perform(console, it, stopOnError);
                }
            };
            if (stopOnError) {
                request.getPromise().done((Consumer)next);
            } else {
                request.getPromise().processed((Consumer)next);
            }
            console.getMessageBus().getDataProducer().processRequest(request);
            return request.getPromise();
        }
    }
}

