/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.AbstractTableDialog;
import com.intellij.database.view.ui.AbstractTableDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDbObjectGroup
extends ActionGroup {
    public static DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"GenerateDbObjectGroup.INTERCEPTOR");
    public static DataKey<DbRefactoringHelper.ObjectLocation> FORCED_LOCATION = DataKey.create((String)"DatabaseObjectRefactoring.FORCED_LOCATION");
    private final AnAction[] myChildren = new AnAction[]{new BaseGenerateDbObjectAction(ObjectKind.TABLE, DasNamespace.class, true){

        @Override
        @NotNull
        protected DeObject getEditedObject(@NotNull AbstractTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$1", "getEditedObject"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$1", "getEditedObject"));
            }
            DeObject deObject = dialog.createEmptyTemplate(parent);
            if (deObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$1", "getEditedObject"));
            }
            return deObject;
        }

        @Override
        @Nullable
        protected DeObject getObjectToSelect(@NotNull AbstractTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$1", "getObjectToSelect"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$1", "getObjectToSelect"));
            }
            return ((DatabaseTableEditor)dialog.getEditor()).getTable();
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.COLUMN, DasTable.class, false){

        @Override
        @Nullable
        protected DeColumn getObjectToSelect(@NotNull AbstractTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$2", "getObjectToSelect"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$2", "getObjectToSelect"));
            }
            Ref column = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withColumn("new_column")).addAndGet((Ref<DeColumn>)column)).leave()).commit();
            return (DeColumn)column.get();
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.INDEX, DasTable.class, false){

        @Override
        @Nullable
        protected DeIndex getObjectToSelect(final @NotNull AbstractTableDialog dialog, final @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$3", "getObjectToSelect"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$3", "getObjectToSelect"));
            }
            final DeTable table = ((DatabaseTableEditor)dialog.getEditor()).getTable();
            Ref index = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filter((Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    return object instanceof DasColumn && object.getDbParent() == parent;
                }
            })).transform((Function)new Function<DasObject, DeColumn>(){

                public DeColumn fun(DasObject object) {
                    DeColumn column = (DeColumn)dialog.exportOp(object, true);
                    column.table = table;
                    return column;
                }
            }), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)index)).leave()).commit();
            return (DeIndex)index.get();
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.FOREIGN_KEY, DasTable.class, false){

        @Override
        @Nullable
        protected DeObject getObjectToSelect(final @NotNull AbstractTableDialog dialog, final @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$4", "getObjectToSelect"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$4", "getObjectToSelect"));
            }
            final DeTable table = ((DatabaseTableEditor)dialog.getEditor()).getTable();
            Ref fk = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filter((Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    return object instanceof DasColumn && object.getDbParent() == parent;
                }
            })).transform((Function)new Function<DasObject, DeColumn>(){

                public DeColumn fun(DasObject object) {
                    DeColumn column = (DeColumn)dialog.exportOp(object, true);
                    column.table = table;
                    return column;
                }
            }))).addAndGet((Ref<DeForeignKey>)fk)).leave()).commit();
            return (DeObject)fk.get();
        }
    }};

    private static boolean checkFile(DataContext dataContext) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return file != null && file.getLanguage() instanceof SqlLanguageDialect || element != null && element.getLanguage() instanceof SqlLanguageDialect;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible(GenerateDbObjectGroup.checkFile(e.getDataContext()));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup", "getChildren"));
        }
        return this.myChildren;
    }

    public static abstract class BaseGenerateDbObjectAction
    extends DumbAwareAction {
        @NotNull
        private final ObjectKind myKind;
        private final Class<? extends DasObject> myParentClass;
        private final boolean myParentNullable;

        protected BaseGenerateDbObjectAction(@NotNull ObjectKind kind, @NotNull Class<? extends DasObject> parentClass, boolean parentNullable) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "<init>"));
            }
            if (parentClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "<init>"));
            }
            super(DatabaseObjectRefactoring.getKindTitle(kind));
            this.myKind = kind;
            this.myParentClass = parentClass;
            this.myParentNullable = parentNullable;
        }

        protected boolean isEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "isEnabled"));
            }
            if (!GenerateDbObjectGroup.checkFile(dataContext)) {
                return false;
            }
            DasObject object = this.getObject(dataContext);
            if (object == null) {
                return this.myParentNullable;
            }
            if (this.getSupportedLocations(DbRefactoringHelper.ObjectLocation.of(object)).isEmpty()) {
                return false;
            }
            if (this.createContext(dataContext) == null) {
                return false;
            }
            return this.myParentClass.isAssignableFrom(object.getClass());
        }

        @NotNull
        protected JBIterable<DbRefactoringHelper.ObjectLocation> getSupportedLocations(@Nullable DbRefactoringHelper.ObjectLocation objectLocation) {
            JBIterable jBIterable = JBIterable.of((Object[])new DbRefactoringHelper.ObjectLocation[]{(DbRefactoringHelper.ObjectLocation)((Object)ObjectUtils.chooseNotNull((Object)((Object)objectLocation), (Object)((Object)DbRefactoringHelper.ObjectLocation.CODE)))});
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getSupportedLocations"));
            }
            return jBIterable;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.isEnabled(e.getDataContext()));
        }

        public void actionPerformed(final AnActionEvent e) {
            if (!this.isEnabled(e.getDataContext())) {
                return;
            }
            DbRefactoringHelper.ObjectLocation forcedLocation = (DbRefactoringHelper.ObjectLocation)((Object)FORCED_LOCATION.getData(e.getDataContext()));
            Consumer dialogInterceptor = (Consumer)INTERCEPTOR.getData(e.getDataContext());
            final DatabaseEditorContext context = this.createContext(e.getDataContext());
            if (context == null) {
                return;
            }
            final DasObject object = this.getObject(e.getDataContext());
            List<DbRefactoringHelper.ObjectLocation> locations = this.getSupportedLocations(DbRefactoringHelper.ObjectLocation.of(object)).toList();
            if (locations.isEmpty()) {
                return;
            }
            if (forcedLocation != null) {
                locations = Collections.singletonList(forcedLocation);
            }
            if (locations.size() == 1) {
                AbstractTableDialog dialog = this.prepare(object, context, e.getDataContext(), locations.get(0));
                if (dialogInterceptor != null) {
                    dialogInterceptor.consume((Object)dialog);
                } else {
                    dialog.finishAndShow();
                }
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<DbRefactoringHelper.ObjectLocation>("Add definition to:", locations){

                public Icon getIconFor(DbRefactoringHelper.ObjectLocation value) {
                    if (value == DbRefactoringHelper.ObjectLocation.DATABASE) {
                        return DatabaseIcons.Dbms;
                    }
                    if (value == DbRefactoringHelper.ObjectLocation.CODE) {
                        return DatabaseIcons.Sql;
                    }
                    return null;
                }

                @NotNull
                public String getTextFor(DbRefactoringHelper.ObjectLocation value) {
                    String string = value.toString() + "...";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction$1", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(final DbRefactoringHelper.ObjectLocation selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            this.prepare(object, context, e.getDataContext(), selectedValue).finishAndShow();
                        }
                    });
                }
            }).showInBestPositionFor(e.getDataContext());
        }

        @NotNull
        protected AbstractTableDialog prepare(final @Nullable DasObject object, @NotNull DatabaseEditorContext context, final @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "prepare"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "prepare"));
            }
            if (genLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genLocation", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "prepare"));
            }
            final AbstractTableDialog dialog = new AbstractTableDialog(context);
            BaseGenerateDbObjectAction.setProcessor(dialog, dataContext, genLocation);
            dialog.configureForCreation(this.getEditedObject(dialog, object, dataContext), this.isForceCreate(genLocation));
            AbstractTableDialogHelper.bootstrap(dialog, new Computable<DeObject>(){

                public DeObject compute() {
                    return this.getObjectToSelect(dialog, object, dataContext);
                }
            });
            AbstractTableDialog abstractTableDialog = dialog;
            if (abstractTableDialog == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "prepare"));
            }
            return abstractTableDialog;
        }

        protected boolean isForceCreate(@NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (genLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genLocation", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "isForceCreate"));
            }
            return genLocation == DbRefactoringHelper.ObjectLocation.CODE;
        }

        @Nullable
        public DatabaseEditorContext createContext(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "createContext"));
            }
            DasObject object = this.getObject(dataContext);
            PsiElement place = BaseGenerateDbObjectAction.getPlace(dataContext);
            if (object != null) {
                return DbRefactoringHelper.createContext(object, place);
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), SqlFile.class);
            if (file == null) {
                return null;
            }
            return DatabaseEditorContext.forFile(file);
        }

        @Nullable
        private static PsiElement getPlace(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getPlace"));
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            return editor == null || file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        }

        private static void setProcessor(@NotNull AbstractTableDialog dialog, @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "setProcessor"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "setProcessor"));
            }
            if (genLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genLocation", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "setProcessor"));
            }
            RangeMarker place = DbRefactoringHelper.getPlace(BaseGenerateDbObjectAction.getPlace(dataContext));
            if (genLocation == DbRefactoringHelper.ObjectLocation.CODE) {
                dialog.setResultProcessor(new GenericEditingResultProcessor(dialog, DbRefactoringHelper.SQL_SETTINGS, place));
            } else {
                dialog.setResultProcessor(new GenericEditingResultProcessor(dialog, DbRefactoringHelper.DB_SETTINGS, place));
            }
        }

        @NotNull
        protected DeObject getEditedObject(@NotNull AbstractTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getEditedObject"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getEditedObject"));
            }
            Object De = dialog.export((DasObject)ObjectUtils.assertNotNull((Object)parent), true);
            if (De == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getEditedObject"));
            }
            return De;
        }

        @Nullable
        protected abstract DeObject getObjectToSelect(@NotNull AbstractTableDialog var1, @Nullable DasObject var2, @NotNull DataContext var3);

        @Nullable
        protected DasObject getObject(@NotNull DataContext dataContext) {
            DasObject object;
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getObject"));
            }
            for (object = DatabaseObjectRefactoring.getDasObject(dataContext); object != null && !this.myParentClass.isAssignableFrom(object.getClass()); object = object.getDbParent()) {
            }
            return object;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.myKind;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction", "getKind"));
            }
            return objectKind;
        }
    }
}

