/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.view.generators.DatabaseViewExtensionScripts;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExtensionScriptActionGroup
extends ActionGroup {
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(DatabaseViewExtensionScripts.areAvailableIn(e.getDataContext()));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List runActions = ContainerUtil.map(DatabaseViewExtensionScripts.getScriptFiles(), (Function)new Function<VirtualFile, RunScriptAction>(){

            public RunScriptAction fun(VirtualFile script) {
                return new RunScriptAction(script);
            }
        });
        List allActions = ContainerUtil.append((List)runActions, (Object[])new AnAction[]{new Separator(), new EditScriptsAction()});
        AnAction[] anActionArray = (AnAction[])ContainerUtil.toArray((List)allActions, (Object[])new AnAction[allActions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/RunExtensionScriptActionGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static class RunScriptAction
    extends DumbAwareAction {
        private final VirtualFile myScript;

        private RunScriptAction(@NotNull VirtualFile script) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/actions/RunExtensionScriptActionGroup$RunScriptAction", "<init>"));
            }
            super(script.getName(), "Execute extension script", null);
            this.myScript = script;
        }

        public void actionPerformed(AnActionEvent e) {
            DatabaseViewExtensionScripts.runScript(e.getDataContext(), this.myScript);
        }
    }

    private static class EditScriptsAction
    extends DumbAwareAction {
        public EditScriptsAction() {
            super("Go to Scripts Directory", "", null);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            VirtualFile scriptsDir = DatabaseViewExtensionScripts.getScriptsDirectory();
            if (project != null && scriptsDir != null) {
                new OpenFileDescriptor(project, scriptsDir).navigate(true);
            }
        }
    }
}

