/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class RunSqlScriptAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "update"));
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).transform(RunSqlScriptAction.FILE_TRANSFORM(project)).filter(Conditions.notNull());
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = !RunSqlScriptAction.getDataSources((JBIterable<PsiFile>)files).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(true);
        String title = files.size() == 1 ? ((PsiFile)files.iterator().next()).getName() : files.size() + " files";
        e.getPresentation().setText(String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20))));
    }

    @NotNull
    public static Function<VirtualFile, PsiFile> FILE_TRANSFORM(final Project project) {
        if (project == null) {
            Function function = Functions.constant(null);
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/RunSqlScriptAction", "FILE_TRANSFORM"));
            }
            return function;
        }
        Function<VirtualFile, PsiFile> function = new Function<VirtualFile, PsiFile>(){
            PsiManager psiManager;
            LanguageFileType sqlFileType;
            {
                this.psiManager = PsiManager.getInstance((Project)project);
                this.sqlFileType = SqlLanguage.INSTANCE.getAssociatedFileType();
            }

            public PsiFile fun(VirtualFile file) {
                if (!file.isValid()) {
                    return null;
                }
                if (file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)file).isBusy()) {
                    return null;
                }
                PsiFile psiFile = this.psiManager.findFile(file);
                if (psiFile instanceof SqlFile || file.getFileType() == this.sqlFileType || LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == this.sqlFileType) {
                    return psiFile;
                }
                return null;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/RunSqlScriptAction", "FILE_TRANSFORM"));
        }
        return function;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "actionPerformed"));
        }
        final Project project = e.getProject();
        final JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).transform(RunSqlScriptAction.FILE_TRANSFORM(project)).filter(Conditions.notNull());
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String title = files.size() == 1 ? ((PsiFile)files.iterator().next()).getName() : files.size() + " files";
        final String taskName = String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20)));
        List<DbDataSource> dataSources = RunSqlScriptAction.getDataSources((JBIterable<PsiFile>)files);
        RunSqlScriptAction.chooseDataSourceAndRun(project, e.getDataContext(), dataSources, new Processor<List<LocalDataSource>>(){

            public boolean process(List<LocalDataSource> dataSources) {
                RunSqlScriptAction.perform(project, taskName, (JBIterable<PsiFile>)files, dataSources);
                return true;
            }
        });
    }

    @NotNull
    private static List<DbDataSource> getDataSources(@NotNull JBIterable<PsiFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        boolean first = true;
        ArrayList dataSources = ContainerUtil.newArrayList();
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            PsiFile file;
            boolean isDbFile = (file = (PsiFile)iterator.next()).getVirtualFile() instanceof DatabaseElementVirtualFileImpl;
            JBIterable<DbDataSource> o = DbImplUtil.getDataSourcesForExec(file, !isDbFile, isDbFile);
            if (first) {
                o.addAllTo((Collection)dataSources);
            } else {
                dataSources.retainAll(o.toList());
            }
            first = false;
        }
        ArrayList arrayList = dataSources;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        return arrayList;
    }

    public static void perform(final @NotNull Project project, final @NotNull String taskName, @NotNull JBIterable<PsiFile> files, final @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        final List models = files.transform(new Function<PsiFile, ScriptModel<?>>(){
            SqlPsiFacade facade;
            {
                this.facade = SqlPsiFacade.getInstance((Project)project);
            }

            public ScriptModel<?> fun(PsiFile file) {
                return this.facade.createScriptModel(file);
            }
        }).toList();
        final Ref reporter = Ref.create(null);
        final AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, taskName, true, null){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$4$1", "run"));
                        }
                        indicatorRef.set(indicator);
                        indicator.setFraction(0.0);
                        for (ScriptModel scriptModel : models) {
                            VirtualFile virtualFile = scriptModel.getVirtualFile();
                            String title = "Run " + virtualFile.getPresentableUrl();
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.ConsoleLogger)reporter.get(), title);
                            try {
                                this.runImpl(scriptModel, indicator);
                            }
                            catch (ProcessCanceledException e) {
                                RunSqlScriptAction.reportAndLog(project, (DataAuditor.ConsoleLogger)reporter.get(), "Cancelled");
                            }
                            finally {
                                Disposer.dispose((Disposable)scriptModel);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void runImpl(ScriptModel<?> scriptModel, ProgressIndicator indicator) {
                        long[] counter = new long[]{0L, 0L, 0L};
                        long total = 0L;
                        long t0 = System.currentTimeMillis();
                        for (LocalDataSource dataSource : dataSources) {
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.ConsoleLogger)reporter.get(), "Connecting to " + dataSource.getName() + "...");
                            try {
                                RunSqlScriptAction.runStatements(project, dataSource, scriptModel, (DataAuditor.ConsoleLogger)reporter.get(), indicator, counter, models.size() * dataSources.size());
                            }
                            finally {
                                if (dataSource.isAutoSynchronize()) {
                                    DataSourceUiUtil.refreshDatasourceEDT(this.getProject(), dataSource);
                                }
                            }
                            if (total != 0L) continue;
                            total = counter[0] * (long)dataSources.size();
                        }
                        long t3 = System.currentTimeMillis() - t0;
                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.ConsoleLogger)reporter.get(), "Summary: " + counter[0] + " of " + total + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t3) + " (" + counter[2] + " symbols in file)");
                    }
                });
            }
        };
        ConsoleView consoleView = RunSqlScriptAction.addConsole(project, taskName, files, runnable, indicatorRef);
        reporter.set((Object)new DataAuditor.ConsoleLogger(consoleView));
        runnable.run();
    }

    private static void reportAndLog(Project project, DataAuditor.ConsoleLogger logger, String message) {
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.INFO).notify(project);
        logger.print(message);
    }

    private static ConsoleView addConsole(Project project, String taskName, final @NotNull JBIterable<PsiFile> files, final Runnable rerunRunnable, final AtomicReference<ProgressIndicator> indicatorRef) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        final ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)consoleView.getComponent(), "Center");
        consoleComponent.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false).getComponent(), "West");
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, taskName){

            public boolean isContentReuseProhibited() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                return indicator != null && indicator.isRunning();
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }
        });
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new DumbAwareAction("Rerun", null, AllIcons.Actions.Rerun){

            public void update(@NotNull AnActionEvent e) {
                PsiFile file;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$7", "update"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                boolean enabled = indicator == null || !indicator.isRunning();
                Iterator iterator = files.iterator();
                while (iterator.hasNext() && (enabled &= (file = (PsiFile)iterator.next()).isValid())) {
                }
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$7", "actionPerformed"));
                }
                consoleView.clear();
                rerunRunnable.run();
            }
        });
        toolbarActions.add((AnAction)new DumbAwareAction("Stop", null, AllIcons.Actions.Suspend){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$8", "update"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                e.getPresentation().setEnabled(indicator != null && indicator.isRunning());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$8", "actionPerformed"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                    consoleView.print("\nExecution aborted\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            }
        });
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        for (AnAction action : consoleView.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        return consoleView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runStatements(Project project, LocalDataSource dataSource, ScriptModel<?> scriptModel, DataAuditor.ConsoleLogger reporter, ProgressIndicator progress, long[] counter, int progressMultiplier) {
        Connection connection = null;
        try {
            DbElement element;
            progress.checkCanceled();
            progress.setText(dataSource.getName());
            connection = dataSource.getConnection(project);
            if (connection == null) {
                reporter.error("Unable to acquire connection", null);
                return;
            }
            VirtualFile virtualFile = scriptModel.getVirtualFile();
            DbElement dbElement = element = virtualFile instanceof DatabaseElementVirtualFileImpl ? ((DatabaseElementVirtualFileImpl)virtualFile).findElement() : null;
            if (element != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe(element, connection);
            }
            long fileSize = virtualFile.getLength();
            double averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
            counter[2] = 0L;
            ScriptModel.StatementIt it = scriptModel.statements();
            while (it.hasNext()) {
                progress.checkCanceled();
                it.next();
                long curOffset = it.rangeOffset() + (long)it.range().getEndOffset();
                String sql = it.text();
                progress.checkCanceled();
                reporter.printInput(StringUtil.first((String)sql, (int)10240, (boolean)true));
                counter[0] = counter[0] + 1L;
                counter[2] = counter[2] + (long)sql.length();
                progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                if (!RunSqlScriptAction.executeStatement(connection, sql, dataSource, reporter)) {
                    counter[1] = counter[1] + 1L;
                }
                double fraction = (double)curOffset * averageBytesPerChar / (double)fileSize / (double)progressMultiplier;
                progress.setFraction(fraction);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (ExecutionException e) {
            reporter.error(e.getMessage(), null);
        }
        catch (TooLongStatementException e) {
            reporter.error(e.getMessage() + ". Increasing memory via -Xmx may help. Aborting.", null);
        }
        catch (Exception e) {
            reporter.error(null, e);
        }
        finally {
            if (scriptModel != null) {
                Disposer.dispose(scriptModel);
            }
            if (connection != null) {
                dataSource.releaseConnection(project, connection);
            }
        }
        reporter.print("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeStatement(@NotNull Connection connection, @NotNull String sql, @NotNull LocalDataSource dataSource, @NotNull DataAuditor.ConsoleLogger reporter) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/RunSqlScriptAction", "executeStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/RunSqlScriptAction", "executeStatement"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/RunSqlScriptAction", "executeStatement"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/database/console/RunSqlScriptAction", "executeStatement"));
        }
        Statement statement = null;
        try {
            int updateCount;
            statement = connection.createStatement();
            long timestamp = System.currentTimeMillis();
            statement.execute(sql);
            ResultSet resultSet = statement.getResultSet();
            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
            String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
            int n = updateCount = resultSet == null ? statement.getUpdateCount() : 0;
            if (resultSet != null) {
                reporter.print("Executed in " + executionTime + " ms");
            } else {
                reporter.print(updateCount + " row(s) affected in " + executionTime + " ms");
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            reporter.error(JdbcEngine.getErrorMessage(e, null, dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource)), null);
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    private static void chooseDataSourceAndRun(Project project, DataContext context, List<DbDataSource> dataSources, Processor<List<LocalDataSource>> processor) {
        if (dataSources.size() == 1) {
            processor.process(Collections.singletonList((LocalDataSource)((Object)dataSources.get(0).getDelegate())));
            return;
        }
        Collections.sort(dataSources, new Comparator<DasObject>(){

            @Override
            public int compare(DasObject p1, DasObject p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        JBList list = new JBList(dataSources.toArray());
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        final boolean useColors = state.useColors && state.inDatabaseView;
        list.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                Color bg;
                DbDataSource dataSource = (DbDataSource)value;
                this.setIcon(dataSource.getIcon());
                String name = dataSource.getName();
                if (DbImplUtil.isConnected((DbElement)dataSource)) {
                    this.append(name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(name);
                }
                Color color = bg = !selected && useColors ? DatabaseColorManager.getColor((DbElement)dataSource) : null;
                if (bg != null) {
                    this.setBackground(bg);
                }
            }
        });
        new PopupChooserBuilder((JList)list).setTitle("Choose Data Source").setMovable(true).setItemChoosenCallback(new Runnable((JList)list, processor){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Processor val$processor;
            {
                this.val$list = jList;
                this.val$processor = processor;
            }

            @Override
            public void run() {
                List sources = JBIterable.of((Object[])this.val$list.getSelectedValues()).transform((Function)new Function<Object, LocalDataSource>(){

                    public LocalDataSource fun(Object o) {
                        return (LocalDataSource)((Object)((DbDataSource)o).getDelegate());
                    }
                }).toList();
                this.val$processor.process((Object)sources);
            }
        }).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((DasObject)o).getName();
            }
        }).createPopup().showInBestPositionFor(context);
    }
}

