/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementHighlightingPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private static final HighlightInfoType HIGH_PRIORITY_TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, DatabaseColors.CONSOLE_RANGE_TO_EXECUTE);
    private static final HighlightInfoType LOW_PRIORITY_TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, DatabaseColors.CONSOLE_RANGE_TO_EXECUTE);

    public StatementHighlightingPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file, final @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/StatementHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/StatementHighlightingPassFactory", "createHighlightingPass"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        if (!(file instanceof SqlFile) && !(file instanceof PsiPlainTextFile)) {
            return null;
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !FileEditorManager.getInstance((Project)this.myProject).isFileOpen(virtualFile)) {
            return null;
        }
        return new TextEditorHighlightingPass(file.getProject(), editor.getDocument(), false){
            private TextRange myStatementRange;

            public void doCollectInformation(@NotNull ProgressIndicator progress) {
                JdbcConsoleProvider.Info info;
                if (progress == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/database/console/StatementHighlightingPassFactory$1", "doCollectInformation"));
                }
                this.myStatementRange = null;
                DatabaseSettings settings = DatabaseSettings.getSettings();
                if (settings.executeInsideOption == 5) {
                    return;
                }
                JdbcConsole console = JdbcConsoleProvider.getSelfOrAttachedConsole(file);
                if (console == null) {
                    return;
                }
                PsiElement elementAt = JdbcConsoleProvider.elementAt(file, null, editor);
                JdbcConsoleProvider.Info info2 = info = elementAt != null ? JdbcConsoleProvider.findScriptModel(file, elementAt, editor) : null;
                if (info == null) {
                    return;
                }
                JdbcConsoleProvider.chooseStatements(info, null, false, new Consumer<ScriptModel<?>>(){

                    public void consume(ScriptModel<?> model) {
                        int start = -1;
                        int end = -1;
                        for (TextRange r : model.statements().asCursor().transform(ScriptModelUtil.TO_RANGE)) {
                            if (start < 0) {
                                start = r.getStartOffset();
                            }
                            end = r.getEndOffset();
                        }
                        if (start >= 0 && end >= 0) {
                            myStatementRange = TextRange.create((int)start, (int)end);
                        }
                    }
                });
            }

            public void doApplyInformationToEditor() {
                ArrayList infos;
                Document document = editor.getDocument();
                if (this.myStatementRange == null || this.myStatementRange.isEmpty()) {
                    infos = Collections.emptyList();
                } else {
                    int lastLine;
                    Color bg = editor.getColorsScheme().getAttributes(DatabaseColors.CONSOLE_RANGE_TO_EXECUTE).getBackgroundColor();
                    infos = ContainerUtil.newArrayListWithCapacity((int)3);
                    int start = this.myStatementRange.getStartOffset();
                    int end = this.myStatementRange.getEndOffset();
                    int firstLine = document.getLineNumber(start);
                    infos.add(this.createInfo(firstLine == (lastLine = document.getLineNumber(end)) || bg == null ? HIGH_PRIORITY_TYPE : LOW_PRIORITY_TYPE, start, end, null));
                    if (firstLine != lastLine && bg != null) {
                        infos.add(this.createInfo(HIGH_PRIORITY_TYPE, start, document.getLineEndOffset(firstLine), bg));
                        infos.add(this.createInfo(HIGH_PRIORITY_TYPE, document.getLineStartOffset(lastLine), end, bg));
                    }
                }
                UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)document, (int)0, (int)file.getTextLength(), (Collection)infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
            }

            @NotNull
            private HighlightInfo createInfo(HighlightInfoType type, int start, int end, @Nullable Color forcedBg) {
                HighlightInfo.Builder b = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(start, end);
                if (forcedBg != null) {
                    HighlightInfo highlightInfo = b.textAttributes(new TextAttributes(null, forcedBg, null, null, 0)).createUnconditionally();
                    if (highlightInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/StatementHighlightingPassFactory$1", "createInfo"));
                    }
                    return highlightInfo;
                }
                HighlightInfo highlightInfo = b.createUnconditionally();
                if (highlightInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/StatementHighlightingPassFactory$1", "createInfo"));
                }
                return highlightInfo;
            }
        };
    }
}

