/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TableCsvFormatPreview
implements CsvFormatPreview {
    private final DataGrid myGrid;

    public TableCsvFormatPreview(@NotNull Project project, @NotNull CsvFormat format, @NotNull CharSequence text, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "<init>"));
        }
        Document document = EditorFactory.getInstance().createDocument(text);
        document.setReadOnly(true);
        CsvDocumentDataHookUp hookup = new CsvDocumentDataHookUp(project, format, document, null);
        Disposer.register((Disposable)parent, (Disposable)hookup);
        this.myGrid = DataGridUtil.createPreviewDataGrid(project, hookup);
        Disposer.register((Disposable)parent, (Disposable)this.myGrid);
        Disposer.register((Disposable)parent, (Disposable)new UiNotifyConnector.Once((Component)this.myGrid.getComponent(), (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                TableCsvFormatPreview.this.getHookUp().getLoader().loadFirstPage(GridRequestSource.create(TableCsvFormatPreview.this.myGrid, null));
            }
        }));
    }

    @Override
    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "setFormat"));
        }
        this.getHookUp().setFormat(format);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myGrid.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    private CsvDocumentDataHookUp getHookUp() {
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.myGrid.getDataHookup();
        if (csvDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/preview/TableCsvFormatPreview", "getHookUp"));
        }
        return csvDocumentDataHookUp;
    }
}

