/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SettingsTableView;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;

public class DataSourceSchemasPanel {
    public static final String SCHEMA_LOADING_ERROR = "SCHEMA_LOADING_ERROR";
    private final DataSourceConfigurable myDialog;
    private JPanel myRootPanel;
    private JPanel myTablePanel;
    private JBCheckBox myLegacyIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private final TableView<String> mySchemasTable;
    private final JBLoadingPanel myLoadingPanel;
    private final DefaultsInstaller myDefaultsInstaller;
    private Object mySavedKey;

    public DataSourceSchemasPanel(DataSourceConfigurable dialog) {
        String defSchemas;
        this.myDialog = dialog;
        this.$$$setupUI$$$();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.myDialog);
        this.mySchemasTable = new SettingsTableView<String>();
        this.myLoadingPanel.add((Component)ScrollPaneFactory.createScrollPane(this.mySchemasTable));
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myTablePanel.add((Component)this.myLoadingPanel, "Center");
        LocalDataSource dataSource = (LocalDataSource)((Object)this.myDialog.getDataSource());
        this.myDefaultsInstaller = new DefaultsInstaller(dataSource);
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getTablePattern()));
        final Runnable action = RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null);
        this.myObjectFilterHelp.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    action.run();
                }
            }
        });
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        this.myLegacyIntrospector.setVisible(rdbms != null);
        this.myLegacyIntrospector.setSelected(dataSource.useLegacyIntrospector());
        String schemas = dataSource.getSchemaPattern();
        if (schemas != null) {
            this.myDefaultsInstaller.getSelectedSchemas().addAll(Arrays.asList(DatabaseModelLegacyLoader.splitSchemaPattern(schemas)));
        }
        if ((defSchemas = dataSource.getDefaultSchemas()) != null) {
            this.myDefaultsInstaller.getDefaultSchemas().addAll(Arrays.asList(DatabaseModelLegacyLoader.splitSchemaPattern(defSchemas)));
        }
        this.setupTableView();
    }

    private void setupTableView() {
        new TableSpeedSearch(this.mySchemasTable);
        final DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect((RawConnectionConfig)this.myDialog.getDataSource()), (Object)GenericDialect.INSTANCE);
        Set namespaces = dialect.getMetaModel().getNamespaces();
        final String columnTitle = StringUtil.join((Collection)namespaces, (Function)new Function<ObjectKind, String>(){

            public String fun(ObjectKind kind) {
                return StringUtil.capitalize((String)StringUtil.pluralize((String)DbPresentation.getPresentableName((ObjectKind)kind, (DatabaseDialect)dialect)));
            }
        }, (String)" and ");
        boolean visible = !namespaces.isEmpty();
        this.mySchemasTable.setVisible(visible);
        this.mySchemasTable.setSelectionMode(0);
        this.mySchemasTable.setCellSelectionEnabled(true);
        this.mySchemasTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new MyColumnInfo(" ", (Set<String>)this.myDefaultsInstaller.getAllSchemas(), this.myDefaultsInstaller.getSelectedSchemas()), new ColumnInfo<String, String>(columnTitle){

            public String valueOf(String s) {
                return s;
            }
        }, new MyColumnInfo("Resolve unqualified references", this.myDefaultsInstaller.getSelectedSchemas(), this.myDefaultsInstaller.getDefaultSchemas())}));
        ((JLabel)((Object)this.mySchemasTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        int borderWidth = 6;
        TableUtil.setupCheckboxColumn((TableColumn)this.mySchemasTable.getColumnModel().getColumn(0), (int)borderWidth);
        this.mySchemasTable.getEmptyText().setText("");
        if (!visible) {
            return;
        }
        new UiNotifyConnector((Component)this.myRootPanel, new Activatable(){

            public void showNotify() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataSourceSchemasPanel.this.refreshSchemas(Case.LOWER.apply(columnTitle));
                    }
                }, ModalityState.current());
            }

            public void hideNotify() {
            }
        });
        this.mySchemasTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$5", "keyPressed"));
                }
                if (e.getKeyCode() == 32) {
                    int affectedCol;
                    int row = DataSourceSchemasPanel.this.mySchemasTable.getSelectedRow();
                    int col = DataSourceSchemasPanel.this.mySchemasTable.getSelectedColumn();
                    if (row == -1 || col == -1) {
                        return;
                    }
                    int modelCol = DataSourceSchemasPanel.this.mySchemasTable.convertColumnIndexToModel(col);
                    boolean checkBoxes = modelCol == 0 || modelCol == 2;
                    int n = affectedCol = checkBoxes ? col : DataSourceSchemasPanel.this.mySchemasTable.convertColumnIndexToView(0);
                    if (!DataSourceSchemasPanel.this.mySchemasTable.isCellEditable(row, affectedCol)) {
                        return;
                    }
                    Object value = DataSourceSchemasPanel.this.mySchemasTable.getValueAt(row, affectedCol);
                    DataSourceSchemasPanel.this.mySchemasTable.setValueAt((Object)(value == null || Boolean.FALSE.equals(value) ? 1 : 0), row, affectedCol);
                }
            }
        });
    }

    public void refreshSchemas(final String columnTitle) {
        boolean emptyProps;
        final LocalDataSource tempDataSource = this.myDialog.getTempDataSourceForConnection();
        boolean bl = emptyProps = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl());
        if (emptyProps) {
            this.mySchemasTable.getListTableModel().setItems(Collections.emptyList());
        }
        if (emptyProps) {
            this.mySchemasTable.getEmptyText().setText("No " + columnTitle);
            return;
        }
        Object newSavedUrl = this.myDialog.createKey(tempDataSource);
        if (Comparing.equal((Object)this.mySavedKey, (Object)newSavedUrl)) {
            return;
        }
        this.mySchemasTable.getEmptyText().setText("");
        this.mySavedKey = newSavedUrl;
        final Ref currentCatalogRef = Ref.create();
        final ModalityState state = ModalityState.current();
        final Project project = this.myDialog.getProject();
        this.myLoadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Connection connection;
                Ref exRef;
                block5: {
                    exRef = Ref.create(null);
                    connection = null;
                    connection = tempDataSource.getConnection(project);
                    if (connection != null) break block5;
                    Runnable runnable = new Runnable(exRef){
                        final /* synthetic */ Ref val$exRef;
                        {
                            this.val$exRef = ref;
                        }

                        @Override
                        public void run() {
                            if (Disposer.isDisposed((Disposable)DataSourceSchemasPanel.this.myDialog)) {
                                return;
                            }
                            if (!Comparing.equal((Object)DataSourceSchemasPanel.this.mySavedKey, (Object)DataSourceSchemasPanel.this.myDialog.createKey(tempDataSource))) {
                                return;
                            }
                            DataSourceSchemasPanel.this.myLoadingPanel.stopLoading();
                            Exception ex = this.val$exRef.get() instanceof ProcessCanceledException ? null : (Exception)this.val$exRef.get();
                            String emptyText = ex == null ? "No " + columnTitle + " Found" : "Error Loading " + columnTitle;
                            DataSourceSchemasPanel.this.mySchemasTable.getEmptyText().setText(emptyText);
                            if (tempDataSource.getFirstSync() == ThreeState.YES) {
                                tempDataSource.setFirstSync(ThreeState.NO);
                            }
                            DataSourceSchemasPanel.this.mySchemasTable.getListTableModel().setItems(DataSourceSchemasPanel.this.myDefaultsInstaller.getAllSchemas());
                            DataSourceSchemasPanel.this.addNecessaryOnes(DataSourceSchemasPanel.this.myDefaultsInstaller.getSelectedSchemas(), 0);
                            DataSourceSchemasPanel.this.addNecessaryOnes(DataSourceSchemasPanel.this.myDefaultsInstaller.getDefaultSchemas(), 2);
                            if (ex != null) {
                                DataSourceSchemasPanel.this.myDialog.showErrorNotification(ex, DataSourceSchemasPanel.SCHEMA_LOADING_ERROR);
                            } else {
                                DataSourceSchemasPanel.this.myDialog.updateDatabaseInfo(tempDataSource);
                                DataSourceSchemasPanel.this.myDialog.showErrorNotification(null, DataSourceSchemasPanel.SCHEMA_LOADING_ERROR);
                            }
                            DataSourceSchemasPanel.this.myDialog.fireStateChanged();
                        }
                    };
                    if (!project.isOpen()) return;
                    tempDataSource.releaseConnection(project, connection);
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                    return;
                }
                try {
                    DataSourceSchemasPanel.this.myDefaultsInstaller.loadSchemaNames(connection);
                    DataSourceSchemasPanel.this.myDefaultsInstaller.setupDefaults(connection, DataSourceSchemasPanel.this.myDialog.getUserName());
                    currentCatalogRef.set((Object)connection.getCatalog());
                }
                catch (Exception e) {
                    try {
                        exRef.set((Object)e);
                    }
                    catch (Throwable throwable) {
                        Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                        if (!project.isOpen()) throw throwable;
                        tempDataSource.releaseConnection(project, connection);
                        ApplicationManager.getApplication().invokeLater(runnable, state);
                        throw throwable;
                    }
                    Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                    if (!project.isOpen()) return;
                    tempDataSource.releaseConnection(project, connection);
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                    return;
                }
                Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                if (!project.isOpen()) return;
                tempDataSource.releaseConnection(project, connection);
                ApplicationManager.getApplication().invokeLater(runnable, state);
                return;
            }
        });
    }

    private void addNecessaryOnes(Set<String> schemas, int columnIndex) {
        List items = this.mySchemasTable.getListTableModel().getItems();
        for (String schema : ArrayUtil.toStringArray(schemas)) {
            int rowIndex = items.indexOf(schema);
            if (rowIndex < 0) continue;
            this.mySchemasTable.getModel().setValueAt(true, rowIndex, columnIndex);
        }
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSchemasPanel", "saveData"));
        }
        new DefaultsInstaller(dataSource, this.myDefaultsInstaller.getAllSchemas(), this.myDefaultsInstaller.getDefaultSchemas(), this.myDefaultsInstaller.getSelectedSchemas()).saveSchemas();
        dataSource.setTablePattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myLegacyIntrospector.isSelected());
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor((Function)new Function<String, List<String>>(){

            public List<String> fun(String s) {
                return JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList();
            }
        }, (Function)new Function<List<String>, String>(){

            public String fun(List<String> strings) {
                return StringUtil.join((Iterable)JBIterable.from(strings).transform(StringUtil.TRIMMER), (String)"||");
            }
        });
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol><li>&lt;type&gt; is a <b>table</b>, <b>view</b>, <b>mview</b>, <b>sequence</b>, <b>routine</b>, <b>package</b> or <b>synonym</b></li><li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b>");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12), null, 0, 0, null, null));
        this.myLegacyIntrospector = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use legacy introspector (not recommended)");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel3.add((Component)jEditorPane, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 0, null, new Dimension(150, 50), null, 2));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class MyColumnInfo
    extends ColumnInfo<String, Boolean> {
        private final Set<String> myAllowedSchemas;
        private final Set<String> mySelectedSchemas;
        private BooleanTableCellRenderer myRenderer;
        private BooleanTableCellEditor myEditor;

        public MyColumnInfo(String title, Set<String> allowedSchemas, Set<String> selectedSchemas) {
            super(title);
            this.myRenderer = new BooleanTableCellRenderer();
            this.myEditor = new BooleanTableCellEditor();
            this.myAllowedSchemas = allowedSchemas;
            this.mySelectedSchemas = selectedSchemas;
        }

        public Boolean valueOf(String s) {
            return DefaultsInstaller.isPresent(this.mySelectedSchemas, s);
        }

        public boolean isCellEditable(String s) {
            return this.myAllowedSchemas.contains(s) || "*".equals(s);
        }

        public void setValue(String s, Boolean value) {
            String prefix;
            String string = prefix = s.endsWith(".*") || "*".equals(s) ? s.substring(0, s.length() - 1) : null;
            if (Boolean.TRUE.equals(value)) {
                this.mySelectedSchemas.remove(s);
                this.mySelectedSchemas.add(s);
                if (prefix != null) {
                    for (String schema : ContainerUtil.newArrayList(this.myAllowedSchemas)) {
                        if (!StringUtil.startsWithIgnoreCase((String)schema, (String)prefix)) continue;
                        this.mySelectedSchemas.remove(schema);
                        this.mySelectedSchemas.add(schema);
                    }
                }
            } else {
                this.mySelectedSchemas.remove(s);
                this.mySelectedSchemas.remove("*");
                for (String schema : ContainerUtil.newArrayList(this.myAllowedSchemas)) {
                    if ((prefix == null || !StringUtil.startsWithIgnoreCase((String)schema, (String)prefix)) && (!schema.endsWith(".*") || !StringUtil.startsWithIgnoreCase((String)s, (String)schema.substring(0, schema.length() - 1)))) continue;
                    this.mySelectedSchemas.remove(schema);
                }
            }
            DataSourceSchemasPanel.this.mySchemasTable.revalidate();
            DataSourceSchemasPanel.this.mySchemasTable.repaint();
        }

        public TableCellRenderer getRenderer(String s) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(String o) {
            return this.myEditor;
        }
    }
}

