/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DatabaseModelLegacyLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.text.SyncDateFormat;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;

public class DataSourceUiUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceUiUtil");
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private DataSourceUiUtil() {
    }

    @Nullable
    public static Rdbms getRdbmsForIntrospection(@Nullable DatabaseFamilyId familyId) {
        boolean useNative;
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        boolean bl = useNative = Registry.is((String)"database.native.loading") || testMode;
        if (!useNative) {
            return null;
        }
        if (familyId == DatabaseFamilyId.ORACLE) {
            return Oracle.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MYSQL) {
            return Mysql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.POSTGRES) {
            return Postgres.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MSSQL) {
            return Mssql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.SYBASE) {
            return Sybase.RDBMS;
        }
        return null;
    }

    public static void refreshDatasourceEDT(final Project project, final LocalDataSource dataSource) {
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DataSourceUiUtil.refreshDatasource(project, true, true, LoaderContext.loadAll((DataSource)dataSource));
            }
        });
    }

    public static ActionCallback refreshDatasource(Project project, LoaderContext context) {
        return DataSourceUiUtil.refreshDatasource(project, ApplicationManager.getApplication().getCurrentModalityState() == ModalityState.NON_MODAL, false, context);
    }

    public static ActionCallback refreshDatasource(Project project, Component parent, LoaderContext context) {
        return DataSourceUiUtil.refreshDatasource(project, parent, parent == null && ApplicationManager.getApplication().getCurrentModalityState() == ModalityState.NON_MODAL, false, context);
    }

    public static ActionCallback refreshDatasource(@NotNull Project project, boolean backgroundable, boolean suppressNotification, LoaderContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "refreshDatasource"));
        }
        return DataSourceUiUtil.refreshDatasource(project, null, backgroundable, suppressNotification, context);
    }

    public static ActionCallback refreshDatasource(final @NotNull Project project, final @Nullable Component parent, final boolean backgroundable, final boolean suppressNotification, final LoaderContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceUiUtil", "refreshDatasource"));
        }
        context.setUpdateUi(project, null);
        final DataSource dataSource = context.getDataSource();
        final String title = dataSource.getName();
        final ActionCallback result = new ActionCallback();
        final long startTime = System.currentTimeMillis();
        final Runnable successRunnable = new Runnable(){

            @Override
            public void run() {
                String message;
                String summary = context.getErrorHandler().getSummary();
                boolean isError = !summary.isEmpty();
                long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
                String elapsedTimeStr = elapsedTime > 1L ? " (" + StringUtil.formatDuration((long)(elapsedTime * 1000L)) + ")" : "";
                JBIterable tables = DasUtil.getTables((DatabaseSystem)dataSource);
                boolean testConnection = context.loadNothing();
                if (isError) {
                    message = summary;
                } else if (!backgroundable) {
                    message = DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)dataSource) + "\n\n" + (!testConnection ? tables.size() + " tables available" : "Connection successful") + elapsedTimeStr;
                } else if (testConnection) {
                    message = "Connection successful" + elapsedTimeStr;
                } else if (context.getSelection().isEmpty()) {
                    message = tables.size() + " tables available" + elapsedTimeStr;
                } else {
                    List objects = ContainerUtil.filter((Collection)context.getSelection(), (Condition)Conditions.not((Condition)FilteringIterator.instanceOf(Class.class)));
                    int size = objects.size();
                    Object item = ContainerUtil.getFirstItem((Collection)objects);
                    String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
                    String target = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? itemName + " synchronized" : "Synchronization successful";
                    message = target + elapsedTimeStr;
                }
                if (!suppressNotification) {
                    if (backgroundable) {
                        DataSourceUiUtil.showNotification(project, title, message, isError);
                    } else if (!isError) {
                        if (parent == null) {
                            Messages.showMessageDialog((Project)project, (String)message, (String)title, (Icon)Messages.getInformationIcon());
                        } else {
                            Messages.showMessageDialog((Component)parent, (String)message, (String)title, (Icon)Messages.getInformationIcon());
                        }
                    } else {
                        Messages.showIdeaMessageDialog((Project)project, (String)message, (String)DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getWarningIcon(), null);
                    }
                }
                if (suppressNotification && isError) {
                    DataSourceUiUtil.showNotification(project, title + elapsedTimeStr, message, true);
                }
                if (isError) {
                    result.setRejected();
                } else {
                    result.setDone();
                }
            }
        };
        Object task = backgroundable ? new Task.Backgroundable(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void onSuccess() {
                successRunnable.run();
            }

            public void onCancel() {
                result.setRejected();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceUiUtil$3", "run"));
                }
                dataSource.refreshMetaData(project, context);
            }
        } : new Task.Modal(project, title, true){

            public void onCancel() {
                result.setRejected();
            }

            public void onSuccess() {
                successRunnable.run();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceUiUtil$4", "run"));
                }
                dataSource.refreshMetaData(project, context);
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return result;
    }

    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        String string = DatabaseMessages.message((String)"message.text.datasource.info", (Object[])new Object[]{o.getDatabaseProductName(), o.getDatabaseProductVersion(), o.getDriverName(), o.getDriverVersion(), o.getJDBCVersion(), modes.plain, modes.quoted});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "formatDataSourceInfoString"));
        }
        return string;
    }

    public static void showNotification(@Nullable Project project, String title, String message, boolean error) {
        final Pair<String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message, error ? DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]) : title, error ? Messages.getErrorIcon() : Messages.getInformationIcon());
        NotificationGroup group = error ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group.createNotification(title, (String)pair.first, error ? NotificationType.WARNING : NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dataSource/DataSourceUiUtil$5", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$5", "hyperlinkUpdate"));
                }
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }
        }).notify(project);
    }

    public static Pair<String, HyperlinkListener> truncatePopupMessageIfNeeded(String text, final String dialogTitle, final Icon icon) {
        boolean truncate;
        boolean bl = truncate = text.length() > 120;
        if (!truncate) {
            return Pair.create((Object)text, null);
        }
        String balloonMessage = text.substring(0, 120) + " ... " + "<a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        final String message = text.replace("\t", "  ");
        return Pair.create((Object)balloonMessage, (Object)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Messages.showIdeaMessageDialog(null, (String)message, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
                }
            }
        });
    }

    public static void showErrorBalloon(Throwable error, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error.getMessage(), (String)error.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        final String errorFullText = ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij.");
        String imgURL = "";
        URL resource = AllIcons.class.getClassLoader().getResource("/general/settings.png");
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if ("more".equals(e.getDescription())) {
                        Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                    } else if ("config".equals(e.getDescription())) {
                        ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                    }
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceUiUtil$8", "actionPerformed"));
                }
            }
        }, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/dataSource/DataSourceUiUtil", "wrap"));
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "currentTime"));
        }
        return string;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable DatabaseSystem database) throws PatternSyntaxException {
        String filterText;
        DatabaseSystem delegate = database instanceof DbElement ? ((DbElement)database).getDelegate() : database;
        String string = filterText = delegate instanceof AbstractDataSource ? ((AbstractDataSource)delegate).getTablePattern() : null;
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        THashMap map = ContainerUtil.newTroveMap();
        StringTokenizer st = new StringTokenizer(filterText, "||", false);
        while (st.hasMoreElements()) {
            ObjectKind kind;
            String part = st.nextElement().trim();
            if (part.length() == 0) continue;
            int idx = part.indexOf(58);
            boolean exclude = part.charAt(idx + 1) == '-';
            String patternText = part.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == part.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = part.substring(0, idx);
                ObjectKind objectKind = Comparing.strEqual((String)k, (String)"table") ? ObjectKind.TABLE : (Comparing.strEqual((String)k, (String)"view") ? ObjectKind.VIEW : (Comparing.strEqual((String)k, (String)"mview") ? ObjectKind.MAT_VIEW : (Comparing.strEqual((String)k, (String)"routine") ? ObjectKind.ROUTINE : (Comparing.strEqual((String)k, (String)"package") ? ObjectKind.PACKAGE : (Comparing.strEqual((String)k, (String)"sequence") ? ObjectKind.SEQUENCE : (kind = Comparing.strEqual((String)k, (String)"synonym") ? ObjectKind.SYNONYM : ObjectKind.NONE))))));
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = part;
                }
            }
            Condition prev = (Condition)map.get(kind);
            final boolean finalExclude = exclude;
            final Pattern pattern = Pattern.compile("(?i)" + patternText);
            Condition<String> c = new Condition<String>(){

                public boolean value(String s) {
                    boolean matches = pattern.matcher(s).matches();
                    return finalExclude ? !matches : matches;
                }
            };
            map.put(kind, prev == null ? c : Conditions.and2((Condition)prev, (Condition)c));
        }
        if (map.size() == 1 && ContainerUtil.getFirstItem(map.keySet()) == ObjectKind.NONE) {
            Condition condition = Conditions.compose((Function)DasUtil.TO_NAME, (Condition)((Condition)ContainerUtil.getFirstItem(map.values())));
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        Condition<DasObject> condition = new Condition<DasObject>((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            public boolean value(DasObject object) {
                Condition c = (Condition)this.val$map.get(object.getKind());
                return c == null || c.value((Object)object.getName());
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
        }
        return condition;
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runAsyncWithCorrectModality"));
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runSynchronously"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @Nullable
    public static Pattern getDefaultSchemasPattern(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceUiUtil", "getDefaultSchemasPattern"));
        }
        String defaultSchemas = dataSource.getDefaultSchemas();
        if (StringUtil.isEmptyOrSpaces((String)defaultSchemas) || defaultSchemas.contains("*.*")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : DatabaseModelLegacyLoader.splitSchemaPattern(defaultSchemas)) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(PatternUtil.convertToRegex((String)s));
        }
        return PatternUtil.compileSafe((String)sb.toString(), null);
    }
}

