/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArgument;
import com.intellij.database.dataSource.DatabaseFieldBase;
import com.intellij.database.dataSource.DatabaseForeignKey;
import com.intellij.database.dataSource.DatabaseIndex;
import com.intellij.database.dataSource.DatabaseKIFK;
import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.dataSource.DatabaseProcedure;
import com.intellij.database.dataSource.DatabaseSchema;
import com.intellij.database.dataSource.DatabaseTableData;
import com.intellij.database.dataSource.DatabaseTableFieldData;
import com.intellij.database.dataSource.DatabaseTableKey;
import com.intellij.database.dataSource.LegacySerializer;
import com.intellij.database.dataSource.ProcedureParameterType;
import com.intellij.database.dataSource.ProcedureType;
import com.intellij.database.dataSource.TableType;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.QNameUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.sql.SqlQuery;

class DatabaseModelLegacyLoader {
    private static final Logger LOG = Logger.getInstance(DatabaseModelLegacyLoader.class);
    private static final int PER_ELEMENT_LOADING_COUNT = 2;
    static final Comparator<DasObject> ELEMENT_COMPARATOR = new Comparator<DasObject>(){

        @Override
        public int compare(@NotNull DasObject o1, @NotNull DasObject o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$1", "compare"));
            }
            int result = Comparing.compare((Comparable)((Object)DasUtil.getCatalog((DasObject)o1)), (Comparable)((Object)DasUtil.getCatalog((DasObject)o2)));
            if (0 != result) {
                return result;
            }
            result = Comparing.compare((Comparable)((Object)DasUtil.getSchema((DasObject)o1)), (Comparable)((Object)DasUtil.getSchema((DasObject)o2)));
            if (0 != result) {
                return result;
            }
            if (o1 instanceof DasRoutine && o2 instanceof DasRoutine && 0 != (result = Comparing.compare((Comparable)((Object)((DasRoutine)o1).getPackage()), (Comparable)((Object)((DasRoutine)o2).getPackage())))) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };
    private static final SqlQuery<String[]> ORACLE_CURRENT_USER_AND_SCHEMA = new SqlQuery("select sys_context('userenv','current_schema'), user from dual", Layouts.rowOf((RowLayout)Layouts.arrayOf((int)2, String.class)));
    private static final SqlQuery<List<String>> ORACLE_ACCESSIBLE_SCHEMAS = new SqlQuery("select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    private static final SqlQuery<List<String>> ORACLE_ACCESSIBLE_USERS = new SqlQuery("select username    \nfrom sys.all_users \n", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
    private static final DatabaseSchema ORACLE_PUBLIC_SCHEMA = new DatabaseSchema("*", "PUBLIC");

    DatabaseModelLegacyLoader() {
    }

    static void loadInner(@NotNull LoaderContext context, @NotNull DasModel state, @NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator) throws SQLException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadInner"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadInner"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadInner"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadInner"));
        }
        DatabaseModelLegacyLoader.loadDataSourceStateInner(context, state instanceof LegacySerializer.State ? (LegacySerializer.State)state : LegacySerializer.EMPTY_STATE, connection, metaData, indicator);
    }

    private static void loadDataSourceStateInner(@NotNull LoaderContext context, @NotNull LegacySerializer.State state, @NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator) throws SQLException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadDataSourceStateInner"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadDataSourceStateInner"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadDataSourceStateInner"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadDataSourceStateInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadDataSourceStateInner"));
        }
        String schemaPattern = ((AbstractDataSource)context.getDataSource()).getSchemaPattern();
        PairProcessor<String, String> schemaFilter = schemaPattern == null ? PairProcessor.TRUE : DatabaseModelLegacyLoader.getSchemaFilter(schemaPattern);
        TreeSet<DatabaseSchema> schemasToLoad = DatabaseModelLegacyLoader.listSchemasToLoad(connection, metaData, schemaFilter, context);
        TreeSet newTables = ContainerUtilRt.newTreeSet(ELEMENT_COMPARATOR);
        TreeSet newProcedures = ContainerUtilRt.newTreeSet(ELEMENT_COMPARATOR);
        THashMap stateMap = ContainerUtil.newIdentityTroveMap();
        if (!state.schemas.containsAll(schemasToLoad) || context.load(null, null) && !schemasToLoad.containsAll(state.schemas)) {
            state = DatabaseModelLegacyLoader.mergeState(context, state, schemaFilter, newTables, newProcedures, schemasToLoad, (THashMap<DatabaseObject, Object>)stateMap);
            DatabaseModelLegacyLoader.updateUI(context, state, (THashMap<? extends DasObject, Object>)stateMap);
        }
        ArrayList tables = ContainerUtil.newArrayList();
        ArrayList procedures = ContainerUtil.newArrayList();
        if (schemasToLoad.isEmpty()) {
            for (DatabaseTableData databaseTableData : state.tables) {
                if (!context.load((Object)databaseTableData) || !schemaFilter.process((Object)databaseTableData.getCatalog(), (Object)databaseTableData.getSchema())) continue;
                tables.add(databaseTableData);
            }
            for (DatabaseProcedure databaseProcedure : state.procedures) {
                if (!context.load((Object)databaseProcedure) || !schemaFilter.process((Object)databaseProcedure.getCatalog(), (Object)databaseProcedure.getSchema())) continue;
                procedures.add(databaseProcedure);
            }
        } else {
            Condition<DasObject> objectFilter = DatabaseModelLegacyLoader.buildObjectFilter(context);
            for (DatabaseSchema schema : schemasToLoad) {
                if (!context.loadTables() && JBIterable.from((Iterable)context.getSelection()).filter(DasTable.class).isEmpty()) continue;
                Object[] types = DatabaseModelLegacyLoader.getAllTableTypes(metaData, context.getErrorHandler());
                if (!Comparing.equal((String)schema.getName(), (String)"dbo", (boolean)false) && context.getFamilyId().isSybase()) {
                    types = (String[])ArrayUtil.remove((Object[])types, (Object)"SYSTEM TABLE");
                }
                JdbcUtil.setCatalogSafe((Connection)connection, (String)schema.getCatalog());
                tables.addAll(DatabaseModelLegacyLoader.loadTableList(context, schema, objectFilter, (String[])types, state.tables, metaData, indicator));
            }
            for (DatabaseSchema schema : schemasToLoad) {
                if (!context.loadProcedures() && JBIterable.from((Iterable)context.getSelection()).filter(DasRoutine.class).isEmpty()) continue;
                JdbcUtil.setCatalogSafe((Connection)connection, (String)schema.getCatalog());
                procedures.addAll(DatabaseModelLegacyLoader.loadProcedures(context, schema, objectFilter, state.procedures, metaData, indicator));
            }
        }
        boolean incUiRefresh = tables.size() + procedures.size() > 2;
        for (boolean flag : new boolean[]{false, true}) {
            for (Map.Entry entry : DatabaseModelLegacyLoader.classifySchemas(tables).entrySet()) {
                JdbcUtil.setCatalogSafe((Connection)connection, (String)entry.getKey().getCatalog());
                DatabaseModelLegacyLoader.loadElementDetails(context, entry.getValue(), DatabaseTableData.class, entry.getKey(), flag, (THashMap<DatabaseObject, Object>)stateMap, metaData, indicator);
                newTables.addAll(entry.getValue());
            }
            if (!flag) {
                newProcedures.addAll(state.procedures);
            }
            state = DatabaseModelLegacyLoader.mergeState(context, state, schemaFilter, newTables, newProcedures, schemasToLoad, (THashMap<DatabaseObject, Object>)stateMap);
            if (incUiRefresh) {
                DatabaseModelLegacyLoader.updateUI(context, state, (THashMap<? extends DasObject, Object>)stateMap);
            }
            if (!flag) {
                newProcedures.clear();
            }
            for (Map.Entry entry : DatabaseModelLegacyLoader.classifySchemas(procedures).entrySet()) {
                JdbcUtil.setCatalogSafe((Connection)connection, (String)entry.getKey().getCatalog());
                DatabaseModelLegacyLoader.loadElementDetails(context, entry.getValue(), DatabaseProcedure.class, entry.getKey(), flag, (THashMap<DatabaseObject, Object>)stateMap, metaData, indicator);
                newProcedures.addAll(entry.getValue());
            }
            state = DatabaseModelLegacyLoader.mergeState(context, state, schemaFilter, newTables, newProcedures, schemasToLoad, (THashMap<DatabaseObject, Object>)stateMap);
            if (!incUiRefresh) continue;
            DatabaseModelLegacyLoader.updateUI(context, state, (THashMap<? extends DasObject, Object>)stateMap);
        }
        if (!incUiRefresh) {
            DatabaseModelLegacyLoader.updateUI(context, state, (THashMap<? extends DasObject, Object>)stateMap);
        }
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@NotNull LoaderContext context) {
        Condition<DasObject> condition;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "buildObjectFilter"));
        }
        try {
            condition = DataSourceUiUtil.buildObjectFilter((DatabaseSystem)context.getDataSource());
        }
        catch (PatternSyntaxException e) {
            context.getErrorHandler().addError("Object filter invalid", (Throwable)e);
            Condition condition2 = Conditions.alwaysTrue();
            if (condition2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "buildObjectFilter"));
            }
            return condition2;
        }
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "buildObjectFilter"));
        }
        return condition;
    }

    @NotNull
    protected static LegacySerializer.State mergeState(@NotNull LoaderContext context, @NotNull LegacySerializer.State oldState, @NotNull PairProcessor<String, String> schemaFilter, @NotNull TreeSet<DatabaseTableData> newTables, @NotNull TreeSet<DatabaseProcedure> newProcedures, @NotNull TreeSet<DatabaseSchema> newSchemas, @NotNull THashMap<DatabaseObject, Object> stateMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (oldState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldState", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (schemaFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFilter", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (newTables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTables", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (newProcedures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProcedures", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (newSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemas", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        newTables = (TreeSet)newTables.clone();
        newProcedures = (TreeSet)newProcedures.clone();
        newSchemas = (TreeSet)newSchemas.clone();
        for (DatabaseTableData databaseTableData : oldState.tables) {
            if (newTables.contains(databaseTableData) || !schemaFilter.process((Object)databaseTableData.getCatalog(), (Object)databaseTableData.getSchema()) || context.load(databaseTableData.getCatalog(), databaseTableData.getSchema()) || context.load((Object)databaseTableData)) continue;
            newTables.add(databaseTableData);
        }
        for (DatabaseProcedure databaseProcedure : oldState.procedures) {
            if (newProcedures.contains(databaseProcedure) || !schemaFilter.process((Object)databaseProcedure.getCatalog(), (Object)databaseProcedure.getSchema()) || context.load(databaseProcedure.getCatalog(), databaseProcedure.getSchema()) || context.load((Object)databaseProcedure)) continue;
            newProcedures.add(databaseProcedure);
        }
        for (DatabaseSchema databaseSchema : oldState.schemas) {
            if (newSchemas.contains(databaseSchema) || !schemaFilter.process((Object)databaseSchema.getCatalog(), (Object)databaseSchema.getName()) || context.load(databaseSchema.getCatalog(), databaseSchema.getName())) continue;
            newSchemas.add(databaseSchema);
        }
        for (DatabaseTableData databaseTableData : newTables) {
            databaseTableData.resolveReferences(newTables);
        }
        DatabaseModelLegacyLoader.computeExportedKeysManually(newTables, stateMap);
        LegacySerializer.State state = new LegacySerializer.State(newTables, newProcedures, newSchemas);
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "mergeState"));
        }
        return state;
    }

    protected static void updateUI(@NotNull LoaderContext context, @NotNull DasModel state, @Nullable THashMap<? extends DasObject, Object> stateMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "updateUI"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "updateUI"));
        }
        THashMap clone = stateMap == null ? Collections.emptyMap() : stateMap.clone();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((Map)clone, context, state){
            final /* synthetic */ Map val$clone;
            final /* synthetic */ LoaderContext val$context;
            final /* synthetic */ DasModel val$state;
            {
                this.val$clone = map;
                this.val$context = loaderContext;
                this.val$state = dasModel;
            }

            @Override
            public void run() {
                for (DasObject o : this.val$clone.keySet()) {
                    if (o instanceof DatabaseTableData) {
                        ((DatabaseTableData)o).updateState((DatabaseTableData.State)this.val$clone.get(o));
                        continue;
                    }
                    if (!(o instanceof DatabaseProcedure)) continue;
                    ((DatabaseProcedure)o).updateState((DatabaseProcedure.State)this.val$clone.get(o));
                }
                DatabaseModelLegacyLoader.updateState(this.val$context.getDataSource(), this.val$state);
                Runnable runnable = this.val$context.getUpdateUiRunnable();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public static void updateState(@NotNull DataSource dataSource, @NotNull DasModel state) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "updateState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "updateState"));
        }
        dataSource.updateState(state);
    }

    static void computeExportedKeysManually(@NotNull Collection<DatabaseTableData> newTables, @NotNull Map<DatabaseObject, Object> stateMap) {
        if (newTables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTables", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "computeExportedKeysManually"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "computeExportedKeysManually"));
        }
        for (DatabaseTableData tableData : newTables) {
            if (stateMap.containsKey(tableData)) continue;
            tableData.getExportedKeys().clear();
        }
        for (DatabaseTableData tableData : newTables) {
            for (DatabaseForeignKey key : tableData.getForeignKeys()) {
                DatabaseTableData.State state;
                DasTable refTable = key.getRefTable();
                if (!(refTable instanceof DatabaseTableData) || (state = (DatabaseTableData.State)stateMap.get(refTable)) == null) continue;
                state.exportedKeys.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTableState(@NotNull LoaderContext context, @NotNull DatabaseTableData.State state, @NotNull DatabaseTableData table, @NotNull DatabaseMetaData metaData) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableState"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableState"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableState"));
        }
        ObjectKind kind = table.getKind();
        if (kind != ObjectKind.TABLE) {
            return;
        }
        HashSet<String> visitedKeys = new HashSet<String>();
        String pkName = null;
        TreeMap<Integer, String> primaryKeys = new TreeMap<Integer, String>();
        ResultSetWrapper primaryKeysRS = null;
        try {
            primaryKeysRS = ResultSetWrapper.wrap(metaData.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName()));
            while (primaryKeysRS.next()) {
                String columnName = primaryKeysRS.getString("COLUMN_NAME", 4);
                int pkIndex = primaryKeysRS.getShort("KEY_SEQ", 5);
                pkName = primaryKeysRS.getString("PK_NAME", 6);
                visitedKeys.add(pkName);
                while (primaryKeys.containsKey(pkIndex)) {
                    ++pkIndex;
                }
                primaryKeys.put(pkIndex, columnName);
            }
        }
        catch (Exception ex) {
            try {
                context.getErrorHandler().addError(QNameUtil.getQualifiedName(table), (Throwable)ex);
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(primaryKeysRS);
                throw throwable;
            }
            ResultSetWrapper.close(primaryKeysRS);
        }
        ResultSetWrapper.close(primaryKeysRS);
        if (!primaryKeys.isEmpty()) {
            state.primaryKey = new DatabaseTableKey(table);
            state.primaryKey.setName(pkName);
            state.primaryKey.setUnique(true);
            state.primaryKey.setColumnNames((Iterable)primaryKeys.values());
        }
        ArrayList<ForeignKey> importedKeys = new ArrayList<ForeignKey>();
        ResultSetWrapper foreignKeysRS = null;
        try {
            foreignKeysRS = ResultSetWrapper.wrap(metaData.getImportedKeys(table.getCatalog(), table.getSchema(), table.getName()));
            DatabaseModelLegacyLoader.collectForeignKeys(foreignKeysRS, importedKeys, table);
        }
        catch (Exception ex) {
            try {
                context.getErrorHandler().addError(QNameUtil.getQualifiedName(table), (Throwable)ex);
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(foreignKeysRS);
                throw throwable;
            }
            ResultSetWrapper.close(foreignKeysRS);
        }
        ResultSetWrapper.close(foreignKeysRS);
        DatabaseModelLegacyLoader.convertForeignKeys(state, table, importedKeys, true);
        if (!context.getFamilyId().isMysql()) {
            for (ForeignKey relation : importedKeys) {
                visitedKeys.add(relation.RELATION_NAME);
            }
        }
        visitedKeys.remove(null);
        ResultSetWrapper indicesResultSet = null;
        try {
            try {
                indicesResultSet = ResultSetWrapper.wrap(metaData.getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), false, true));
            }
            catch (SQLException ex) {
                try {
                    DataSource dataSource = context.getDataSource();
                    DatabaseDialectEx dialect = dataSource instanceof RawConnectionConfig ? DbImplUtil.guessDatabaseDialect((RawConnectionConfig)dataSource) : null;
                    indicesResultSet = ResultSetWrapper.wrap(metaData.getIndexInfo(DatabaseModelLegacyLoader.quoteIfNeeded(table.getCatalog(), dataSource, dialect), DatabaseModelLegacyLoader.quoteIfNeeded(table.getSchema(), dataSource, dialect), DatabaseModelLegacyLoader.quoteIfNeeded(table.getName(), dataSource, dialect), false, true));
                }
                catch (SQLException ex2) {
                    throw ex;
                }
            }
            while (indicesResultSet.next()) {
                short type;
                boolean indexNonUnique = indicesResultSet.getBoolean("NON_UNIQUE", 4);
                String index_name = indicesResultSet.getString("INDEX_NAME", 6);
                String safeName = StringUtil.notNullize((String)index_name);
                if (context.getFamilyId().isSqlite() && safeName.startsWith("sqlite_autoindex_") || context.getFamilyId().isDb2() && "SYSIBM".equalsIgnoreCase(indicesResultSet.getString("INDEX_QUALIFIER", 5)) || context.getFamilyId().isHsqldb() && safeName.startsWith("SYS_IDX") || context.getFamilyId().isH2() && (safeName.startsWith("PRIMARY_KEY_") || safeName.startsWith("CONSTRAINT_INDEX_")) || context.getFamilyId().isDerby() && safeName.matches("SQL\\d{15}") || visitedKeys.contains(index_name) || (type = indicesResultSet.getShort("TYPE", 7)) == 0) continue;
                String columns = StringUtil.notNullize((String)indicesResultSet.getString("COLUMN_NAME", 9), (String)"");
                Object[] columnNames = DatabaseKIFK.COLUMN_SPLITTER_PATTERN.split(columns, 0);
                if (context.getFamilyId().isSybase() && safeName.matches("^.*_\\d{5,}$") && state.primaryKey != null && ContainerUtil.subtract((Collection)ContainerUtil.newHashSet((Iterable)state.primaryKey.getColumnsRef().names()), (Collection)ContainerUtil.newHashSet((Object[])columnNames)).isEmpty()) continue;
                for (int i = 0; i < columnNames.length; ++i) {
                    columnNames[i] = StringUtil.unquoteString((String)columnNames[i]);
                }
                if (context.getFamilyId().isMysql() && DatabaseModelLegacyLoader.alreadyAddedByForeignKey(state, (String[])columnNames) && columnNames.length == 1 && ((String)columnNames[0]).equalsIgnoreCase(index_name)) continue;
                boolean merged = false;
                for (DatabaseKIFK databaseKIFK : state.indices) {
                    if (!Comparing.equal((String)databaseKIFK.getName(), (String)index_name) || databaseKIFK.isUnique() == indexNonUnique) continue;
                    databaseKIFK.setColumnNames(Iterables.concat((Iterable)databaseKIFK.getColumnsRef().names(), Arrays.asList(columnNames)));
                    merged = true;
                    break;
                }
                if (merged) continue;
                DatabaseIndex index = new DatabaseIndex(table);
                index.setName(index_name);
                index.setUnique(!indexNonUnique);
                index.setColumnNames(Arrays.asList(columnNames));
                state.indices.add(index);
            }
            ResultSetWrapper.close(indicesResultSet);
        }
        catch (Exception ex) {
            context.getErrorHandler().addError(QNameUtil.getQualifiedName(table), (Throwable)ex);
        }
        finally {
            ResultSetWrapper.close(indicesResultSet);
        }
        ResultSetWrapper versionResultSet = null;
        try {
            versionResultSet = ResultSetWrapper.wrap(metaData.getVersionColumns(table.getCatalog(), table.getSchema(), table.getName()));
            while (versionResultSet.next()) {
                DatabaseTableFieldData column;
                String columnName = versionResultSet.getString("COLUMN_NAME", 2);
                short type = versionResultSet.getShort("PSEUDO_COLUMN", 8);
                if (type == 2 || (column = QNameUtil.findByName(columnName, state.columns)) == null) continue;
                state.versionColumns.add(column.getName());
            }
        }
        catch (Exception ex) {
            try {
                context.getErrorHandler().addError(QNameUtil.getQualifiedName(table), (Throwable)ex);
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(versionResultSet);
                throw throwable;
            }
            ResultSetWrapper.close(versionResultSet);
        }
        ResultSetWrapper.close(versionResultSet);
    }

    private static String quoteIfNeeded(@Nullable String name, @NotNull DataSource dataSource, @Nullable DatabaseDialect dialect) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "quoteIfNeeded"));
        }
        if (dialect != null) {
            return dialect.quoteIdentifier(name, false, false);
        }
        return dataSource.quoteIdentifierIfNeeded(name);
    }

    private static void collectForeignKeys(@NotNull ResultSetWrapper foreignKeysRS, @NotNull List<ForeignKey> relations, @NotNull DatabaseTableData table) throws SQLException {
        if (foreignKeysRS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeysRS", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "collectForeignKeys"));
        }
        if (relations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relations", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "collectForeignKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "collectForeignKeys"));
        }
        int counter = 0;
        while (foreignKeysRS.next()) {
            short keySeq = foreignKeysRS.getShort("KEY_SEQ", 9);
            if (keySeq == 0 || keySeq == 1) {
                ++counter;
            }
            ForeignKey relationData = new ForeignKey();
            String fkName = foreignKeysRS.getString("FK_NAME", 12);
            relationData.RELATION_NAME = StringUtil.isEmpty((String)fkName) ? "#FAKE_" + table.getName() + "_" + Integer.toString(counter) : fkName;
            relationData.TARGET_TABLE = foreignKeysRS.getString("PKTABLE_NAME", 3);
            relationData.TARGET_SCHEMA = foreignKeysRS.getString("PKTABLE_SCHEM", 2);
            relationData.TARGET_CATALOG = foreignKeysRS.getString("PKTABLE_CAT", 1);
            relationData.TARGET_COLUMN = foreignKeysRS.getString("PKCOLUMN_NAME", 4);
            relationData.SOURCE_TABLE = foreignKeysRS.getString("FKTABLE_NAME", 7);
            relationData.SOURCE_SCHEMA = foreignKeysRS.getString("FKTABLE_SCHEM", 6);
            relationData.SOURCE_CATALOG = foreignKeysRS.getString("FKTABLE_CAT", 5);
            relationData.SOURCE_COLUMN = foreignKeysRS.getString("FKCOLUMN_NAME", 8);
            relationData.UPDATE_RULE = foreignKeysRS.getShort("UPDATE_RULE", 10);
            relationData.DELETE_RULE = foreignKeysRS.getShort("DELETE_RULE", 11);
            relationData.DEFERRABILITY = foreignKeysRS.getShort("DEFERRABILITY", 14);
            relationData.KEY_SEQ = keySeq;
            relations.add(relationData);
        }
    }

    private static boolean alreadyAddedByForeignKey(@NotNull DatabaseTableData.State state, String[] columnNames) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "alreadyAddedByForeignKey"));
        }
        for (DatabaseForeignKey foreignKey : state.foreignKeys) {
            boolean equals = ContainerUtil.subtract((Collection)ContainerUtil.newHashSet((Iterable)foreignKey.getColumnsRef().names()), (Collection)ContainerUtil.newHashSet((Object[])columnNames)).isEmpty();
            if (!equals) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static DatabaseTableFieldData tableColumnFromRow(@NotNull LoaderContext context, DatabaseTableData table, @NotNull ResultSetWrapper columnResultSet) throws SQLException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "tableColumnFromRow"));
        }
        if (columnResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnResultSet", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "tableColumnFromRow"));
        }
        String columnName = columnResultSet.getString("COLUMN_NAME", 4);
        int jdbcType = columnResultSet.getInt("DATA_TYPE", 5, 0);
        String sqlTypeName = StringUtil.notNullize((String)columnResultSet.getString("TYPE_NAME", 6));
        int length = columnResultSet.getInt("COLUMN_SIZE", 7, 0);
        int scale = columnResultSet.getInt("DECIMAL_DIGITS", 9, 0);
        boolean nullable = columnResultSet.getInt("NULLABLE", 11, 0) != 0;
        String defaultValue = columnResultSet.getString("COLUMN_DEF", 13);
        String comment = columnResultSet.getString("REMARKS", 12);
        int position = columnResultSet.getInt("ORDINAL_POSITION", 17, 0);
        if (context.getFamilyId().isSqlite()) {
            length = 0;
            scale = -1;
        }
        DatabaseTableFieldData column = new DatabaseTableFieldData(columnName, sqlTypeName, jdbcType, length, scale, nullable, table);
        column.setDefault(DatabaseModelLegacyLoader.fixDefaultValue(context, column, defaultValue));
        column.setComment(comment);
        column.setPosition((short)position);
        DatabaseTableFieldData databaseTableFieldData = column;
        if (databaseTableFieldData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "tableColumnFromRow"));
        }
        return databaseTableFieldData;
    }

    @Nullable
    private static String fixDefaultValue(@NotNull LoaderContext context, @NotNull DatabaseTableFieldData tableFieldData, @Nullable String defaultValue) {
        int jdbc;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "fixDefaultValue"));
        }
        if (tableFieldData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableFieldData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "fixDefaultValue"));
        }
        if (defaultValue == null) {
            return null;
        }
        int reportedJdbc = tableFieldData.getJdbcType();
        int n = jdbc = reportedJdbc == 1111 || reportedJdbc == 0 ? JdbcUtil.guessJdbcTypeByName((String)tableFieldData.getSqlType()) : reportedJdbc;
        if (jdbc == 1 || jdbc == 2005 || jdbc == 12 || jdbc == -15 || jdbc == 2011 || jdbc == -9 || jdbc == 91 || jdbc == 92 || jdbc == 93) {
            if (context.getFamilyId().isOracle()) {
                return defaultValue;
            }
            if (context.getFamilyId().isPostgres()) {
                int dotIndex = defaultValue.indexOf("::");
                if (dotIndex == -1) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("('") && dotIndex > 4) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("''") && defaultValue.endsWith("'")) {
                    return defaultValue.substring(1, dotIndex);
                }
                return defaultValue.substring(0, dotIndex);
            }
            if ((jdbc == 91 || jdbc == 92 || jdbc == 93) && defaultValue.length() > 0 && Character.isLetter(defaultValue.charAt(0))) {
                return defaultValue;
            }
            if (!StringUtil.startsWithChar((CharSequence)defaultValue, (char)'\'')) {
                return '\'' + defaultValue + '\'';
            }
        } else if (jdbc == -7) {
            if (defaultValue.contains("\u0000")) {
                return "0";
            }
            if (defaultValue.contains("\u0001")) {
                return "1";
            }
        }
        return defaultValue;
    }

    @Nullable
    private static DatabaseArgument procedureColumnFromRow(DatabaseProcedure procedure, @NotNull ResultSetWrapper columnResultSet) throws SQLException {
        if (columnResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnResultSet", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "procedureColumnFromRow"));
        }
        String columnName = columnResultSet.getString("COLUMN_NAME", 4);
        int jdbcType = columnResultSet.getInt("DATA_TYPE", 6, 0);
        String sqlTypeName = StringUtil.notNullize((String)columnResultSet.getString("TYPE_NAME", 7));
        int precision = columnResultSet.getInt("PRECISION", 8, 0);
        int length = columnResultSet.getInt("LENGTH", 9, 0);
        int scale = columnResultSet.getInt("SCALE", 10, 0);
        int charOctetLength = columnResultSet.getInt("CHAR_OCTET_LENGTH", 17, 0);
        boolean nullable = columnResultSet.getInt("NULLABLE", 12, 0) != 0;
        String defValue = columnResultSet.getString("COLUMN_DEF", 14);
        ProcedureParameterType columnType = ProcedureParameterType.findByID(columnResultSet.getShort("COLUMN_TYPE", 5));
        int index = columnResultSet.getInt("ORDINAL_POSITION", 18, -1);
        int lengthValue = charOctetLength <= 0 && precision <= 0 ? length : Math.max(charOctetLength, precision);
        DatabaseArgument column = new DatabaseArgument(columnType, columnName, sqlTypeName, jdbcType, lengthValue, scale, nullable, procedure);
        column.setIndex(index);
        column.setDefault(defValue);
        return column;
    }

    static <T extends DasObject> Map<DatabaseSchema, List<T>> classifySchemas(@NotNull List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "classifySchemas"));
        }
        return DatabaseModelLegacyLoader.classify(elements.iterator(), new Convertor<T, DatabaseSchema>(){

            @NotNull
            public DatabaseSchema convert(@NotNull DasObject o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$3", "convert"));
                }
                DatabaseSchema databaseSchema = DatabaseModelLegacyLoader.getDatabaseSchema(o);
                if (databaseSchema == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$3", "convert"));
                }
                return databaseSchema;
            }
        });
    }

    @NotNull
    private static DatabaseSchema getDatabaseSchema(@NotNull DasObject o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getDatabaseSchema"));
        }
        DatabaseSchema databaseSchema = new DatabaseSchema(DasUtil.getCatalog((DasObject)o), DasUtil.getSchema((DasObject)o));
        if (databaseSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getDatabaseSchema"));
        }
        return databaseSchema;
    }

    private static boolean elementExists(@NotNull LoaderContext context, @NotNull DasObject element, @NotNull DatabaseMetaData metaData) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "elementExists"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "elementExists"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "elementExists"));
        }
        boolean result = false;
        try {
            ResultSet rs;
            String catalog = DasUtil.getCatalog((DasObject)element);
            String schema = DasUtil.getSchema((DasObject)element);
            if (element instanceof DatabaseTableData) {
                rs = metaData.getTables(catalog, schema, element.getName(), new String[]{element.getKind().name()});
                result = rs.next();
            } else if (element instanceof DatabaseProcedure) {
                catalog = StringUtil.isEmpty((String)metaData.getCatalogTerm()) ? ((DatabaseProcedure)element).getPackage() : catalog;
                rs = metaData.getProcedures(catalog, schema, element.getName());
                result = rs.next();
                if (!result && context.getFamilyId().isSybase()) {
                    JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    rs = metaData.getTables(catalog, schema, element.getName(), new String[]{"SYSTEM TABLE"});
                    result = rs.next();
                }
            } else {
                throw new AssertionError(element);
            }
            JdbcUtil.closeResultSetSafe((ResultSet)rs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @NotNull
    private static Pair<Set<String>, String> getCatalogsToLoad(@NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull LoaderContext context) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoad"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoad"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoad"));
        }
        String currentCatalog = connection.getCatalog();
        Set<String> vendorSpecific = DatabaseModelLegacyLoader.getCatalogsToLoadVendorSpecific(connection, context);
        if (!vendorSpecific.isEmpty()) {
            Pair pair = Pair.create(vendorSpecific, (Object)connection.getCatalog());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoad"));
            }
            return pair;
        }
        OpenTHashSet catalogs = new OpenTHashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            ContainerUtil.addAllNotNull((Collection)catalogs, ResultSetWrapper.wrap(metaData.getCatalogs()).list("TABLE_CAT", 1, context.getErrorHandler()));
            if (currentCatalog != null && catalogs.contains((Object)currentCatalog)) {
                currentCatalog = (String)catalogs.get(catalogs.index((Object)currentCatalog));
            }
        }
        catch (SQLException ignored) {
            ContainerUtil.addIfNotNull((Collection)catalogs, (Object)currentCatalog);
        }
        Pair pair = Pair.create((Object)catalogs, (Object)currentCatalog);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoad"));
        }
        return pair;
    }

    @NotNull
    public static Set<String> getCatalogsToLoadVendorSpecific(@NotNull Connection connection, @NotNull LoaderContext context) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoadVendorSpecific"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoadVendorSpecific"));
        }
        OpenTHashSet catalogs = new OpenTHashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            if (context.getFamilyId() == DatabaseFamilyId.MSSQL) {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery("select name from master.sys.databases where has_dbaccess(name) = 1");
                while (rs.next()) {
                    catalogs.add(rs.getString("name"));
                }
                JdbcUtil.closeResultSetSafe((ResultSet)rs);
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        OpenTHashSet openTHashSet = catalogs;
        if (openTHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getCatalogsToLoadVendorSpecific"));
        }
        return openTHashSet;
    }

    @NotNull
    static TreeSet<DatabaseSchema> retrieveSessionAvailableDatabasesAndSchemas(@NotNull Connection connection, @NotNull DatabaseMetaData metaData, @NotNull LoaderContext context) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "retrieveSessionAvailableDatabasesAndSchemas"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "retrieveSessionAvailableDatabasesAndSchemas"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "retrieveSessionAvailableDatabasesAndSchemas"));
        }
        if (context.getFamilyId() == DatabaseFamilyId.ORACLE) {
            boolean showEmptySchemas = false;
            TreeSet<DatabaseSchema> treeSet = DatabaseModelLegacyLoader.listOracleSchemas(connection, showEmptySchemas);
            if (treeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "retrieveSessionAvailableDatabasesAndSchemas"));
            }
            return treeSet;
        }
        TreeSet<DatabaseSchema> treeSet = DatabaseModelLegacyLoader.listSchemasToLoad(connection, metaData, null, context);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "retrieveSessionAvailableDatabasesAndSchemas"));
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getOracleCurrentUserAndSchema(@NotNull Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getOracleCurrentUserAndSchema"));
        }
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, connection, false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            String[] stringArray = (String[])session.query(ORACLE_CURRENT_USER_AND_SCHEMA).run();
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeSet<DatabaseSchema> listOracleSchemas(@NotNull Connection connection, boolean includingEmptySchemas) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listOracleSchemas"));
        }
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, connection, false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            SqlQuery<List<String>> query = includingEmptySchemas ? ORACLE_ACCESSIBLE_USERS : ORACLE_ACCESSIBLE_SCHEMAS;
            Collection names = (Collection)session.query(query).run();
            TreeSet<DatabaseSchema> result = new TreeSet<DatabaseSchema>();
            for (String name : names) {
                result.add(new DatabaseSchema("*", name));
            }
            result.add(ORACLE_PUBLIC_SCHEMA);
            TreeSet<DatabaseSchema> treeSet = result;
            return treeSet;
        }
    }

    private static TreeSet<DatabaseSchema> listSchemasToLoadVendorSpecific(@NotNull Connection connection, @NotNull Set<String> catalogs, @Nullable PairProcessor<String, String> schemaFilter, @NotNull LoaderContext context) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoadVendorSpecific"));
        }
        if (catalogs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catalogs", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoadVendorSpecific"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoadVendorSpecific"));
        }
        LOG.debug("loading list schemas from " + StringUtil.join(catalogs, (String)", "));
        TreeSet<DatabaseSchema> schemas = new TreeSet<DatabaseSchema>();
        if (context.getFamilyId() == DatabaseFamilyId.MSSQL) {
            for (String catalog : catalogs) {
                try {
                    Statement statement = connection.createStatement();
                    ResultSet rs = statement.executeQuery("select name from [" + catalog + "].sys.schemas");
                    while (rs.next()) {
                        String schema = rs.getString("name");
                        if (!context.load(catalog, schema) || schemaFilter != null && !schemaFilter.process((Object)catalog, (Object)schema)) continue;
                        schemas.add(new DatabaseSchema(catalog, schema));
                    }
                    JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    JdbcUtil.closeStatementSafe((Statement)statement);
                }
                catch (SQLException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static TreeSet<DatabaseSchema> listSchemasToLoad(@NotNull Connection connection, @NotNull DatabaseMetaData metaData, @Nullable PairProcessor<String, String> schemaFilter, @NotNull LoaderContext context) throws SQLException {
        TreeSet<DatabaseSchema> schemas;
        String currentCatalog;
        Set catalogs;
        DatabaseDialectEx dialect;
        block39: {
            TreeSet<DatabaseSchema> treeSet;
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
            }
            if (metaData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
            }
            DataSource dataSource = context.getDataSource();
            dialect = dataSource instanceof RawConnectionConfig ? DbImplUtil.guessDatabaseDialect((RawConnectionConfig)dataSource) : null;
            Pair<Set<String>, String> pair = DatabaseModelLegacyLoader.getCatalogsToLoad(connection, metaData, context);
            catalogs = (Set)pair.first;
            currentCatalog = (String)pair.second;
            TreeSet<DatabaseSchema> vendorSpecific = DatabaseModelLegacyLoader.listSchemasToLoadVendorSpecific(connection, catalogs, schemaFilter, context);
            if (!vendorSpecific.isEmpty()) {
                TreeSet<DatabaseSchema> treeSet2 = vendorSpecific;
                if (treeSet2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
                }
                return treeSet2;
            }
            schemas = new TreeSet<DatabaseSchema>();
            try {
                for (String catalog : catalogs) {
                    ResultSet schemasResultSet;
                    try {
                        schemasResultSet = metaData.getSchemas(catalog, "%");
                    }
                    catch (SQLException ex) {
                        try {
                            schemasResultSet = metaData.getSchemas(DatabaseModelLegacyLoader.quoteIfNeeded(catalog, dataSource, dialect), "%");
                        }
                        catch (SQLException ex2) {
                            continue;
                        }
                    }
                    List schemList = ResultSetWrapper.wrap(schemasResultSet).list("TABLE_SCHEM", 1, context.getErrorHandler());
                    for (String schema : schemList) {
                        if (!context.load(catalog, schema) || schemaFilter != null && !schemaFilter.process((Object)catalog, (Object)schema)) continue;
                        schemas.add(new DatabaseSchema(catalog, schema));
                    }
                }
                if (schemas.isEmpty()) break block39;
                treeSet = schemas;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (treeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
            }
            return treeSet;
        }
        if (!catalogs.isEmpty() && currentCatalog != null) {
            Iterator iterator = catalogs.iterator();
            block19: while (iterator.hasNext()) {
                String cat;
                String dbName = cat = (String)iterator.next();
                if (dialect instanceof AbstractTransactSqlDialect) {
                    dbName = ((AbstractTransactSqlDialect)dialect).catalogNameToScript(dbName);
                }
                if (!JdbcUtil.setCatalogSafe((Connection)connection, (String)dbName)) continue;
                ResultSetWrapper schemasResultSet = null;
                try {
                    schemasResultSet = ResultSetWrapper.wrap(metaData.getSchemas());
                    while (schemasResultSet.next()) {
                        String schema = schemasResultSet.getString("TABLE_SCHEM", 1);
                        String catalog = schemasResultSet.getString("TABLE_CATALOG", 2);
                        if (catalog != null && !catalog.equals(cat)) continue block19;
                        if (!context.load(cat, schema) || schemaFilter != null && !schemaFilter.process((Object)cat, (Object)schema)) continue;
                        schemas.add(new DatabaseSchema(cat, schema));
                    }
                }
                catch (Exception ex) {
                    context.getErrorHandler().addError(null, (Throwable)ex);
                }
                finally {
                    ResultSetWrapper.close(schemasResultSet);
                }
            }
            JdbcUtil.setCatalogSafe((Connection)connection, (String)currentCatalog);
            if (!schemas.isEmpty()) {
                TreeSet<DatabaseSchema> treeSet = schemas;
                if (treeSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
                }
                return treeSet;
            }
        }
        ResultSetWrapper schemasResultSet = null;
        try {
            schemasResultSet = ResultSetWrapper.wrap(metaData.getSchemas());
            while (schemasResultSet.next()) {
                String schema = schemasResultSet.getString("TABLE_SCHEM", 1);
                String catalog = schemasResultSet.getString("TABLE_CATALOG", 2);
                if (catalog == null && !catalogs.isEmpty()) {
                    for (String c : catalogs) {
                        if (!context.load(c, schema) || schemaFilter != null && !schemaFilter.process((Object)c, (Object)schema)) continue;
                        schemas.add(new DatabaseSchema(c, schema));
                    }
                    continue;
                }
                if (catalog == null) {
                    catalog = currentCatalog;
                }
                if (!context.load(catalog, schema) || schemaFilter != null && !schemaFilter.process((Object)catalog, (Object)schema)) continue;
                schemas.add(new DatabaseSchema(catalog, schema));
            }
        }
        catch (SQLException e) {
            context.getErrorHandler().addError(null, (Throwable)e);
        }
        finally {
            ResultSetWrapper.close(schemasResultSet);
        }
        if (schemas.isEmpty()) {
            for (String catalog : catalogs) {
                if (!context.load(catalog, null) || schemaFilter != null && !schemaFilter.process((Object)catalog, null)) continue;
                schemas.add(new DatabaseSchema(catalog, null));
            }
        }
        if (schemas.isEmpty() && context.load(null, null) && (schemaFilter == null || schemaFilter.process(null, null))) {
            schemas.add(new DatabaseSchema(null, null));
        }
        TreeSet<DatabaseSchema> treeSet = schemas;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "listSchemasToLoad"));
        }
        return treeSet;
    }

    @NotNull
    static PairProcessor<String, String> getSchemaFilter(@NotNull String schemaPattern) {
        if (schemaPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPattern", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getSchemaFilter"));
        }
        Object[] schemaPatterns = DatabaseModelLegacyLoader.splitSchemaPattern(schemaPattern);
        Arrays.sort(schemaPatterns);
        final boolean alwaysTrue = Arrays.binarySearch(schemaPatterns, "*") >= 0 || Arrays.binarySearch(schemaPatterns, "*.*") >= 0;
        PairProcessor<String, String> pairProcessor = new PairProcessor<String, String>((String[])schemaPatterns){
            final /* synthetic */ String[] val$schemaPatterns;
            {
                this.val$schemaPatterns = stringArray;
            }

            public boolean process(String catalog, String schema) {
                return alwaysTrue || Arrays.binarySearch(this.val$schemaPatterns, LoaderContext.getPattern((String)catalog, null)) >= 0 || Arrays.binarySearch(this.val$schemaPatterns, LoaderContext.getPattern((String)catalog, (String)schema)) >= 0 || Arrays.binarySearch(this.val$schemaPatterns, LoaderContext.getPattern(null, (String)schema)) >= 0;
            }
        };
        if (pairProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getSchemaFilter"));
        }
        return pairProcessor;
    }

    @NotNull
    public static String[] splitSchemaPattern(@NotNull String schemaPattern) {
        String[] stringArray;
        if (schemaPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPattern", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "splitSchemaPattern"));
        }
        if (StringUtil.isEmptyOrSpaces((String)schemaPattern)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = schemaPattern.split("[\\s,]+");
        }
        String[] strings = stringArray;
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].replaceAll("&nbsp;", " ").replaceAll("&amp;", "&");
        }
        if (strings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "splitSchemaPattern"));
        }
        return strings;
    }

    @NotNull
    public static String joinSchemaPattern(@NotNull Iterable<String> schemas) {
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "joinSchemaPattern"));
        }
        String string = StringUtil.join(schemas, (Function)new Function<String, String>(){

            public String fun(@NotNull String s) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$9", "fun"));
                }
                return s.replaceAll("&", "&amp;").replaceAll(" ", "&nbsp;");
            }
        }, (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "joinSchemaPattern"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static List<DatabaseTableData> loadTableList(@NotNull LoaderContext context, @NotNull DatabaseSchema schemaPair, @NotNull Condition<DasObject> objectFilter, @NotNull String[] types, @NotNull List<DatabaseTableData> existingTables, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator) throws SQLException {
        boolean hasNext;
        ResultSetWrapper rs;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (objectFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectFilter", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (existingTables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingTables", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        indicator.checkCanceled();
        String catalog = schemaPair.getCatalog();
        String schema = schemaPair.getName();
        String schemaTitle = QNameUtil.getQualifiedName(catalog, schema, "*");
        indicator.setText("Table list in " + schemaTitle);
        ArrayList<DatabaseTableData> result = new ArrayList<DatabaseTableData>();
        try {
            rs = ResultSetWrapper.wrap(metaData.getTables(catalog, schema, "%", types));
            hasNext = rs.next();
            if (!hasNext && types.length != 1) {
                ResultSetWrapper.close(rs);
                rs = ResultSetWrapper.wrap(metaData.getTables(catalog, schema, "%", null));
                hasNext = rs.next();
            }
        }
        catch (Exception e) {
            context.getErrorHandler().addError(null, (Throwable)e);
            ArrayList<DatabaseTableData> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
            }
            return arrayList;
        }
        try {
            while (hasNext) {
                DatabaseTableData table;
                indicator.checkCanceled();
                String tableName = rs.getString("TABLE_NAME", 3);
                String tableType = rs.getString("TABLE_TYPE", 4);
                String remarks = rs.getString("REMARKS", 5);
                hasNext = rs.next();
                if (tableType != null && StringUtil.containsIgnoreCase((String)tableType, (String)"TEMPORARY") || StringUtil.isEmpty((String)tableName) || context.getFamilyId().isPostgres() && "INDEX".equals(tableType) || !objectFilter.value((Object)(table = new DatabaseTableData(tableName, schemaPair, TableType.findByName(tableType).getKind())))) continue;
                table.setComment(remarks);
                if (!context.getDataSource().shouldIncludeElement((DasObject)table)) continue;
                DatabaseTableData existing = DatabaseModelLegacyLoader.findExisting(existingTables, table);
                if (existing != null) {
                    existing.setType(table.getKind());
                    existing.setComment(remarks);
                    result.add(existing);
                    continue;
                }
                result.add(table);
            }
        }
        finally {
            ResultSetWrapper.close(rs);
        }
        ArrayList<DatabaseTableData> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableList"));
        }
        return arrayList;
    }

    private static String[] getAllTableTypes(@NotNull DatabaseMetaData metaData, ErrorHandler errorHandler) throws SQLException {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getAllTableTypes"));
        }
        HashSet<String> tableTypes = new HashSet<String>();
        for (String type : JdbcUtil.resultSetToListSafe((ResultSet)metaData.getTableTypes(), (String)"TABLE_TYPE", (ErrorHandler)errorHandler)) {
            tableTypes.add(StringUtil.notNullize((String)type).trim());
        }
        tableTypes.addAll(Arrays.asList("SEQUENCE", "SYNONYM", "TABLE", "VIEW"));
        return ArrayUtil.toStringArray(tableTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static List<DatabaseProcedure> loadProcedures(@NotNull LoaderContext context, @NotNull DatabaseSchema schema, @NotNull Condition<DasObject> objectFilter, @NotNull List<DatabaseProcedure> existingProcedures, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator) throws SQLException {
        ResultSetWrapper rs;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        if (objectFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectFilter", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        if (existingProcedures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingProcedures", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        indicator.checkCanceled();
        String catalog = schema.getCatalog();
        String schemaName = schema.getName();
        String schemaTitle = QNameUtil.getQualifiedName(catalog, schemaName, "*");
        indicator.setText("Routine list in " + schemaTitle);
        ArrayList result = ContainerUtil.newArrayList();
        String realCatalog = StringUtil.isEmpty((String)metaData.getCatalogTerm()) ? StringUtil.notNullize((String)catalog) : null;
        boolean groupIdAllowed = context.getFamilyId().isTransactSql();
        String requestCatalog = StringUtil.isEmpty((String)metaData.getCatalogTerm()) ? StringUtil.nullize((String)catalog) : catalog;
        try {
            rs = ResultSetWrapper.wrap(metaData.getProcedures(requestCatalog, schemaName, null));
        }
        catch (Exception e) {
            context.getErrorHandler().addError(null, (Throwable)e);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
            }
            return arrayList;
        }
        try {
            while (rs.next()) {
                Pattern pattern;
                indicator.checkCanceled();
                String procCatalog = rs.getString("PROCEDURE_CAT", 1);
                String procSchema = StringUtil.notNullize((String)rs.getString("PROCEDURE_SCHEM", 2), (String)StringUtil.notNullize((String)schemaName));
                String procName = DatabaseModelLegacyLoader.fixProcedureName(groupIdAllowed, rs.getString("PROCEDURE_NAME", 3));
                if (StringUtil.isEmpty((String)procName) || !StringUtil.equalsIgnoreCase((CharSequence)schemaName, (CharSequence)procSchema) || (pattern = context.getProcedurePattern()) != null && !pattern.matcher(procName).matches()) continue;
                DasRoutine.Kind kind = ProcedureType.findByID(rs.getShort("PROCEDURE_TYPE", 8)).getKind();
                if (context.getFamilyId().isSybase() && kind == DasRoutine.Kind.NONE) {
                    kind = DasRoutine.Kind.PROCEDURE;
                }
                String remarks = rs.getString("REMARKS", 7);
                DatabaseProcedure procedure = new DatabaseProcedure(procName, schema, realCatalog != null ? StringUtil.nullize((String)procCatalog) : null, kind);
                if (!objectFilter.value((Object)procedure)) continue;
                procedure.setComment(remarks);
                if (!context.getDataSource().shouldIncludeElement((DasObject)procedure)) continue;
                DatabaseProcedure existing = DatabaseModelLegacyLoader.findExisting(existingProcedures, procedure);
                if (existing != null) {
                    existing.setRoutineKind(procedure.getRoutineKind());
                    existing.setComment(remarks);
                    result.add(existing);
                    continue;
                }
                result.add(procedure);
            }
        }
        finally {
            ResultSetWrapper.close(rs);
        }
        if (context.getFamilyId().isSybase() && !Comparing.equal((String)schemaName, (String)"dbo")) {
            List<DatabaseTableData> tables = DatabaseModelLegacyLoader.loadTableList(context, schema, (Condition<DasObject>)Condition.TRUE, new String[]{"SYSTEM TABLE"}, Collections.emptyList(), metaData, indicator);
            for (DatabaseTableData table : tables) {
                DatabaseProcedure procedure = new DatabaseProcedure(table.getName(), table.getDbParent(), null, DasRoutine.Kind.NONE);
                DatabaseProcedure existing = DatabaseModelLegacyLoader.findExisting(existingProcedures, procedure);
                result.add(existing != null ? existing : procedure);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedures"));
        }
        return arrayList;
    }

    @Nullable
    private static String fixProcedureName(boolean groupIdAllowed, @Nullable String name) {
        int idx;
        if (groupIdAllowed && name != null && (idx = name.indexOf(59)) > -1 && StringUtil.parseInt((String)name.substring(idx + 1), (int)-1) >= 0) {
            name = name.substring(0, idx);
        }
        return name;
    }

    @Nullable
    private static <T extends DasObject> T findExisting(@NotNull List<T> existing, T o) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "findExisting"));
        }
        int index = Collections.binarySearch(existing, o, ELEMENT_COMPARATOR);
        return (T)(index >= 0 ? (DasObject)existing.get(index) : null);
    }

    static <T extends DatabaseObject> void loadElementDetails(@NotNull LoaderContext context, @NotNull List<T> elements, @NotNull Class<T> elementClass, @NotNull DatabaseSchema schemaPair, boolean loadDetails, @NotNull THashMap<DatabaseObject, Object> stateMap, @NotNull DatabaseMetaData metaData, final @NotNull ProgressIndicator indicator) {
        String elementName;
        boolean loadSomething;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadElementDetails"));
        }
        indicator.checkCanceled();
        boolean isTableMode = elementClass == DatabaseTableData.class;
        boolean bl = loadSomething = context.load(elementClass) || context.load(schemaPair.getCatalog(), null) || context.load(schemaPair.getCatalog(), schemaPair.getName()) || !loadDetails || schemaPair.getCatalog() == null && context.getFamilyId().isTransactSql() && context.load(schemaPair.getName(), schemaPair.getName());
        if (!loadSomething) {
            boolean loadAnything = false;
            for (DatabaseObject element : elements) {
                if (!context.load((Object)element)) continue;
                loadAnything = true;
                break;
            }
            if (!loadAnything) {
                return;
            }
        }
        THashMap elementMap = ContainerUtil.newTroveMap();
        for (DatabaseObject element : elements) {
            elementName = isTableMode ? element.getName() : DatabaseModelLegacyLoader.getProcName(element.getName(), ((DatabaseProcedure)element).getPackage());
            elementMap.put(elementName, element);
        }
        for (Object o : context.getSelection()) {
            if (!(o instanceof DasObject) || !elementClass.isInstance(o) || !schemaPair.equals(DatabaseModelLegacyLoader.getDatabaseSchema((DasObject)o))) continue;
            elementName = isTableMode ? ((DasTable)o).getName() : DatabaseModelLegacyLoader.getProcName(((DatabaseProcedure)o).getName(), ((DatabaseProcedure)o).getPackage());
            elementMap.put(elementName, (DatabaseObject)o);
        }
        elements.clear();
        for (Object o : elementMap.values()) {
            elements.add(o);
        }
        Collections.sort(elements, ELEMENT_COMPARATOR);
        final int totalCount = elements.size();
        final int[] count = new int[]{0};
        Processor<String> progressUpdater = new Processor<String>(){

            public boolean process(String message) {
                indicator.checkCanceled();
                count[0] = count[0] + 1;
                indicator.setText2(message);
                indicator.setFraction((double)count[0] / (double)totalCount);
                return true;
            }
        };
        indicator.setIndeterminate(false);
        Processor<DatabaseObject> loadProcessor = isTableMode ? DatabaseModelLegacyLoader.loadTableBasics(context, schemaPair, metaData, indicator, progressUpdater, loadDetails, (Map<String, DatabaseObject>)elementMap, stateMap) : DatabaseModelLegacyLoader.loadProcedureBasics(context, schemaPair, metaData, indicator, progressUpdater, loadDetails, (Map<String, DatabaseObject>)elementMap, stateMap);
        int errorCounter = 0;
        int counter = 0;
        Iterator<T> iterator = elements.iterator();
        while (iterator.hasNext()) {
            indicator.checkCanceled();
            DatabaseObject o = (DatabaseObject)iterator.next();
            boolean updateThis = context.load((Object)o);
            if (updateThis) {
                if (!DatabaseModelLegacyLoader.elementExists(context, o, metaData)) {
                    progressUpdater.process((Object)o.getName());
                    iterator.remove();
                    ++counter;
                    continue;
                }
            } else if (!loadSomething) continue;
            ++counter;
            try {
                if (loadProcessor == null || loadProcessor.process((Object)o)) continue;
                ++errorCounter;
            }
            catch (Exception ex) {
                context.getErrorHandler().addError(null, (Throwable)ex);
                ++errorCounter;
            }
        }
        if (errorCounter > 0) {
            context.getErrorHandler().setCaption(DatabaseMessages.message((String)(isTableMode ? "message.text.error.refreshing.table.header" : "message.text.error.refreshing.procedure.header"), (Object[])new Object[]{String.valueOf(counter - errorCounter), String.valueOf(counter)}));
        }
    }

    @NotNull
    private static String getProcName(@NotNull String name, @Nullable String packageName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getProcName"));
        }
        String string = packageName == null ? name : packageName + "/" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "getProcName"));
        }
        return string;
    }

    @Nullable
    private static Processor<DatabaseObject> loadTableBasics(final @NotNull LoaderContext context, final @NotNull DatabaseSchema schemaPair, final @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator, final @NotNull Processor<String> progressUpdater, final boolean loadDetails, final @NotNull Map<String, DatabaseObject> elementMap, final THashMap<DatabaseObject, Object> stateMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasics"));
        }
        String schemaTitle = QNameUtil.getQualifiedName(schemaPair.getCatalog(), schemaPair.getName(), "*");
        indicator.setText("Table " + (!loadDetails ? "columns" : "keys and indices") + " in " + schemaTitle);
        indicator.setText2("");
        boolean changed = false;
        if (!loadDetails && elementMap.size() <= 2) {
            changed = DatabaseModelLegacyLoader.loadTableBasicsInner(context, schemaPair, metaData, progressUpdater, elementMap, stateMap);
        }
        final boolean perElementMode = !loadDetails && !changed && !elementMap.isEmpty();
        return new Processor<DatabaseObject>(){

            public boolean process(@NotNull DatabaseObject info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$11", "process"));
                }
                if (perElementMode) {
                    DatabaseModelLegacyLoader.loadTableBasicsInner(context, schemaPair, metaData, (Processor<String>)progressUpdater, DatabaseModelLegacyLoader.singletonMap(elementMap, info), (Map)stateMap);
                } else if (loadDetails) {
                    DatabaseTableData.State state = (DatabaseTableData.State)stateMap.get((Object)info);
                    if (state != null) {
                        progressUpdater.process((Object)info.getName());
                        DatabaseModelLegacyLoader.loadTableState(context, state, (DatabaseTableData)info, metaData);
                    }
                    stateMap.put((Object)info, (Object)(state != null ? state : new DatabaseTableData.State()));
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadTableBasicsInner(@NotNull LoaderContext context, @NotNull DatabaseSchema schemaPair, @NotNull DatabaseMetaData metaData, @NotNull Processor<String> progressUpdater, @NotNull Map<String, DatabaseObject> elementMap, @NotNull Map<DatabaseObject, Object> stateMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadTableBasicsInner"));
        }
        String lastName = null;
        ResultSetWrapper rs = null;
        try {
            String namePattern = elementMap.size() == 1 ? (String)ContainerUtil.getFirstItem(elementMap.keySet()) : "";
            rs = ResultSetWrapper.wrap(metaData.getColumns(schemaPair.getCatalog(), schemaPair.getName(), namePattern, null));
            while (rs.next()) {
                DatabaseTableData.State state;
                String curName = rs.getString("TABLE_NAME", 3);
                DatabaseTableData curElement = (DatabaseTableData)elementMap.get(curName);
                if (curElement == null) continue;
                if (!Comparing.equal(lastName, (String)curName)) {
                    lastName = curName;
                    progressUpdater.process((Object)curElement.getName());
                }
                if ((state = (DatabaseTableData.State)stateMap.get(curElement)) == null) {
                    state = new DatabaseTableData.State();
                    stateMap.put(curElement, state);
                }
                try {
                    DatabaseTableFieldData tableFieldData = DatabaseModelLegacyLoader.tableColumnFromRow(context, curElement, rs);
                    state.columns.add(tableFieldData);
                    String autoincrementYesNo = rs.getString("IS_AUTOINCREMENT", 23);
                    boolean autoIncrement = "yes".equalsIgnoreCase(autoincrementYesNo);
                    if (autoincrementYesNo == null && (context.getFamilyId().isSybase() || context.getFamilyId().isMicrosoft())) {
                        autoIncrement = tableFieldData.getSqlType().endsWith(" identity");
                    }
                    if (!autoIncrement) continue;
                    state.autoIncrement.add(tableFieldData.getName());
                }
                catch (Exception ex) {
                    context.getErrorHandler().addError(QNameUtil.getQualifiedName(schemaPair.getCatalog(), schemaPair.getName(), curName), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            boolean bl;
            try {
                String schemaTitle = QNameUtil.getQualifiedName(schemaPair.getCatalog(), schemaPair.getName(), "*");
                context.getErrorHandler().addError(schemaTitle, (Throwable)ex);
                bl = false;
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(rs);
                throw throwable;
            }
            ResultSetWrapper.close(rs);
            return bl;
        }
        ResultSetWrapper.close(rs);
        return lastName != null;
    }

    @Nullable
    private static Processor<DatabaseObject> loadProcedureBasics(final @NotNull LoaderContext context, final @NotNull DatabaseSchema schemaPair, final @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator, final @NotNull Processor<String> progressUpdater, boolean loadDetails, final @NotNull Map<String, DatabaseObject> elementMap, final @NotNull THashMap<DatabaseObject, Object> stateMap) {
        boolean perElementMode;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasics"));
        }
        String schemaTitle = QNameUtil.getQualifiedName(schemaPair.getCatalog(), schemaPair.getName(), "*");
        indicator.setText("Routine prototypes in " + schemaTitle);
        indicator.setText2("");
        if (loadDetails) {
            return null;
        }
        if (elementMap.size() <= 2) {
            boolean changed = false;
            for (DatabaseObject info : elementMap.values()) {
                changed |= DatabaseModelLegacyLoader.loadProcedureBasicsInner(context, schemaPair, metaData, progressUpdater, DatabaseModelLegacyLoader.singletonMap(elementMap, info), stateMap);
            }
            if (!changed) {
                return null;
            }
        } else if (!DatabaseModelLegacyLoader.loadProcedureBasicsInner(context, schemaPair, metaData, progressUpdater, elementMap, stateMap)) {
            return null;
        }
        boolean bl = perElementMode = stateMap.isEmpty() && !elementMap.isEmpty();
        if (context.getFamilyId().isSybase()) {
            try {
                DatabaseModelLegacyLoader.loadSybaseProcedures(context, schemaPair, metaData, indicator, elementMap, stateMap);
            }
            catch (SQLException ex) {
                context.getErrorHandler().addError(null, (Throwable)ex);
            }
        }
        if (!perElementMode) {
            for (int i = stateMap.size(); i < elementMap.size(); ++i) {
                progressUpdater.process((Object)"Skipping no-arg procedures");
            }
        }
        return new Processor<DatabaseObject>(){

            public boolean process(@NotNull DatabaseObject info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$12", "process"));
                }
                if (perElementMode) {
                    DatabaseModelLegacyLoader.loadProcedureBasicsInner(context, schemaPair, metaData, (Processor<String>)progressUpdater, DatabaseModelLegacyLoader.singletonMap(elementMap, info), (THashMap<DatabaseObject, Object>)stateMap);
                }
                return true;
            }
        };
    }

    private static void loadSybaseProcedures(@NotNull LoaderContext context, @NotNull DatabaseSchema schemaPair, @NotNull DatabaseMetaData metaData, @NotNull ProgressIndicator indicator, @NotNull Map<String, DatabaseObject> elementMap, @NotNull THashMap<DatabaseObject, Object> stateMap) throws SQLException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadSybaseProcedures"));
        }
        List<DatabaseTableData> tables = DatabaseModelLegacyLoader.loadTableList(context, schemaPair, (Condition<DasObject>)Condition.TRUE, new String[]{"SYSTEM TABLE"}, Collections.emptyList(), metaData, indicator);
        THashMap tabStates = ContainerUtil.newIdentityTroveMap();
        DatabaseModelLegacyLoader.loadElementDetails(context, tables, DatabaseTableData.class, schemaPair, false, (THashMap<DatabaseObject, Object>)tabStates, metaData, indicator);
        ArrayList parameters = ContainerUtil.newArrayList();
        DatabaseArgument retArg = null;
        for (DatabaseTableData table : tables) {
            DatabaseTableData.State tabState = (DatabaseTableData.State)tabStates.get((Object)table);
            List<Object> columns = tabState == null ? Collections.emptyList() : tabState.columns;
            DatabaseFieldBase returnType = (DatabaseFieldBase)QNameUtil.findByName("Return Type", columns);
            DatabaseProcedure procedure = new DatabaseProcedure(table.getName(), schemaPair, null, DasRoutine.Kind.NONE);
            DatabaseProcedure existing = (DatabaseProcedure)elementMap.get(table.getName());
            if (existing != null) {
                procedure = existing;
            }
            procedure.setRoutineKind(returnType != null ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            int index = 1;
            for (DatabaseTableFieldData databaseTableFieldData : columns) {
                DatabaseArgument parameter = new DatabaseArgument(ProcedureParameterType.IN, databaseTableFieldData.getName(), databaseTableFieldData, procedure);
                if (databaseTableFieldData == returnType) {
                    parameter.setParameterType(ProcedureParameterType.RETURN);
                    retArg = parameter;
                    continue;
                }
                parameter.setIndex(index++);
                parameters.add(parameter);
            }
            DatabaseProcedure.State state = new DatabaseProcedure.State(ContainerUtil.newArrayList((Iterable)parameters), retArg);
            stateMap.put((Object)procedure, (Object)state);
            parameters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadProcedureBasicsInner(@NotNull LoaderContext context, @NotNull DatabaseSchema schemaPair, @NotNull DatabaseMetaData metaData, @NotNull Processor<String> progressUpdater, @NotNull Map<String, DatabaseObject> elementMap, @NotNull THashMap<DatabaseObject, Object> stateMap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        if (schemaPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPair", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        if (stateMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "loadProcedureBasicsInner"));
        }
        String lastSpecificName = null;
        DatabaseProcedure lastProc = null;
        ArrayList<DatabaseArgument> parameters = new ArrayList<DatabaseArgument>();
        DatabaseArgument retArg = null;
        boolean groupIdAllowed = context.getFamilyId().isTransactSql();
        ResultSetWrapper rs = null;
        try {
            String realCatalog = StringUtil.isEmpty((String)metaData.getCatalogTerm()) ? StringUtil.notNullize((String)schemaPair.getCatalog()) : null;
            String namePattern = elementMap.size() == 1 ? ((DatabaseObject)ContainerUtil.getFirstItem(elementMap.values())).getName() : null;
            try {
                rs = ResultSetWrapper.wrap(metaData.getProcedureColumns(schemaPair.getCatalog(), schemaPair.getName(), namePattern, null));
            }
            catch (Exception e) {
                rs = ResultSetWrapper.wrap(metaData.getProcedureColumns(schemaPair.getCatalog(), schemaPair.getName(), null, null));
            }
            while (rs.next()) {
                String curName = DatabaseModelLegacyLoader.fixProcedureName(groupIdAllowed, rs.getString("PROCEDURE_NAME", 3));
                String curPackage = realCatalog != null ? StringUtil.nullize((String)rs.getString("PROCEDURE_CAT", 1)) : null;
                String curSpecificName = DatabaseModelLegacyLoader.getSpecificName(rs.getString("SPECIFIC_NAME", 20), curName, curPackage);
                DatabaseProcedure curElement = (DatabaseProcedure)elementMap.get(DatabaseModelLegacyLoader.getProcName(curName, curPackage));
                if (curElement == null) continue;
                if (!Comparing.equal(lastSpecificName, (String)curSpecificName)) {
                    if (lastProc != null && !parameters.isEmpty()) {
                        Collections.sort(parameters);
                        stateMap.put((Object)lastProc, (Object)new DatabaseProcedure.State(ContainerUtil.newArrayList(parameters), retArg));
                        parameters.clear();
                    }
                    lastSpecificName = curSpecificName;
                    lastProc = curElement;
                    progressUpdater.process((Object)curElement.getName());
                }
                try {
                    DatabaseArgument column = DatabaseModelLegacyLoader.procedureColumnFromRow(curElement, rs);
                    if (curElement.getRoutineKind() == DasRoutine.Kind.FUNCTION && (column.getIndex() == 0 || column.getIndex() == -1 && "returnValue".equals(column.getName()) || column.getIndex() == -1 && "@RETURN_VALUE".equals(column.getName()) || context.getFamilyId().isMysql() && parameters.isEmpty())) {
                        if (!column.getArgumentDirection().isReturnOrResult()) {
                            column.setParameterType(ProcedureParameterType.RETURN);
                        }
                        retArg = column;
                        continue;
                    }
                    if (curElement.getRoutineKind() != DasRoutine.Kind.FUNCTION && column.getIndex() == 0 && "RETURN_VALUE".equals(column.getName())) continue;
                    parameters.add(column);
                }
                catch (Exception ex) {
                    context.getErrorHandler().addError(QNameUtil.getQualifiedName(curElement), (Throwable)ex);
                }
            }
            if (lastProc != null) {
                Collections.sort(parameters);
                stateMap.put(lastProc, (Object)new DatabaseProcedure.State(ContainerUtil.newArrayList(parameters), retArg));
                progressUpdater.process((Object)lastProc.getName());
            }
            ResultSetWrapper.close(rs);
        }
        catch (Exception ex) {
            String schemaTitle = QNameUtil.getQualifiedName(schemaPair.getCatalog(), schemaPair.getName(), "*");
            context.getErrorHandler().addError(schemaTitle, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ResultSetWrapper.close(rs);
        }
        return true;
    }

    @Nullable
    private static String getSpecificName(@Nullable String specificName, @Nullable String curName, @Nullable String pack) {
        if (StringUtil.isEmptyOrSpaces((String)specificName)) {
            specificName = curName;
        }
        specificName = DatabaseModelLegacyLoader.getProcName(specificName, pack);
        return specificName;
    }

    @Nullable
    private static <T extends DasObject> Map<String, T> singletonMap(final @NotNull Map<String, T> elementMap, final @NotNull T info) {
        if (elementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMap", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "singletonMap"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "singletonMap"));
        }
        return new AbstractMap<String, T>(){

            @Override
            @Nullable
            public T get(Object key) {
                DasObject t = (DasObject)elementMap.get(key);
                return t == info ? t : null;
            }

            @Override
            @NotNull
            public Set<Map.Entry<String, T>> entrySet() {
                Set set = Collections.singleton(new AbstractMap.SimpleImmutableEntry<String, DasObject>(info.getName(), info));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$13", "entrySet"));
                }
                return set;
            }
        };
    }

    @NotNull
    public static <K, V> Map<K, List<V>> classify(@NotNull Iterator<? extends V> iterator, @NotNull Convertor<V, K> keyConvertor) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "classify"));
        }
        if (keyConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyConvertor", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "classify"));
        }
        LinkedHashMap<Object, ArrayList<V>> hashMap = new LinkedHashMap<Object, ArrayList<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            Object key = keyConvertor.convert(value);
            ArrayList<V> set = (ArrayList<V>)hashMap.get(key);
            if (set == null) {
                set = new ArrayList<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        LinkedHashMap<Object, ArrayList<V>> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "classify"));
        }
        return linkedHashMap;
    }

    static void convertForeignKeys(@NotNull DatabaseTableData.State state, @NotNull DatabaseTableData table, @NotNull List<ForeignKey> relations, boolean imported) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "convertForeignKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "convertForeignKeys"));
        }
        if (relations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relations", "com/intellij/database/dataSource/DatabaseModelLegacyLoader", "convertForeignKeys"));
        }
        Map relationMap = ContainerUtil.classify(relations.iterator(), (Convertor)new Convertor<ForeignKey, String>(){

            @Nullable
            public String convert(@NotNull ForeignKey o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$14", "convert"));
                }
                return o.RELATION_NAME;
            }
        });
        for (String name : relationMap.keySet()) {
            Set set = (Set)relationMap.get(name);
            ForeignKey[] foreignKeys = set.toArray(new ForeignKey[set.size()]);
            Arrays.sort(foreignKeys, new Comparator<ForeignKey>(){

                @Override
                public int compare(@NotNull ForeignKey o1, @NotNull ForeignKey o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$15", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$15", "compare"));
                    }
                    return o1.KEY_SEQ - o2.KEY_SEQ;
                }
            });
            if (imported) {
                DatabaseForeignKey key = new DatabaseForeignKey(table);
                key.setName(name);
                ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)foreignKeys.length);
                ArrayList refColumns = ContainerUtil.newArrayListWithCapacity((int)foreignKeys.length);
                for (ForeignKey foreignKey : foreignKeys) {
                    columns.add(foreignKey.SOURCE_COLUMN);
                    refColumns.add(foreignKey.TARGET_COLUMN);
                }
                key.setRefTableName(foreignKeys[0].TARGET_TABLE);
                key.setRefSchema(foreignKeys[0].TARGET_SCHEMA);
                key.setRefCatalog(foreignKeys[0].TARGET_CATALOG);
                key.setColumnNames((Iterable)columns);
                key.setRefColumnNames(refColumns);
                key.setUpdateRule(JdbcUtil.getRuleAction((short)foreignKeys[0].UPDATE_RULE));
                key.setDeleteRule(JdbcUtil.getRuleAction((short)foreignKeys[0].DELETE_RULE));
                key.setDeferrability(JdbcUtil.getDeferrability((short)foreignKeys[0].DEFERRABILITY));
                state.foreignKeys.add(key);
                continue;
            }
            DatabaseTableData tableData = new DatabaseTableData(foreignKeys[0].SOURCE_TABLE, StringUtil.notNullize((String)foreignKeys[0].SOURCE_SCHEMA, (String)table.getSchema()), StringUtil.notNullize((String)foreignKeys[0].SOURCE_CATALOG, (String)table.getCatalog()), ObjectKind.TABLE);
            DatabaseTableKey key = new DatabaseTableKey(tableData);
            ArrayList columns = ContainerUtil.newArrayListWithCapacity((int)foreignKeys.length);
            for (ForeignKey foreignKey : foreignKeys) {
                columns.add(foreignKey.SOURCE_COLUMN);
            }
            key.setName(name);
            key.setColumnNames((Iterable)columns);
            state.exportedKeys.add(key);
        }
    }

    static class RemoteResultSetWrapper
    extends ResultSetWrapper {
        private RemoteResultSet myResultSet;
        @Nullable
        private List<Object[]> myRows;
        private int myPosition;
        private boolean myFinished;

        public RemoteResultSetWrapper(ResultSet rs, @NotNull RemoteResultSet remoteResultSet) throws SQLException {
            if (remoteResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteResultSet", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$RemoteResultSetWrapper", "<init>"));
            }
            super(rs);
            this.myResultSet = remoteResultSet;
        }

        @Override
        boolean next() throws SQLException {
            if (this.myFinished) {
                return false;
            }
            ++this.myPosition;
            if (this.myRows == null || this.myPosition == this.myRows.size()) {
                this.myFinished = this.myRows != null && this.myRows.size() < 100;
                try {
                    this.myRows = this.myFinished ? null : this.myResultSet.getObjects(100, "", DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (RemoteException e) {
                    this.myRows = null;
                    throw new SQLException(e);
                }
                this.myPosition = 0;
            }
            return this.myRows != null && !this.myRows.isEmpty();
        }

        @Override
        @Nullable
        Object getObject(String column, int colNum) {
            int i = this.getColumnIndex(column, colNum);
            return i == 0 ? null : this.myRows.get(this.myPosition)[i - 1];
        }
    }

    static class LocalResultSetWrapper
    extends ResultSetWrapper {
        public LocalResultSetWrapper(ResultSet rs) throws SQLException {
            super(rs);
        }

        @Override
        boolean next() throws SQLException {
            return this.myDelegate.next();
        }

        @Override
        @Nullable
        Object getObject(String column, int colNum) throws SQLException {
            int i = this.getColumnIndex(column, colNum);
            return i == 0 ? null : this.myDelegate.getObject(i);
        }
    }

    static abstract class ResultSetWrapper {
        @Nullable
        protected final ResultSet myDelegate;
        @NotNull
        protected final TObjectIntHashMap<String> myColumnMap;
        protected final int myColumnCount;

        public ResultSetWrapper(@Nullable ResultSet rs) throws SQLException {
            this.myDelegate = rs;
            this.myColumnMap = new TObjectIntHashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ResultSetMetaData metaData = rs == null ? null : rs.getMetaData();
            this.myColumnCount = metaData == null ? 0 : metaData.getColumnCount();
            for (int i = 0; i < this.myColumnCount; ++i) {
                this.myColumnMap.put((Object)metaData.getColumnName(i + 1), i + 1);
                this.myColumnMap.put((Object)metaData.getColumnLabel(i + 1), i + 1);
            }
        }

        @Contract(value="!null->!null")
        static ResultSetWrapper wrap(@Nullable ResultSet rs) throws SQLException {
            if (rs == null) {
                return ResultSetWrapper.createEmpty();
            }
            RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemote((Object)rs, RemoteResultSet.class);
            if (remoteResultSet != null) {
                return new RemoteResultSetWrapper(rs, remoteResultSet);
            }
            return new LocalResultSetWrapper(rs);
        }

        @Nullable
        private static ResultSetWrapper createEmpty() throws SQLException {
            return new ResultSetWrapper(null){

                @Override
                boolean next() throws SQLException {
                    return false;
                }

                @Override
                @NotNull
                Object getObject(String column, int colNum) throws SQLException {
                    throw new IllegalStateException();
                }
            };
        }

        static void close(@Nullable ResultSetWrapper wrapper) {
            try {
                ResultSet delegate;
                ResultSet resultSet = delegate = wrapper == null ? null : wrapper.myDelegate;
                if (delegate != null) {
                    delegate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        abstract boolean next() throws SQLException;

        @Nullable
        abstract Object getObject(String var1, int var2) throws SQLException;

        boolean getBoolean(String column, int colNum) throws SQLException {
            return Boolean.TRUE.equals(this.getObject(column, colNum));
        }

        int getInt(String column, int colNum, int def) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof Number ? ((Number)o).intValue() : (o instanceof String ? StringUtil.parseInt((String)((String)o), (int)def) : def);
        }

        short getShort(String column, int colNum) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof Number ? ((Number)o).shortValue() : (short)0;
        }

        @Nullable
        String getString(String column, int colNum) throws SQLException {
            Object o = this.getObject(column, colNum);
            return o instanceof String ? (String)o : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        <T> List<T> list(@NotNull String columnName, int colNum, @Nullable ErrorHandler errorHandler) throws SQLException {
            if (columnName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$ResultSetWrapper", "list"));
            }
            ArrayList<Object> retVal = new ArrayList<Object>();
            try {
                while (this.next()) {
                    retVal.add(this.getObject(columnName, colNum));
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (errorHandler != null) {
                    errorHandler.addError(message.contains(columnName) ? null : columnName + " unavailable", (Throwable)e);
                }
            }
            finally {
                JdbcUtil.closeResultSetSafe((ResultSet)this.myDelegate);
            }
            ArrayList<Object> arrayList = retVal;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLegacyLoader$ResultSetWrapper", "list"));
            }
            return arrayList;
        }

        protected int getColumnIndex(String column, int colNum) {
            int i = this.myColumnMap.get((Object)column);
            if (i == 0) {
                i = colNum;
            } else if (i != colNum) {
                // empty if block
            }
            return i < 1 || i > this.myColumnCount ? 0 : i;
        }
    }

    static class ForeignKey {
        @Nullable
        String RELATION_NAME;
        @Nullable
        String TARGET_TABLE;
        @Nullable
        String TARGET_SCHEMA;
        @Nullable
        String TARGET_CATALOG;
        @Nullable
        String TARGET_COLUMN;
        @Nullable
        String SOURCE_TABLE;
        @Nullable
        String SOURCE_SCHEMA;
        @Nullable
        String SOURCE_CATALOG;
        @Nullable
        String SOURCE_COLUMN;
        public short KEY_SEQ;
        public short UPDATE_RULE;
        public short DELETE_RULE;
        public short DEFERRABILITY;

        ForeignKey() {
        }
    }
}

