/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceExplainPlanConfiguration;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.ui.LocalDbParamEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.impl.ElementBase;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import icons.DatabaseIcons;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDataSource
extends AbstractDataSource
implements RawConnectionConfig,
Iconable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.LocalDataSource");
    @NonNls
    private static final String LIBRARIES_ELEMENT_NAME = "libraries";
    @NonNls
    private static final String LIBRARY_ELEMENT_NAME = "library";
    @NonNls
    private static final String USER_KEY = "user";
    @NonNls
    private static final String PASSWORD_KEY = "password";
    @NonNls
    public static final String MY_ELEMENT_FLAG = "LOCAL";
    private DatabaseDriver myDriver;
    private String myDriverClass;
    private String myUrl;
    private DatabaseCredentials.StorageType mySecretStorage;
    private String myUsername;
    private String myEncodedPassword;
    private String mySchemaPattern;
    private String myTablePattern;
    private boolean myUseLegacyIntrospector;
    private String myDefaultSchemas;
    private String myDefaultDialect;
    @Nullable
    private String myVmOptions;
    @NotNull
    private Map<String, String> myVmEnv;
    private final Map<String, String> myDriverProperties;
    @Deprecated
    private final List<SimpleClasspathElement> myClasspathElements;
    private boolean myAutoSynchronize;
    private boolean myAutoCommit;
    private boolean myDomainAuthentication;
    private ThreeState myFirstSync;
    private boolean myConfiguredByUrl;
    private DataSourceSshTunnelConfiguration mySshConfiguration;
    private DataSourceSslConfiguration mySslCfg;
    @NotNull
    private DataSourceExplainPlanConfiguration myExplainPlanConfiguration;
    private Map<String, String> myAdditionalJdbcProperties;
    private boolean myAuthRequired;
    private boolean myImported;

    public LocalDataSource() {
        this.mySecretStorage = DatabaseCredentials.StorageType.EMBEDDED;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
    }

    public LocalDataSource(boolean imported) {
        this.mySecretStorage = DatabaseCredentials.StorageType.EMBEDDED;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myImported = imported;
    }

    public LocalDataSource(@NotNull DatabaseDriver driver, @NotNull String url) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/LocalDataSource", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/LocalDataSource", "<init>"));
        }
        this.mySecretStorage = DatabaseCredentials.StorageType.EMBEDDED;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDriver = driver;
        this.myUrl = url;
        this.myConfiguredByUrl = this.checkUrlOnly();
        this.myDriverClass = this.myDriver.getDriverClass();
        this.myDriverProperties.putAll(this.myDriver.getDriverProperties());
        this.mySecretStorage = DatabaseCredentials.StorageType.MASTER_KEY;
        this.correctExplainPlanProvider();
    }

    public LocalDataSource(String name, String driver, String url, String uid, String pwd) {
        this.mySecretStorage = DatabaseCredentials.StorageType.EMBEDDED;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.setName(name);
        this.setDriverClass(driver);
        this.setUrl(url);
        this.myUsername = uid;
        this.myEncodedPassword = pwd == null ? null : PasswordUtil.encodePassword((String)pwd);
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this);
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @Nullable
    public DatabaseDriver getDatabaseDriver() {
        return this.myDriver;
    }

    public void setDatabaseDriver(@Nullable DatabaseDriver databaseDriver) {
        this.myDriver = databaseDriver;
        this.myDriverClass = this.myDriver == null ? null : this.myDriver.getDriverClass();
    }

    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public DatabaseCredentials.StorageType getSecretStorage() {
        DatabaseCredentials.StorageType storageType = this.mySecretStorage;
        if (storageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getSecretStorage"));
        }
        return storageType;
    }

    public void setSecretStorage(@NotNull DatabaseCredentials.StorageType secretStorage) {
        if (secretStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secretStorage", "com/intellij/database/dataSource/LocalDataSource", "setSecretStorage"));
        }
        this.mySecretStorage = secretStorage;
    }

    public String getUsername() {
        return this.myUsername == null ? "" : this.myUsername;
    }

    @Deprecated
    public String getPassword() {
        if (this.myEncodedPassword == null) {
            return "";
        }
        return PasswordUtil.decodePassword((String)this.myEncodedPassword);
    }

    public void setAutoSynchronize(boolean autoSynchronize) {
        this.myAutoSynchronize = autoSynchronize;
    }

    public boolean isAutoSynchronize() {
        return this.myAutoSynchronize;
    }

    public boolean isAutoCommit() {
        return this.myAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.myAutoCommit = autoCommit;
    }

    public final Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getBaseIcon();
        return ElementBase.createLayeredIcon((Iconable)this, (Icon)icon, (int)(this.isReadOnly() ? 2048 : 0));
    }

    public Icon getBaseIcon() {
        return this.myDriver != null ? this.myDriver.getIcon(0) : DatabaseIcons.Dbms;
    }

    public void resolveDriver() {
        if (this.myDriver == null) {
            DatabaseDriver driver = DbImplUtil.guessDatabaseDriver(this);
            if (driver == null) {
                LOG.warn("Failed to guess driver for data source " + this.getName() + "{" + this.getUniqueId() + "}");
            } else {
                LOG.warn("Guess data source " + this.getName() + "{" + this.getUniqueId() + "} has a " + driver.getName() + "{" + driver.getId() + "} driver");
            }
            this.setDatabaseDriver(driver);
        }
    }

    public boolean ensureDriverConfigured() {
        if (StringUtil.isEmpty((String)this.myDriverClass)) {
            return false;
        }
        if (this.myDriver != null && this.acceptsDriver(this.myDriver)) {
            return true;
        }
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        if (this.myDriver != null) {
            for (DatabaseDriver databaseDriver : driverManager.getDrivers()) {
                if (!this.acceptsDriver(databaseDriver)) continue;
                this.myDriver = databaseDriver;
                return true;
            }
            this.myDriver = ((DatabaseDriverImpl)this.myDriver).copy(this.getName() + " driver");
        } else {
            this.myDriver = driverManager.createDriver(this.myDriverClass, this.myDriverClass, null);
        }
        ((DatabaseDriverImpl)this.myDriver).setClasspathElements(this.myClasspathElements);
        driverManager.updateDriver(this.myDriver);
        return true;
    }

    private boolean acceptsDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/LocalDataSource", "acceptsDriver"));
        }
        if (!Comparing.equal((String)this.myDriverClass, (String)driver.getDriverClass())) {
            return false;
        }
        HashSet set = ContainerUtil.newHashSet();
        for (SimpleClasspathElement element : driver.getClasspathElements()) {
            for (String s : element.getClassesRootUrls()) {
                set.add(PathUtil.getFileName((String)s));
            }
        }
        if (set.isEmpty()) {
            ((DatabaseDriverImpl)driver).setClasspathElements(this.myClasspathElements);
            return true;
        }
        for (SimpleClasspathElement e : this.myClasspathElements) {
            for (String s : e.getClassesRootUrls()) {
                if (set.contains(PathUtil.getFileName((String)s))) continue;
                return false;
            }
        }
        return true;
    }

    public void init() {
        super.init();
        if (this.myDriver == null && this.myDriverClass != null) {
            this.resolveDriver();
        }
    }

    @Override
    @Nullable
    public Connection getConnection(Project project) throws Exception {
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        return this.getConnection(driverManager, driverManager.getDefaultRunConfiguration(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Connection getConnection(final @NotNull JdbcDriverManager driverManager, final @NotNull ConsoleRunConfiguration runConfiguration) throws Exception {
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/LocalDataSource", "getConnection"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/database/dataSource/LocalDataSource", "getConnection"));
        }
        Driver driver = driverManager.getDriver(this, runConfiguration);
        final AtomicReference<Boolean> stopProcessRef = new AtomicReference<Boolean>(true);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    if (((Boolean)stopProcessRef.get()).booleanValue()) {
                        driverManager.releaseDriver(LocalDataSource.this, runConfiguration);
                    }
                }
            });
        }
        Project project = driverManager.getProject();
        String connectionUrl = this.getEffectiveUrl(driverManager);
        Properties connectionProperties = this.getConnectionProperties();
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        Pair<String, String> credentials = databaseCredentials.getCredentials(project, (DatabaseSystem)this);
        int attemptNo = 0;
        while (true) {
            if (StringUtil.isNotEmpty((String)((String)credentials.first))) {
                connectionProperties.setProperty(USER_KEY, (String)credentials.first);
            }
            if (StringUtil.isNotEmpty((String)((String)credentials.second))) {
                connectionProperties.setProperty(PASSWORD_KEY, (String)credentials.second);
            }
            try {
                LOG.info("Connecting to: " + connectionUrl);
                Connection connection = driver.connect(connectionUrl, connectionProperties);
                if (connection != null && this.isReadOnly()) {
                    connection.setReadOnly(true);
                }
                if (attemptNo != 0 || connection != null || !DatabaseFamilyId.forConnection((RawConnectionConfig)this).isPostgres()) {
                    if (connection == null) {
                        LOG.warn("Null connection returned for: " + connectionUrl);
                    }
                    Connection connection2 = connection;
                    return connection2;
                }
                connectionUrl = connectionUrl + "/";
            }
            catch (SQLException e) {
                if (e.getCause() instanceof SQLException) {
                    e = (SQLException)e.getCause();
                }
                String message = JdbcEngine.getSqlExceptionCode(e) + JdbcEngine.getMessage(e);
                String title = "Connecting to: " + connectionUrl;
                String user = StringUtil.notNullize((String)connectionProperties.getProperty(USER_KEY), (String)USER_KEY);
                if (attemptNo >= 20 || !LocalDataSource.mayRequestPassword(message, user)) {
                    LOG.warn(title);
                    LOG.warn(message);
                    throw e;
                }
                if (attemptNo == 0 && !credentials.equals(databaseCredentials.getCredentialsNoUI((DatabaseSystem)this))) {
                    credentials = databaseCredentials.getCredentialsNoUI((DatabaseSystem)this);
                } else {
                    String prompt = "The specified user/password combination is rejected";
                    prompt = prompt + (message.isEmpty() ? "." : ":<br>" + message);
                    credentials = databaseCredentials.askCredentialsWhenFailed(project, this, "<html>" + prompt + "</html>", (String)credentials.first);
                }
                if (credentials == null) {
                    LOG.warn(title);
                    LOG.warn(message);
                    throw new ProcessCanceledException();
                }
            }
            finally {
                stopProcessRef.set(false);
                ProgressManager.checkCanceled();
            }
            ++attemptNo;
        }
    }

    private static boolean mayRequestPassword(@NotNull String message, @Nullable String user) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dataSource/LocalDataSource", "mayRequestPassword"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        if (message.contains("ORA-28001:")) {
            return true;
        }
        if (message.contains("ORA-12705:")) {
            return false;
        }
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message).find();
    }

    @Nullable
    public String getEffectiveUrl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/LocalDataSource", "getEffectiveUrl"));
        }
        return this.getEffectiveUrl(JdbcDriverManager.getDriverManager(project));
    }

    @Nullable
    public String getEffectiveUrl(@NotNull JdbcDriverManager driverManager) {
        Integer localPort;
        JdbcUrlParser parser;
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/LocalDataSource", "getEffectiveUrl"));
        }
        final String localDbInst = this.myAdditionalJdbcProperties.get("LOCAL_DB_INSTANCE");
        final String localDbExec = this.myAdditionalJdbcProperties.get("LOCAL_DB_EXECUTABLE");
        if (localDbExec != null && localDbInst != null && (parser = JdbcUrlParserUtil.statefull(JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), StringUtil.notNullize((String)this.myUrl)))) != null && parser.getParameters().contains("localdb_pipe")) {
            parser.setUrlText(this.myUrl);
            if (parser.isValid()) {
                final Ref pipe = Ref.create();
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        new Task.Modal(null, "Actualizing LocalDB instance info", true){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/LocalDataSource$2$1", "run"));
                                }
                                pipe.set((Object)LocalDbParamEditor.getPipeForInstance(localDbInst, localDbExec, indicator));
                            }
                        }.queue();
                    }
                });
                if (!StringUtil.isEmpty((String)((String)pipe.get()))) {
                    parser.setParameter("localdb_pipe", (String)pipe.get());
                    return parser.getUrlText();
                }
            }
        }
        if ((localPort = driverManager.getLocalPort(this)) == null) {
            return this.myUrl;
        }
        Ref parser2 = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(this.myDriver.getJDBCUrlParsers(), StringUtil.notNullize((String)this.myUrl), (Ref<JdbcUrlParser>)parser2);
        if (hostPort == null) {
            return this.myUrl;
        }
        ((JdbcUrlParser)parser2.get()).setParameter("host", "localhost");
        ((JdbcUrlParser)parser2.get()).setParameter("port", String.valueOf(localPort));
        return ((JdbcUrlParser)parser2.get()).getUrlText();
    }

    public Driver getDriver(Project project) throws Exception {
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        return driverManager.getDriver(this, driverManager.getDefaultRunConfiguration(this));
    }

    public void releaseDriver(Project project) {
        if (this.getUniqueId() == null) {
            JdbcDriverManager.getDriverManager(project).releaseDriver(this, null);
        }
    }

    public Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        if (this.myDriver != null) {
            connectionProperties.putAll(this.myDriver.getDriverProperties());
        }
        connectionProperties.putAll(this.myDriverProperties);
        JdbcConsoleRunContext.addSslAndWinAuthProperties(this, connectionProperties);
        return connectionProperties;
    }

    public void releaseConnection(Project project, @Nullable Connection connection) {
        try {
            super.releaseConnection(project, connection);
        }
        finally {
            this.releaseDriver(project);
        }
    }

    protected boolean shouldIncludeElement(DasObject element) {
        if (this.getDriverClass().startsWith("oracle.")) {
            String pkg;
            String schema = DasUtil.getSchema((DasObject)element);
            String name = element.getName();
            String string = pkg = element instanceof DasRoutine ? ((DasRoutine)element).getPackage() : null;
            if (Comparing.equal((String)schema, (String)"sys", (boolean)false) || Comparing.equal((String)schema, (String)"system", (boolean)false)) {
                if (pkg != null && pkg.contains("$")) {
                    return false;
                }
                return !name.contains("$");
            }
            for (String prefix : Arrays.asList("BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$")) {
                if (StringUtil.startsWithIgnoreCase((String)name, (String)prefix)) {
                    return false;
                }
                if (pkg == null || !StringUtil.startsWithIgnoreCase((String)pkg, (String)prefix)) continue;
                return false;
            }
        }
        return true;
    }

    public String getSourceName() {
        return MY_ELEMENT_FLAG;
    }

    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driver) {
        this.myDriverClass = driver;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public void setUrlSmart(String url) {
        this.setUrl(url);
        this.setConfiguredByUrl(this.checkUrlOnly());
    }

    private boolean checkUrlOnly() {
        if (this.myUrl == null || this.myDriver == null) {
            return false;
        }
        StatelessJdbcUrlParser parser = JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), this.myUrl);
        if (parser == null) {
            return !StringUtil.isEmptyOrSpaces((String)this.myUrl);
        }
        JdbcUrlParser sparser = parser.createStatefull();
        sparser.setUrlText(this.myUrl);
        return !sparser.isValid() || !StringUtil.isEmpty((String)sparser.getParameter(USER_KEY)) || !StringUtil.isEmpty((String)sparser.getParameter(PASSWORD_KEY));
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    @Deprecated
    public void setPassword(String password) {
        this.myEncodedPassword = password == null ? null : PasswordUtil.encodePassword((String)password);
    }

    public void serializeHeaderInner(@Nullable Project project, HierarchicalStreamWriter serializer, DataSource.SaveMode mode) {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)(project == null ? ApplicationManager.getApplication() : project));
        if (mode.includeConfig()) {
            if (this.myDriver != null && !this.myDriver.getId().equals(this.myDriverClass)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"driver-ref", (String)this.myDriver.getId());
            }
            if (this.myAutoSynchronize) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"synchronize", (String)String.valueOf(true));
            }
            if (this.myImported) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"imported", (String)String.valueOf(true));
            }
            if (this.myConfiguredByUrl) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"configured-by-url", (String)String.valueOf(true));
            }
            if (!StringUtil.isEmpty((String)this.getComment())) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"remarks", (String)this.getComment());
            }
            if (!this.myAutoCommit) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"auto-commit", (String)String.valueOf(false));
            }
            if (StringUtil.isNotEmpty((String)this.myDriverClass)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"jdbc-driver", (String)this.myDriverClass);
            }
            if (StringUtil.isNotEmpty((String)this.myUrl)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"jdbc-url", (String)pathMacroManager.collapsePathsRecursively(this.myUrl));
            }
            if (!this.myAdditionalJdbcProperties.isEmpty()) {
                serializer.startNode("jdbc-additional-properties");
                for (Map.Entry entry : this.getAdditionalJdbcProperties().entrySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", (String)entry.getKey());
                    serializer.addAttribute("value", (String)entry.getValue());
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!(this.myExplainPlanConfiguration.isEmpty() || this.myExplainPlanConfiguration.getProviderConfig().isEmpty() && this.isDefaultExplainPlanProvider(this.myExplainPlanConfiguration.getProviderClass()))) {
                serializer.startNode("explain-plan-config");
                this.myExplainPlanConfiguration.serialize(serializer);
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySecretStorage != DatabaseCredentials.StorageType.EMBEDDED) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"secret-storage", (String)StringUtil.toLowerCase((String)this.mySecretStorage.name()));
            }
            if (this.myDomainAuthentication) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"domain-auth", (String)String.valueOf(true));
            }
            if (!this.myAuthRequired) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"auth-required", (String)String.valueOf(false));
            }
            if (this.myFirstSync == ThreeState.YES) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"first-sync", (String)String.valueOf(true));
            }
            if (StringUtil.isNotEmpty((String)this.myUsername)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"user-name", (String)this.myUsername);
            }
            if (StringUtil.isNotEmpty((String)this.myEncodedPassword)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"user-password", (String)this.myEncodedPassword);
            }
            if (StringUtil.isNotEmpty((String)this.mySchemaPattern)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"schema-pattern", (String)this.mySchemaPattern);
            }
            if (StringUtil.isNotEmpty((String)this.myDefaultSchemas)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"default-schemas", (String)this.myDefaultSchemas);
            }
            if (StringUtil.isNotEmpty((String)this.myTablePattern)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"table-pattern", (String)this.myTablePattern);
            }
            if (this.myUseLegacyIntrospector) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"legacy-introspector", (String)"true");
            }
        }
        if (mode.includeConfig()) {
            if (StringUtil.isNotEmpty((String)this.myDefaultDialect)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"default-dialect", (String)this.myDefaultDialect);
            }
            if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
                LocalDataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"vm-options", (String)this.myVmOptions);
            }
            if (!this.myVmEnv.isEmpty()) {
                serializer.startNode("vm-env");
                for (String string : this.myVmEnv.keySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", string);
                    serializer.addAttribute("value", this.myVmEnv.get(string));
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!this.myDriverProperties.isEmpty()) {
                serializer.startNode("driver-properties");
                for (String string : this.myDriverProperties.keySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", string);
                    serializer.addAttribute("value", this.myDriverProperties.get(string));
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!this.myClasspathElements.isEmpty()) {
                serializer.startNode(LIBRARIES_ELEMENT_NAME);
                for (SimpleClasspathElement simpleClasspathElement : this.myClasspathElements) {
                    Element element = new Element(LIBRARY_ELEMENT_NAME);
                    try {
                        simpleClasspathElement.serialize(element);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    pathMacroManager.collapsePaths(element);
                    new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new JDomReader(element), serializer);
                }
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty()) {
                this.mySshConfiguration.serialize(serializer);
            }
            if (this.mySslCfg != null && !this.mySslCfg.isEmpty()) {
                this.mySslCfg.serialize(serializer);
            }
        }
    }

    public void deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull DataSource.SaveMode mode) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LocalDataSource", "deserialize"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/LocalDataSource", "deserialize"));
        }
        if (mode.includeConfig()) {
            this.myClasspathElements.clear();
        }
        super.deserialize(project, reader, mode);
        this.correctExplainPlanProvider();
    }

    protected boolean deserializeHeaderInner(@Nullable Project project, HierarchicalStreamReader xmlReader, DataSource.SaveMode mode) {
        if (!mode.includeConfig() && !mode.includeLocalConfig()) {
            return false;
        }
        if (project != null && project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)(project == null ? ApplicationManager.getApplication() : project));
        String nodeName = xmlReader.getNodeName();
        if (LIBRARIES_ELEMENT_NAME.equals(nodeName)) {
            this.myClasspathElements.clear();
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if (LIBRARY_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                    JDomWriter writer = new JDomWriter((JDOMFactory)new DefaultJDOMFactory());
                    new HierarchicalStreamCopier().copy(xmlReader, (HierarchicalStreamWriter)writer);
                    Element element = (Element)ContainerUtil.getFirstItem((List)writer.getTopLevelNodes());
                    pathMacroManager.expandPaths(element);
                    this.myClasspathElements.addAll(SimpleClasspathElementFactory.createElements((Project)project, (Element)element));
                }
                xmlReader.moveUp();
            }
        } else if ("explain-plan-config".equals(nodeName)) {
            this.myExplainPlanConfiguration.deserialize(xmlReader);
        } else if ("driver-ref".equals(nodeName)) {
            this.myDriver = this.getDriverById(xmlReader.getValue());
        } else if ("synchronize".equals(nodeName)) {
            this.myAutoSynchronize = Boolean.valueOf(xmlReader.getValue());
        } else if ("imported".equals(nodeName)) {
            this.myImported = Boolean.valueOf(xmlReader.getValue());
        } else if ("configured-by-url".equals(nodeName)) {
            this.myConfiguredByUrl = Boolean.valueOf(xmlReader.getValue());
        } else if ("remarks".equals(nodeName)) {
            this.setComment(xmlReader.getValue());
        } else if ("auto-commit".equals(nodeName)) {
            this.myAutoCommit = Boolean.valueOf(xmlReader.getValue());
        } else if ("auth-required".equals(nodeName)) {
            this.myAuthRequired = Boolean.valueOf(xmlReader.getValue());
        } else if ("domain-auth".equals(nodeName)) {
            this.myDomainAuthentication = Boolean.valueOf(xmlReader.getValue());
        } else if ("first-sync".equals(nodeName)) {
            this.myFirstSync = ThreeState.fromBoolean((boolean)Boolean.valueOf(xmlReader.getValue()));
        } else if ("jdbc-driver".equals(nodeName)) {
            this.myDriverClass = xmlReader.getValue();
        } else if ("jdbc-url".equals(nodeName)) {
            this.myUrl = pathMacroManager.expandPath(xmlReader.getValue());
        } else if ("jdbc-additional-properties".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myAdditionalJdbcProperties.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("secret-storage".equals(nodeName)) {
            this.mySecretStorage = DatabaseCredentials.StorageType.valueOf(StringUtil.toUpperCase((String)xmlReader.getValue()));
        } else if ("user-name".equals(nodeName)) {
            this.myUsername = xmlReader.getValue();
        } else if ("user-password".equals(nodeName)) {
            this.myEncodedPassword = xmlReader.getValue();
        } else if ("schema-pattern".equals(nodeName)) {
            this.mySchemaPattern = xmlReader.getValue();
        } else if ("default-schemas".equals(nodeName)) {
            this.myDefaultSchemas = xmlReader.getValue();
        } else if ("table-pattern".equals(nodeName)) {
            this.myTablePattern = xmlReader.getValue();
        } else if ("legacy-introspector".equals(nodeName)) {
            this.myUseLegacyIntrospector = "true".equals(xmlReader.getValue());
        } else if ("default-dialect".equals(nodeName)) {
            this.myDefaultDialect = xmlReader.getValue();
        } else if ("vm-options".equals(nodeName)) {
            this.myVmOptions = xmlReader.getValue();
        } else if ("use-ssl".equals(nodeName) && Boolean.valueOf(xmlReader.getValue()).booleanValue()) {
            if (this.mySslCfg == null) {
                this.mySslCfg = new DataSourceSslConfiguration("", "", "", true);
            } else {
                this.mySslCfg.myEnabled = true;
            }
        } else if ("ssl-ca-cert".equals(nodeName) && !StringUtil.isEmptyOrSpaces((String)xmlReader.getValue())) {
            if (this.mySslCfg == null) {
                this.mySslCfg = new DataSourceSslConfiguration(xmlReader.getValue(), "", "", false);
            } else {
                this.mySslCfg.myCaCertPath = xmlReader.getValue();
            }
        } else if ("driver-properties".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myDriverProperties.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("vm-env".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myVmEnv.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("ssh-properties".equals(nodeName)) {
            this.mySshConfiguration = DataSourceSshTunnelConfiguration.deserialize(xmlReader, this);
        } else if ("ssl-config".equals(nodeName)) {
            this.mySslCfg = DataSourceSslConfiguration.deserialize(xmlReader);
        } else {
            return super.deserializeHeaderInner(project, xmlReader, mode);
        }
        return true;
    }

    @Nullable
    private DatabaseDriver getDriverById(@Nullable String id) {
        DatabaseDriver driver = DatabaseDriverManager.getInstance().getDriver(id);
        if (driver == null) {
            LOG.warn("Failed to find driver with id {" + id + "} for data source " + this.getName() + "{" + this.getUniqueId() + "}");
        }
        return driver;
    }

    @NotNull
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myDriver != null && this.myDriver.isDownloaded()) {
            List<SimpleClasspathElement> list = this.myDriver.getClasspathElements();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getClasspathElements"));
            }
            return list;
        }
        List<SimpleClasspathElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getClasspathElements"));
        }
        return list;
    }

    @Deprecated
    public void setClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myClasspathElements.clear();
        this.myClasspathElements.addAll(classpathElements);
    }

    @Deprecated
    @NotNull
    public List<SimpleClasspathElement> getOwnClasspath() {
        List<SimpleClasspathElement> list = this.myClasspathElements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getOwnClasspath"));
        }
        return list;
    }

    @Override
    public String getSchemaPattern() {
        return this.mySchemaPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.mySchemaPattern = schemaPattern;
    }

    public String getDefaultSchemas() {
        return this.myDefaultSchemas;
    }

    public void setDefaultSchemas(String defaultSchemas) {
        this.myDefaultSchemas = defaultSchemas;
    }

    public String getDefaultDialect() {
        if (this.myDefaultDialect != null) {
            return this.myDefaultDialect;
        }
        if (this.myDriver != null) {
            return this.myDriver.getDialect();
        }
        return null;
    }

    public void setDefaultDialect(String defaultDialect) {
        this.myDefaultDialect = defaultDialect;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getDriverProperties() {
        Map<String, String> map = this.myDriverProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getDriverProperties"));
        }
        return map;
    }

    @Override
    public String getTablePattern() {
        return this.myTablePattern;
    }

    @Override
    protected boolean useLegacyIntrospector() {
        return this.myUseLegacyIntrospector;
    }

    public void setUseLegacyIntrospector(boolean useLegacyIntrospector) {
        this.myUseLegacyIntrospector = useLegacyIntrospector;
    }

    public void setTablePattern(String tablePattern) {
        this.myTablePattern = tablePattern;
    }

    @NotNull
    public DataSourceExplainPlanConfiguration getExplainPlanConfiguration() {
        DataSourceExplainPlanConfiguration dataSourceExplainPlanConfiguration = this.myExplainPlanConfiguration;
        if (dataSourceExplainPlanConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getExplainPlanConfiguration"));
        }
        return dataSourceExplainPlanConfiguration;
    }

    public DataSourceSshTunnelConfiguration getSshConfiguration() {
        return this.mySshConfiguration;
    }

    public void setSshConfiguration(DataSourceSshTunnelConfiguration configuration) {
        this.mySshConfiguration = configuration;
    }

    public DataSourceSslConfiguration getSslCfg() {
        return this.mySslCfg;
    }

    public void setSslCfg(DataSourceSslConfiguration sslCfg) {
        this.mySslCfg = sslCfg;
    }

    public boolean isDomainAuthentication() {
        return this.myDomainAuthentication;
    }

    public void setDomainAuthentication(boolean domainAuthentication) {
        this.myDomainAuthentication = domainAuthentication;
    }

    public ThreeState getFirstSync() {
        return this.myFirstSync;
    }

    public void setFirstSync(ThreeState firstSync) {
        this.myFirstSync = firstSync;
    }

    @NotNull
    public LocalDataSource copy(Project project, boolean deep) {
        String uuidPrefix = "uuid=\"";
        DataSource.SaveMode mode = deep ? DataSource.SaveMode.ALL : DataSource.SaveMode.CONFIG;
        LocalDataSource clone = new LocalDataSource();
        try {
            StringWriter writer = new StringWriter();
            CompactWriter serializer = new CompactWriter((Writer)writer);
            this.serialize(project, (HierarchicalStreamWriter)serializer, mode);
            serializer.close();
            StringBuffer buffer = writer.getBuffer();
            int idx = buffer.indexOf(uuidPrefix);
            if (idx > -1) {
                buffer.replace(idx, buffer.indexOf("\"", idx + uuidPrefix.length()) + 1, "");
            }
            clone.deserialize(project, (HierarchicalStreamReader)new XppReader((Reader)new StringReader(buffer.toString())), mode);
            clone.setGlobal(this.isGlobal());
            clone.setDatabaseDriver(this.getDatabaseDriver());
            clone.setSchemaPattern(this.getSchemaPattern());
            clone.setDefaultSchemas(this.getDefaultSchemas());
            clone.setSecretStorage(this.getSecretStorage());
            clone.setUsername(this.getUsername());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "copy"));
        }
        return localDataSource;
    }

    @Override
    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return this;
    }

    @Override
    protected void setupDefaults(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/LocalDataSource", "setupDefaults"));
        }
        if (this.myFirstSync != ThreeState.YES) {
            return;
        }
        new DefaultsInstaller(this).loadSchemaNames(connection).setupDefaults(connection, this.getUsername()).saveSchemas();
        this.myFirstSync = ThreeState.NO;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        boolean hasSsl2;
        boolean hasSsh2;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/LocalDataSource", "equalConfiguration"));
        }
        if (this.isConfiguredByUrl() != o.isConfiguredByUrl()) {
            return false;
        }
        if (this.isImported() != o.isImported()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (this.isAuthRequired() != o.isAuthRequired()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getUrl()), (CharSequence)StringUtil.nullize((String)o.getUrl()))) {
            return false;
        }
        if (this.isAutoSynchronize() != o.isAutoSynchronize()) {
            return false;
        }
        if (this.isReadOnly() != o.isReadOnly()) {
            return false;
        }
        if (this.isAutoCommit() != o.isAutoCommit()) {
            return false;
        }
        if (this.isGlobal() != o.isGlobal()) {
            return false;
        }
        if (!Comparing.equal((Object)this.getDatabaseDriver(), (Object)o.getDatabaseDriver())) {
            return false;
        }
        if (this.isDomainAuthentication() != o.isDomainAuthentication()) {
            return false;
        }
        if (!this.getClasspathElements().equals(o.getClasspathElements())) {
            return false;
        }
        if (!this.getDriverProperties().equals(o.getDriverProperties())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDriverClass(), (CharSequence)o.getDriverClass())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getSchemaPattern(), (CharSequence)o.getSchemaPattern())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDefaultSchemas(), (CharSequence)o.getDefaultSchemas())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getTablePattern(), (CharSequence)o.getTablePattern())) {
            return false;
        }
        if (this.myUseLegacyIntrospector != o.useLegacyIntrospector()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myVmOptions), (CharSequence)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!LocalDataSource.equals(this.myVmEnv, o.myVmEnv)) {
            return false;
        }
        if (!LocalDataSource.equals(this.getAdditionalJdbcProperties(), o.getAdditionalJdbcProperties())) {
            return false;
        }
        if (!this.myExplainPlanConfiguration.equalConfiguration(o.myExplainPlanConfiguration)) {
            return false;
        }
        boolean hasSsh1 = this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty();
        boolean bl = hasSsh2 = o.mySshConfiguration != null && !o.mySshConfiguration.isEmpty();
        if (hasSsh1 != hasSsh2) {
            return false;
        }
        if (hasSsh1 && !this.mySshConfiguration.equalConfiguration(o.mySshConfiguration)) {
            return false;
        }
        boolean hasSsl1 = this.mySslCfg != null && !this.mySslCfg.isEmpty();
        boolean bl2 = hasSsl2 = o.mySslCfg != null && !o.mySslCfg.isEmpty();
        if (hasSsl1 != hasSsl2) {
            return false;
        }
        return !hasSsl1 || this.mySslCfg.equalConfiguration(o.mySslCfg);
    }

    private static <K, V> boolean equals(@NotNull Map<K, V> m1, @NotNull Map<K, V> m2) {
        if (m1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m1", "com/intellij/database/dataSource/LocalDataSource", "equals"));
        }
        if (m2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m2", "com/intellij/database/dataSource/LocalDataSource", "equals"));
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (Comparing.equal(entry.getValue(), m2.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            if (Comparing.equal(entry.getValue(), m1.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setAdditionalJdbcProperties(@NotNull Map<String, String> additionalJdbcProperties) {
        if (additionalJdbcProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalJdbcProperties", "com/intellij/database/dataSource/LocalDataSource", "setAdditionalJdbcProperties"));
        }
        this.myAdditionalJdbcProperties.clear();
        this.myAdditionalJdbcProperties.putAll(additionalJdbcProperties);
    }

    @NotNull
    public Map<String, String> getAdditionalJdbcProperties() {
        Map<String, String> map = this.myAdditionalJdbcProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getAdditionalJdbcProperties"));
        }
        return map;
    }

    public boolean isAuthRequired() {
        return this.myAuthRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.myAuthRequired = authRequired;
    }

    public boolean isImported() {
        return this.myImported;
    }

    private void correctExplainPlanProvider() {
        this.myExplainPlanConfiguration.setProviderClass(DataSourceExplainPlanConfiguration.resetToDefaultIfInvalid(this.myExplainPlanConfiguration.getProviderClass(), this));
    }

    private boolean isDefaultExplainPlanProvider(String className) {
        return DataSourceExplainPlanConfiguration.getDefaultProvider(this).equals(className);
    }

    public boolean isConfiguredByUrl() {
        return this.myConfiguredByUrl;
    }

    public void setConfiguredByUrl(boolean configuredByUrl) {
        this.myConfiguredByUrl = configuredByUrl;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmEnv", "com/intellij/database/dataSource/LocalDataSource", "setVmEnv"));
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @NotNull
    public String toString() {
        String str = super.toString();
        String dialect = this.getDefaultDialect();
        String string = str = str + (dialect != null && !dialect.isEmpty() ? " (" + dialect + ")" : " (unknown dialect)");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "toString"));
        }
        return string;
    }
}

