/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasArgument;
import org.jetbrains.annotations.NotNull;

public enum ProcedureParameterType {
    IN,
    OUT,
    INOUT,
    RETURN,
    RESULT;


    public boolean isReturnOrResult() {
        return this == RETURN || this == RESULT;
    }

    public int getID() {
        switch (this) {
            case IN: {
                return 1;
            }
            case OUT: {
                return 4;
            }
            case INOUT: {
                return 2;
            }
            case RETURN: {
                return 5;
            }
            case RESULT: {
                return 3;
            }
        }
        return 1;
    }

    public static ProcedureParameterType findByID(int id) {
        switch (id) {
            case 1: {
                return IN;
            }
            case 4: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
            case 5: {
                return RETURN;
            }
            case 3: {
                return RESULT;
            }
        }
        return IN;
    }

    @NotNull
    public DasArgument.Direction getArgumentDirection() {
        switch (this) {
            case IN: {
                DasArgument.Direction direction = DasArgument.Direction.IN;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
                }
                return direction;
            }
            case OUT: {
                DasArgument.Direction direction = DasArgument.Direction.OUT;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
                }
                return direction;
            }
            case INOUT: {
                DasArgument.Direction direction = DasArgument.Direction.INOUT;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
                }
                return direction;
            }
            case RETURN: {
                DasArgument.Direction direction = DasArgument.Direction.RETURN;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
                }
                return direction;
            }
            case RESULT: {
                DasArgument.Direction direction = DasArgument.Direction.RESULT;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
                }
                return direction;
            }
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ProcedureParameterType", "getArgumentDirection"));
        }
        return direction;
    }
}

