/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInterchange
implements UserDataHolder {
    private final DataSourceConfigurable myConfigurable;
    private final Map<String, String> myProperties;
    private final Set<String> myPersistentProperties;
    private final Map<Key, Object> myUserData;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final EventDispatcher<UserDataListener> myDispatcher;
    private final EventDispatcher<NestedChangeListener> myNestedDispatcher;
    private int myDepth;

    public void addGroupedChangeListener(@NotNull NestedChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/DataInterchange", "addGroupedChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/DataInterchange", "addGroupedChangeListener"));
        }
        this.myNestedDispatcher.addListener((EventListener)listener, parent);
    }

    public DataInterchange(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/database/dataSource/url/DataInterchange", "<init>"));
        }
        this.myProperties = ContainerUtil.newHashMap();
        this.myPersistentProperties = ContainerUtil.newHashSet();
        this.myUserData = ContainerUtil.newHashMap();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDispatcher = EventDispatcher.create(UserDataListener.class);
        this.myNestedDispatcher = EventDispatcher.create(NestedChangeListener.class);
        this.myDepth = 0;
        this.myConfigurable = configurable;
    }

    public Project getProject() {
        return this.myConfigurable.getProject();
    }

    public void showError(@Nullable Exception e, @NotNull Object id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/url/DataInterchange", "showError"));
        }
        this.myConfigurable.showErrorNotification(e, id);
    }

    @NotNull
    public Set<String> getPersistentProperties() {
        Set<String> set = this.myPersistentProperties;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/DataInterchange", "getPersistentProperties"));
        }
        return set;
    }

    public void addPersistentProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "addPersistentProperty"));
        }
        this.myPersistentProperties.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(@NotNull String key, @Nullable String val) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "putProperty"));
        }
        this.startNested();
        try {
            String prev = this.myProperties.put(key, val);
            this.myPropertyChangeSupport.firePropertyChange(key, prev, val);
        }
        finally {
            this.endNested();
        }
    }

    @Nullable
    public String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "getProperty"));
        }
        return this.myProperties.get(key);
    }

    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/DataInterchange", "addPropertyChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/DataInterchange", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(listener);
            }
        });
    }

    public void addPropertyChangeListener(final @NotNull String key, final @NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "addPropertyChangeListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/DataInterchange", "addPropertyChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/DataInterchange", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(key, listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DataInterchange.this.myPropertyChangeSupport.removePropertyChangeListener(key, listener);
            }
        });
    }

    public void forceUpdateProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "forceUpdateProperty"));
        }
        this.startNested();
        try {
            String prev = this.myProperties.get(key);
            this.myPropertyChangeSupport.firePropertyChange(key, prev == null ? "" : null, prev);
        }
        finally {
            this.endNested();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "getUserData"));
        }
        return (T)key.get(this.myUserData);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dataSource/url/DataInterchange", "putUserData"));
        }
        if (Comparing.equal(this.getUserData(key), value)) {
            return;
        }
        key.set(this.myUserData, value);
        this.fireUserDataChanged(key);
    }

    public void fireUserDataChanged(@NotNull Key changed) {
        if (changed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/DataInterchange", "fireUserDataChanged"));
        }
        ((UserDataListener)this.myDispatcher.getMulticaster()).userDataChanged(changed);
    }

    public void addUserDataListener(@NotNull UserDataListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/DataInterchange", "addUserDataListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/url/DataInterchange", "addUserDataListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void startNested() {
        ++this.myDepth;
    }

    public void endNested() {
        ((NestedChangeListener)this.myNestedDispatcher.getMulticaster()).nestedChange(--this.myDepth);
    }

    @NotNull
    public LocalDataSource buildDataSource() {
        LocalDataSource result = new LocalDataSource();
        this.myConfigurable.saveData(result, true);
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/DataInterchange", "buildDataSource"));
        }
        return localDataSource;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myConfigurable.getTempDataSource().getDatabaseDriver();
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myConfigurable.getActiveParser();
    }

    public static interface NestedChangeListener
    extends EventListener {
        public void nestedChange(int var1);
    }

    public static interface UserDataListener
    extends EventListener {
        public void userDataChanged(@NotNull Key var1);
    }
}

