/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUrlParserUtil {
    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @NotNull StatelessJdbcUrlParser.LocationType loc) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        if (loc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loc", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "select"));
        }
        for (StatelessJdbcUrlParser p : parsers) {
            if (!p.getPossibleLocations().contains((Object)loc) || !p.isUrlValueValid(url)) continue;
            return p;
        }
        return null;
    }

    @Nullable
    public static JdbcUrlParser statefull(@Nullable StatelessJdbcUrlParser parser) {
        return parser == null ? null : parser.createStatefull();
    }

    @Nullable
    public static Pair.NonNull<String, String> extractHostPort(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "extractHostPort"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/JdbcUrlParserUtil", "extractHostPort"));
        }
        JdbcUrlParser parser = JdbcUrlParserUtil.statefull(JdbcUrlParserUtil.select(parsers, url, StatelessJdbcUrlParser.LocationType.REMOTE));
        if (parser != null) {
            parser.setUrlText(url);
        }
        if (parser == null || !parser.isValid()) {
            return null;
        }
        String host = parser.getParameter("host");
        String port = parser.getParameter("port");
        if (StringUtil.isEmpty((String)port)) {
            port = parser.getParameterDefValue("port");
        }
        if (p != null) {
            p.set((Object)parser);
        }
        return StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port) ? null : Pair.createNonNull((Object)host, (Object)port);
    }
}

