/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.JdbcTemplateParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StatelessTextDecompositionBuilder
implements JdbcTemplateParser.EventProcessor {
    private final Builder myBuilder;
    private String myError;
    private final TextDecomposition.PatternFactory myPatternFactory;
    private final List<String> myPropSeparators;

    public static StatelessTextDecomposition.Node build(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns) throws StatelessTextDecomposition.InvalidTemplateException {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "build"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "build"));
        }
        try {
            StatelessTextDecompositionBuilder builder = new StatelessTextDecompositionBuilder(template, patterns);
            StatelessTextDecomposition.Node node = builder.getNode();
            StatelessTextDecomposition.FollowBuilder.buildFollow(node);
            return node;
        }
        catch (TemplateBuildingException e) {
            throw new StatelessTextDecomposition.InvalidTemplateException(e.getMessage());
        }
        catch (PatternSyntaxException e) {
            throw new StatelessTextDecomposition.InvalidTemplateException(e.getMessage());
        }
    }

    private StatelessTextDecompositionBuilder(@NotNull String template, @NotNull TextDecomposition.PatternFactory patterns) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "<init>"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "<init>"));
        }
        this.myBuilder = new Builder();
        this.myPropSeparators = ContainerUtil.newArrayList();
        this.myPatternFactory = patterns;
        this.myBuilder.enter();
        if (!JdbcTemplateParser.parse(template, this)) {
            throw new TemplateBuildingException(this.myError);
        }
        this.myBuilder.leave();
    }

    @Override
    public void processString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "processString"));
        }
        this.myBuilder.push(new StatelessTextDecomposition.TextNode(s));
    }

    @Override
    public void processGroupStart() {
        this.myBuilder.enter();
    }

    @Override
    public void processGroupFinish() {
        this.myBuilder.leave();
    }

    @Override
    public void processOptionality() {
        this.myBuilder.optionalize();
    }

    @Override
    public void processNegation() {
        this.myBuilder.negate();
    }

    @Override
    public void processParameter(@Nullable String name, @Nullable String type, @Nullable String defValue, @Nullable String configuration) {
        assert (type != null || name != null);
        this.pushParameter(name, (String)ObjectUtils.chooseNotNull((Object)type, (Object)name), defValue, configuration);
    }

    @Override
    public void processError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "processError"));
        }
        this.myError = error;
    }

    @Override
    public void processListBranch() {
        this.myBuilder.leave();
        this.myBuilder.enter();
    }

    @Override
    public void processListStart(@NotNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "processListStart"));
        }
        this.myPropSeparators.add(separator);
        this.myBuilder.enter();
        this.myBuilder.enter();
    }

    @Override
    public void processListFinish() {
        this.myBuilder.leave();
        this.myBuilder.leaveList(this.myPropSeparators.remove(this.myPropSeparators.size() - 1));
    }

    @NotNull
    private Pattern getPatternOrThrow(@NotNull String type, @Nullable String configuration) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "getPatternOrThrow"));
        }
        Pattern checkPattern = this.myPatternFactory.getPattern(type, configuration);
        if (checkPattern == null) {
            throw new TemplateBuildingException("Invalid type name: " + type);
        }
        Pattern pattern = checkPattern;
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "getPatternOrThrow"));
        }
        return pattern;
    }

    private void pushParameter(@Nullable String name, @NotNull String type, @Nullable String defValue, @Nullable String configuration) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "pushParameter"));
        }
        StatelessTextDecomposition.ParameterNode node = new StatelessTextDecomposition.ParameterNode(name, type, defValue, configuration, this.getPatternOrThrow(type, configuration));
        this.myBuilder.push(node);
    }

    @NotNull
    private StatelessTextDecomposition.Node getNode() {
        StatelessTextDecomposition.Node node = this.myBuilder.getResult();
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder", "getNode"));
        }
        return node;
    }

    public static class TemplateBuildingException
    extends RuntimeException {
        public TemplateBuildingException(@NotNull String msg) {
            if (msg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$TemplateBuildingException", "<init>"));
            }
            super(msg);
        }
    }

    private static class Builder {
        private final List<StatelessTextDecomposition.Node> myCurrentNodes = new ArrayList<StatelessTextDecomposition.Node>();
        private final TIntStack myStack = new TIntStack(3);

        private Builder() {
        }

        void push(@NotNull StatelessTextDecomposition.Node node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder", "push"));
            }
            this.myCurrentNodes.add(node);
        }

        void enter() {
            this.myStack.push(this.myCurrentNodes.size());
        }

        private StatelessTextDecomposition.Node[] extractArray(int mark) {
            StatelessTextDecomposition.Node[] res = new StatelessTextDecomposition.Node[this.myCurrentNodes.size() - mark];
            for (int i = this.myCurrentNodes.size() - 1; i >= mark; --i) {
                res[i - mark] = this.myCurrentNodes.get(i);
                this.myCurrentNodes.remove(i);
            }
            return res;
        }

        void leave() {
            int mark = this.myStack.pop();
            assert (mark <= this.myCurrentNodes.size());
            if (this.myCurrentNodes.size() - mark > 1) {
                StatelessTextDecomposition.CompositeNode n = new StatelessTextDecomposition.CompositeNode(this.extractArray(mark));
                this.myCurrentNodes.add(n);
            }
        }

        void leaveList(@NotNull String sep) {
            if (sep == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sep", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder", "leaveList"));
            }
            int mark = this.myStack.pop();
            assert (mark <= this.myCurrentNodes.size());
            StatelessTextDecomposition.Node[] nodes = this.extractArray(mark);
            StatelessTextDecomposition.ListChoiceNode[] choices = new StatelessTextDecomposition.ListChoiceNode[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                choices[i] = new StatelessTextDecomposition.ListChoiceNode(nodes[i]);
            }
            StatelessTextDecomposition.ListNode n = new StatelessTextDecomposition.ListNode(new StatelessTextDecomposition.ListChoicesNode(choices), sep);
            this.myCurrentNodes.add(n);
        }

        void optionalize() {
            int size = this.myCurrentNodes.size();
            if (size > 0 && !(this.myCurrentNodes.get(size - 1) instanceof StatelessTextDecomposition.OptionalNode)) {
                StatelessTextDecomposition.Node node = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.OptionalNode(node));
            }
        }

        void negate() {
            int size = this.myCurrentNodes.size();
            if (size > 0) {
                StatelessTextDecomposition.Node node = this.myCurrentNodes.get(size - 1);
                this.myCurrentNodes.set(size - 1, new StatelessTextDecomposition.AntiNode(node));
            }
        }

        void finish() {
            assert (this.myCurrentNodes.size() <= 1);
            if (this.myCurrentNodes.isEmpty()) {
                this.myCurrentNodes.add(new StatelessTextDecomposition.TextNode(""));
            }
        }

        @NotNull
        StatelessTextDecomposition.Node getResult() {
            this.finish();
            StatelessTextDecomposition.Node node = this.myCurrentNodes.get(0);
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/StatelessTextDecompositionBuilder$Builder", "getResult"));
            }
            return node;
        }
    }
}

