/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDecompositionUtil {
    @NotNull
    static List<TextRange> extractBadRanges(@NotNull TextDecompositionNodes.SNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "extractBadRanges"));
        }
        List<TextRange> list = new TextDecompositionNodes.NodeVisitor<Void>(){
            private final List<TextRange> myRanges = ContainerUtil.newArrayList();
            private final Set<TextDecompositionNodes.BadGroup> myVisited = ContainerUtil.newHashSet();

            public List<TextRange> getResult(@NotNull TextDecompositionNodes.SNode root) {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$1", "getResult"));
                }
                this.visit(root);
                return this.myRanges;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$1", "visit"));
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.StartEndBadable.class);
                this.processBadGroup(bad == null ? null : bad.getBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getStartBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getEndBadGroup());
                node.visitChildren(this);
                return null;
            }

            private void processBadGroup(TextDecompositionNodes.BadGroup badGroup) {
                if (badGroup != null && !this.myVisited.contains(badGroup)) {
                    assert (badGroup.getFrom() != -1);
                    this.myRanges.add(TextRange.create((int)badGroup.getFrom(), (int)badGroup.getTo()));
                    this.myVisited.add(badGroup);
                }
            }
        }.getResult(root);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "extractBadRanges"));
        }
        return list;
    }

    static void buildText(final @NotNull StringBuilder builder, @NotNull TextDecompositionNodes.SNode root) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "buildText"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "buildText"));
        }
        new SimpleNodeVisitor<Void>(){
            private boolean myDisabled = false;
            private Set<TextDecompositionNodes.BadGroup> myVisited = ContainerUtil.newHashSet();

            private boolean processBadGroup(@Nullable TextDecompositionNodes.BadGroup b) {
                if (b != null && !this.myVisited.contains(b)) {
                    int start = builder.length();
                    builder.append(b.getBadText());
                    int end = builder.length();
                    b.setRange(start, end);
                    this.myVisited.add(b);
                }
                return b != null;
            }

            private void processBadTextPre(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "processBadTextPre"));
                }
                this.processBadGroup(node instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node)).getStartBadGroup() : null);
            }

            private boolean processBadTextInstead(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "processBadTextInstead"));
                }
                return this.processBadGroup(node instanceof TextDecompositionNodes.Badable ? ((TextDecompositionNodes.Badable)((Object)node)).getBadGroup() : null);
            }

            private void processBadTextPost(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "processBadTextPost"));
                }
                this.processBadGroup(node instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node)).getEndBadGroup() : null);
            }

            private void updateNodeRange(@NotNull TextDecompositionNodes.SNode node, int start, int end) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "updateNodeRange"));
                }
                if (start == end) {
                    node.setMatchRange(-1, -1);
                } else {
                    node.setMatchRange(start, end);
                }
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                int start = builder.length();
                this.processBadTextPre(node);
                boolean bad = this.processBadTextInstead(node);
                if (bad || this.myDisabled) {
                    node.visitChildren(this);
                } else {
                    super.visit(node);
                }
                this.processBadTextPost(node);
                int end = builder.length();
                this.updateNodeRange(node, start, end);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                builder.append(node.getText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                builder.append(node.getMatchedText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                assert (!this.myDisabled);
                this.myDisabled = !node.isEnabled();
                node.visitChildren(this);
                this.myDisabled = false;
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2", "visit"));
                }
                boolean first = true;
                for (TextDecompositionNodes.ListChoiceSNode m : node.getMatches()) {
                    if (!m.isEnabled()) continue;
                    if (!first) {
                        builder.append(node.getStateless().getSeparator());
                    } else {
                        first = false;
                    }
                    this.visit((TextDecompositionNodes.SNode)m);
                }
                return null;
            }
        }.visit(root);
    }

    public static void purgeBadGroups(@NotNull TextDecompositionNodes.SNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "purgeBadGroups"));
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$3", "visit"));
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.StartEndBadable.class);
                if (bad != null) {
                    bad.setBadGroup(null);
                    TextDecompositionNodes.TextSNode text = (TextDecompositionNodes.TextSNode)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.TextSNode.class);
                    if (text != null) {
                        text.setMatchedText(text.getStateless().getText());
                    }
                }
                if (sebad != null) {
                    sebad.setStartBadGroup(null);
                    sebad.setEndBadGroup(null);
                }
                node.visitChildren(this);
                return null;
            }
        }.visit(root);
    }

    public static void assignGroups(@NotNull TextDecompositionNodes.SNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "assignGroups"));
        }
        new SimpleNodeVisitor<Void>(){
            private int groupNumber = 0;

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                ++this.groupNumber;
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                assert (false);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                return null;
            }
        }.visit(root);
    }

    public static void resetDisabledMatchables(@NotNull TextDecompositionNodes.SNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "resetDisabledMatchables"));
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private boolean myInsideDisabled = false;

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$5", "visit"));
                }
                boolean prev = this.myInsideDisabled;
                if (node instanceof TextDecompositionNodes.OptionalSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.OptionalSNode)node).isEnabled();
                } else if (node instanceof TextDecompositionNodes.ListChoiceSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.ListChoiceSNode)node).isEnabled();
                }
                node.visitChildren(this);
                if (this.myInsideDisabled) {
                    node.setMatch(null);
                }
                this.myInsideDisabled = prev;
                return null;
            }
        }.visit(node);
    }

    public static void nullizeMatch(@NotNull TextDecompositionNodes.SNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "nullizeMatch"));
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$6", "visit"));
                }
                node.setMatch(null);
                node.visitChildren(this);
                return null;
            }
        }.visit(node);
    }

    @NotNull
    public static TextDecompositionNodes.Matchable[] collectMatchables(@NotNull TextDecompositionNodes.SNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "collectMatchables"));
        }
        final ArrayList res = new ArrayList();
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$7", "visit"));
                }
                if (!(node instanceof TextDecompositionNodes.ListSNode)) {
                    node.visitChildren(this);
                }
                res.add(node);
                return null;
            }
        }.visit(root);
        TextDecompositionNodes.Matchable[] ares = res.toArray(new TextDecompositionNodes.Matchable[res.size()]);
        Arrays.sort(ares, new Comparator<TextDecompositionNodes.Matchable>(){

            @Override
            public int compare(@NotNull TextDecompositionNodes.Matchable o1, @NotNull TextDecompositionNodes.Matchable o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$8", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$8", "compare"));
                }
                return Comparing.compare((int)o1.getGroupNumber(), (int)o2.getGroupNumber());
            }
        });
        if (ares == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/TextDecompositionUtil", "collectMatchables"));
        }
        return ares;
    }

    static abstract class SimpleNodeVisitor<R>
    implements TextDecompositionNodes.NodeVisitor<R> {
        SimpleNodeVisitor() {
        }

        @Override
        public R visit(@NotNull TextDecompositionNodes.SNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$SimpleNodeVisitor", "visit"));
            }
            if (node.getClass() == TextDecompositionNodes.ParameterSNode.class) {
                return this.visit((TextDecompositionNodes.ParameterSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.TextSNode.class) {
                return this.visit((TextDecompositionNodes.TextSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.CompositeSNode.class) {
                return this.visit((TextDecompositionNodes.CompositeSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.OptionalSNode.class) {
                return this.visit((TextDecompositionNodes.OptionalSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.AntiSNode.class) {
                return this.visit((TextDecompositionNodes.AntiSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.ListSNode.class) {
                return this.visit((TextDecompositionNodes.ListSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.ListChoiceSNode.class) {
                return this.visit((TextDecompositionNodes.ListChoiceSNode)node);
            }
            assert (false);
            return null;
        }

        public abstract R visit(@NotNull TextDecompositionNodes.AntiSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ParameterSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.TextSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.CompositeSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.OptionalSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListChoiceSNode var1);
    }
}

