/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseParamEditor
extends CompletionParamEditor<DatabaseInfo> {
    public DatabaseParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "<init>"));
        }
        super(label, interchange);
        this.setUpdateTitle("Refreshing Databases List");
        this.setForceRefresh("Refresh Databases List");
        this.setSupersedeTasks(true);
        this.setValidateOnDirtyCompletion(true);
        this.setAsyncUpdateOnCompletion(true);
        interchange.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("host".equals(evt.getPropertyName()) || "port".equals(evt.getPropertyName())) {
                    DatabaseParamEditor.this.resetVariants();
                }
            }
        }, this);
    }

    @Override
    @NotNull
    protected String getText(@NotNull DatabaseInfo item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "getText"));
        }
        String string = item.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected List<DatabaseInfo> getVariants(@NotNull ProgressIndicator indicator, @NotNull Map<Key, ?> options) throws Exception {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "getVariants"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor", "getVariants"));
        }
        LocalDataSource dataSource = this.getInterchange().buildDataSource();
        SqlLanguageDialect language = DatabaseDriverImpl.getLanguage(dataSource.getDatabaseDriver());
        JdbcUrlParser parser = JdbcUrlParserUtil.statefull(this.getInterchange().getActiveParser());
        if (parser == null || language == null || StringUtil.isEmpty((String)dataSource.getUrl())) {
            return null;
        }
        parser.setUrlText(dataSource.getUrl());
        parser.setParameter("database", "");
        dataSource.setUrl(parser.getUrlText());
        indicator.checkCanceled();
        List<String> names = DatabaseEditorHelper.loadDatabaseList(ConnectionProvider.forDataSource(this.getInterchange().getProject(), dataSource), (DatabaseDialectEx)language.getDatabaseDialect());
        indicator.checkCanceled();
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)names.size());
        for (String name : names) {
            res.add(new DatabaseInfo(name));
        }
        return res;
    }

    public static class DatabaseInfo {
        public String name;

        public DatabaseInfo(String name) {
            this.name = name;
        }
    }
}

