/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfoCache;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpHostParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpServer> {
    public static final Key<SsrpInfo> SSRP_INFO = Key.create((String)"SSRP_INFO");
    public static final String SQLSERVER_DISCOVERY = "SQLSERVER_DISCOVERY";
    public static final Condition<SsrpInfo.SsrpServer> NO_ERROR = new Condition<SsrpInfo.SsrpServer>(){

        public boolean value(SsrpInfo.SsrpServer server) {
            return server.getError() == null;
        }
    };
    public final Ref<String> myHost;

    public SsrpHostParamEditor(@NotNull String label, final @NotNull DataInterchange interchange) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "<init>"));
        }
        super(label, interchange);
        this.myHost = SsrpInfoCache.addHost();
        this.setUpdateTitle("Discovering reachable servers");
        this.setForceRefresh("Rediscover instances");
        this.setReportErrorOnAutoPopup(true);
        this.addUpdateOnShow();
        interchange.addUserDataListener(new DataInterchange.UserDataListener(){

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor$2", "userDataChanged"));
                }
                if (changed != SSRP_INFO) {
                    return;
                }
                SsrpInfo info = (SsrpInfo)SSRP_INFO.get((UserDataHolder)interchange);
                SsrpHostParamEditor.this.setVariantsAndCompletionVariants(info == null ? Collections.emptyList() : ContainerUtil.newArrayList(info.getServers()));
            }
        }, this);
        SSRP_INFO.set((UserDataHolder)interchange, (Object)SsrpInfoCache.get());
        SsrpInfoCache.addListener(new SsrpInfoCache.Listener(){

            public void consume(final SsrpConstants.SsrpException e) {
                if (e == null) {
                    final SsrpInfo info = SsrpInfoCache.get();
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SSRP_INFO.set((UserDataHolder)interchange, (Object)info);
                        }
                    });
                } else {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            interchange.showError(e, SsrpHostParamEditor.SQLSERVER_DISCOVERY);
                        }
                    });
                }
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(new EditorSettingsProvider(){

            public void customizeSettings(EditorEx editor) {
                SsrpHostParamEditor.this.updateHighlighting((Editor)editor);
                editor.addFocusListener(new FocusChangeListener(){

                    public void focusGained(Editor editor) {
                    }

                    public void focusLost(Editor editor) {
                        SsrpHostParamEditor.this.updateServerIfNotPresented();
                    }
                });
            }
        });
    }

    protected void updateHighlighting(@Nullable Editor editor) {
        String error;
        if (editor == null) {
            return;
        }
        editor.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer item = this.getItemByText(this.getText());
        String string = error = item == null ? null : item.getError();
        if (!"UnknownHost".equals(error)) {
            editor.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key = CodeInsightColors.ERRORS_ATTRIBUTES;
        editor.getContentComponent().setToolTipText("Error: Unknown host");
        TextAttributes attributes = editor.getColorsScheme().getAttributes(key);
        editor.getMarkupModel().addRangeHighlighter(0, editor.getDocument().getTextLength(), 4000, attributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    protected void updateModelAtShow() {
        if (!SSRP_INFO.isIn((UserDataHolder)this.getInterchange())) {
            this.updateModelAsync(true);
        }
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpServer item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getText"));
        }
        String string = item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    public SsrpInfo.SsrpServer getItemByText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getItemByText"));
        }
        SsrpInfo info = SsrpInfoCache.get();
        return info == null ? null : info.getServer(text);
    }

    @Override
    protected void fireChanged() {
        this.myHost.set((Object)this.getText());
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
        super.fireChanged();
    }

    @Override
    @Nullable
    protected List<SsrpInfo.SsrpServer> getVariants(@NotNull ProgressIndicator indicator, @NotNull Map<Key, ?> options) throws Exception {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getVariants"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "getVariants"));
        }
        SsrpInfoCache.update(false);
        SsrpInfo info = SsrpInfoCache.get();
        return info == null ? Collections.emptyList() : ContainerUtil.newArrayList(info.getServers());
    }

    protected void updateServerIfNotPresented() {
        SsrpInfo.SsrpServer server = this.getItemByText(this.getText());
        if (server == null) {
            SsrpInfoCache.updateHost(true, this.getText());
        }
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "setVariants"));
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    @Override
    protected void setCompletionVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dataSource/url/ui/SsrpHostParamEditor", "setCompletionVariants"));
        }
        super.setCompletionVariants(JBIterable.from(variants).filter(NO_ERROR).toList());
    }
}

