/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class LocalDataSourceValidator
extends DatabaseConfigValidator.Typed<LocalDataSource> {
    public LocalDataSourceValidator() {
        super(LocalDataSource.class);
    }

    @Override
    public void findProblemsTyped(@NotNull LocalDataSource dataSource, @NotNull Consumer<DataSourceProblem> problems) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "findProblemsTyped"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/LocalDataSourceValidator", "findProblemsTyped"));
        }
        if (dataSource.getClasspathElements().isEmpty()) {
            DatabaseDriverValidator.findDriverFilesProblems(this.actualize(dataSource.getDatabaseDriver()), dataSource.isDomainAuthentication(), problems);
        }
    }
}

