/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridUtil {
    public static final Logger LOG = Logger.getInstance(DataGridUtil.class);
    public static final int CSV_VALUE_SQL_TYPE = 239;
    public static final String FAILED_TO_LOAD_PREFIX = "<failed to load>";

    private DataGridUtil() {
    }

    @Nullable
    public static DataGrid getDataGrid(DataContext dataContext) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof TableEditorBase) {
            return ((TableEditorBase)editor).getDataGrid();
        }
        return (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataGridUtil", "createDataGrid"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/datagrid/DataGridUtil", "createDataGrid"));
        }
        if (popupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActions", "com/intellij/database/datagrid/DataGridUtil", "createDataGrid"));
        }
        TableResultPanel tableResultPanel = new TableResultPanel(project, dataHookUp, popupActions);
        if (tableResultPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "createDataGrid"));
        }
        return tableResultPanel;
    }

    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataGridUtil", "createPreviewDataGrid"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/datagrid/DataGridUtil", "createPreviewDataGrid"));
        }
        ActionGroup popup = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewPopupGroup");
        return new TableResultPanel(project, dataHookUp, popup, popup, ActionGroup.EMPTY_GROUP, null, false);
    }

    @NotNull
    public static ModelIndex<DataConsumer.Column> findColumn(@NotNull DataGrid dataGrid, @Nullable String name) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridUtil", "findColumn"));
        }
        GridModel gridModel = dataGrid.getDataModel();
        for (ModelIndex c : gridModel.getColumnIndices().asIterable()) {
            DataConsumer.Column column = (DataConsumer.Column)gridModel.getColumn(c);
            if (column == null || !Comparing.strEqual((String)name, (String)column.name)) continue;
            ModelIndex modelIndex = c;
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "findColumn"));
            }
            return modelIndex;
        }
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(dataGrid, -1);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "findColumn"));
        }
        return modelIndex;
    }

    @NotNull
    public static String getSqlType(@NotNull DataGrid grid, @Nullable DataConsumer.Column column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "getSqlType"));
        }
        if (column == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getSqlType"));
            }
            return "";
        }
        String typeNameSafe = StringUtil.notNullize((String)column.typeName);
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (hookUp == null) {
            String string = typeNameSafe;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getSqlType"));
            }
            return string;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
        if (dasColumn != null) {
            String string = dasColumn.getDataType().getSpecification();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getSqlType"));
            }
            return string;
        }
        DataType type = DataTypeFactory.of(column.schema, typeNameSafe, column.precision, column.scale, null, null, false, false, column.type);
        String string = hookUp.getDatabaseDialect().getTypeName(type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getSqlType"));
        }
        return string;
    }

    public static void focusDataGrid(DataContext dataContext) {
        DataGridUtil.focusDataGrid(DataGridUtil.getDataGrid(dataContext));
    }

    public static void focusDataGrid(DataGrid grid) {
        if (grid != null) {
            JComponent toFocus = grid.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, true);
        }
    }

    public static void setupProgressIndicatingAuditor(final @NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "setupProgressIndicatingAuditor"));
        }
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(grid.getDataHookup(), DataRequest.OwnerEx.class);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().addAuditor(new DataAuditor.Adapter(){

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataGridUtil$1", "print"));
                }
                if (message != null && message.contains("retrieved starting")) {
                    return;
                }
                ((StatusBarInfo)DataGridUtil.getProject(grid).getMessageBus().syncPublisher(StatusBar.Info.TOPIC)).setInfo(message);
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataGridUtil$1", "jobSubmitted"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataGridUtil$1", "jobSubmitted"));
                }
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataGridUtil$1", "requestStarted"));
                }
                DataGridUtil.setProgressMessage(grid, context.request instanceof DataRequest.QueryRequest ? "Querying..." : "Processing...");
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataGridUtil$1", "jobFinished"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataGridUtil$1", "jobFinished"));
                }
                DataGridUtil.setProgressMessage(grid, null);
            }
        });
    }

    public static void setProgressMessage(final @NotNull DataGrid grid, final @Nullable String message) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "setProgressMessage"));
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JBLoadingPanel loadingPanel = grid.getLoadingPanel();
                if (message != null) {
                    loadingPanel.startLoading();
                } else {
                    loadingPanel.stopLoading();
                }
                loadingPanel.setLoadingText(message);
            }
        });
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseTable() : null;
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@Nullable DataGrid grid, @Nullable DataConsumer.Column column) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column) : null;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseDialectEx databaseDialectEx = hookup != null ? hookup.getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @Contract(value="null->null;!null->_")
    public static DatabaseSystem getDatabaseSystem(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDataSource() : null;
    }

    public static int getResultSetIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getResultSetIndex() : 1;
    }

    @Contract(value="null->null;!null->_")
    public static String getQueryText(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookUp = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookUp != null ? dataBusHookUp.getQueryText() : null;
    }

    public static DataBusGridDataHookUp getDataBusHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataBusGridDataHookUp.class);
    }

    public static DatabaseGridDataHookUp getDatabaseHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DatabaseGridDataHookUp.class);
    }

    @Contract(value="null,_->null;!null,_->_")
    public static <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T getHookUp(@Nullable DataGrid grid, Class<T> clazz) {
        GridDataHookUp hookup = grid != null ? grid.getDataHookup() : null;
        return (T)((GridDataHookUp)ObjectUtils.tryCast(hookup, clazz));
    }

    public static void addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridUtil", "addGridHeaderComponent"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        boolean isConsoleResult = !(virtualFile instanceof DatabaseElementVirtualFileImpl);
        ActionGroup actions = (ActionGroup)actionManager.getAction(isConsoleResult ? "Console.TableResult.Group" : "Console.EditorTableResult.Group");
        ActionGroup secondaryActions = (ActionGroup)actionManager.getAction("Console.TableResult.Group.Secondary");
        ActionToolbar toolbar = actionManager.createActionToolbar("EditorToolbar", actions, true);
        ActionToolbar toolbarSecondary = actionManager.createActionToolbar("EditorToolbar", secondaryActions, true);
        toolbar.setTargetComponent(dataGrid.getComponent());
        toolbarSecondary.setTargetComponent(dataGrid.getComponent());
        toolbarSecondary.setReservePlaceAutoPopupIcon(false);
        EditorHeaderComponent header = new EditorHeaderComponent();
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        header.add((Component)toolbarComponent, "Center");
        JComponent toolbarSecondaryComponent = toolbarSecondary.getComponent();
        toolbarSecondaryComponent.setOpaque(false);
        header.add((Component)toolbarSecondaryComponent, "East");
        if (virtualFile != null) {
            DatabaseEditorHelper.updateToolbarColor(DataGridUtil.getProject(dataGrid), virtualFile, (JComponent)header);
        }
        if (dataGrid.isFilteringSupported()) {
            header.add((Component)dataGrid.getFilterPanel(), "South");
        }
        dataGrid.setTopComponent((Component)header);
    }

    public static ActionGroup getGridPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup");
    }

    public static ActionGroup getGridColumnHeaderPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ColumnHeaderPopup");
    }

    public static DataConsumer createEDTSafeWrapper(final @NotNull DataConsumer handler, @NotNull Disposable disposableParent) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/datagrid/DataGridUtil", "createEDTSafeWrapper"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/database/datagrid/DataGridUtil", "createEDTSafeWrapper"));
        }
        final AtomicReference<Boolean> disposed = new AtomicReference<Boolean>(false);
        Disposer.register((Disposable)disposableParent, (Disposable)new Disposable(){

            public void dispose() {
                disposed.set(true);
            }
        });
        return new DataConsumer(){
            private DataConsumer.Column[] columnInfos;

            @Override
            public void setColumns(final @NotNull DataRequest.Context context, final int resultSetIndex, final DataConsumer.Column[] infos, final int firstRowNum) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataGridUtil$4", "setColumns"));
                }
                this.columnInfos = infos;
                DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (((Boolean)disposed.get()).booleanValue()) {
                            return;
                        }
                        handler.setColumns(context, resultSetIndex, infos, firstRowNum);
                    }
                });
            }

            @Override
            public void addRows(final @NotNull DataRequest.Context context, final List<DataConsumer.Row> rows) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataGridUtil$4", "addRows"));
                }
                for (DataConsumer.Row row : rows) {
                    if (this.columnInfos == null || row == null || row.values.length != this.columnInfos.length) continue;
                    for (int i = 0; i < row.values.length; ++i) {
                        row.values[i] = ObjectFormatter.objectToObject(row.values[i], this.columnInfos[i]);
                    }
                }
                DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (((Boolean)disposed.get()).booleanValue()) {
                            return;
                        }
                        handler.addRows(context, rows);
                    }
                });
            }

            @Override
            public void afterLastRowAdded(final @NotNull DataRequest.Context context, final int total) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataGridUtil$4", "afterLastRowAdded"));
                }
                DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (((Boolean)disposed.get()).booleanValue()) {
                            return;
                        }
                        handler.afterLastRowAdded(context, total);
                    }
                });
            }
        };
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "getDefaultNullValue"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/datagrid/DataGridUtil", "getDefaultNullValue"));
        }
        DataConsumer.Column column = grid.getDataModel().getColumn(columnIdx);
        if (DbImplUtil.isComputedColumn(column)) {
            return ReservedCellValue.GENERATED;
        }
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DasColumn dasColumn = hookup != null ? hookup.getDatabaseColumn(column) : null;
        EnumSet<ReservedCellValue> opts = DbImplUtil.getSpecialValues(dasColumn);
        return opts.contains((Object)ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains((Object)ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains((Object)ReservedCellValue.NULL) ? ReservedCellValue.NULL : null));
    }

    public static Project getProject(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "getProject"));
        }
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)grid.getComponent()));
    }

    public static boolean isFailedToLoad(Object value) {
        return value instanceof String && StringUtil.startsWith((CharSequence)((String)value), (CharSequence)FAILED_TO_LOAD_PREFIX);
    }

    public static boolean showIgnoreUnsubmittedChangesYesNoDialog(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "showIgnoreUnsubmittedChangesYesNoDialog"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String title = "Ignore Unsubmitted Changes";
        String message = "The inserted row is not submitted. It's data will be lost. Continue?";
        return 0 == Messages.showYesNoDialog((Component)grid.getComponent(), (String)message, (String)title, (Icon)AllIcons.General.NotificationWarning);
    }

    public static void showCannotApplyCellEditorChanges(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/DataGridUtil", "showCannotApplyCellEditorChanges"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String title = "Cannot Apply Changes";
        String message = "This table is read-only. Cell editor changes cannot be applied.";
        Messages.showInfoMessage((Component)grid.getComponent(), (String)message, (String)title);
    }

    @NotNull
    public static CharOut extractSelectedValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridUtil", "extractSelectedValues"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/datagrid/DataGridUtil", "extractSelectedValues"));
        }
        CharOut charOut = DataGridUtil.extractValues(dataGrid, extractor, CharOut.Util.newSink(), true);
        if (charOut == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "extractSelectedValues"));
        }
        return charOut;
    }

    @NotNull
    public static CharOut extractSelectedValues(DataGrid dataGrid, DataExtractor extractor, CharOut out) {
        CharOut charOut = DataGridUtil.extractValues(dataGrid, extractor, out, true);
        if (charOut == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "extractSelectedValues"));
        }
        return charOut;
    }

    @NotNull
    public static CharOut extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor extractor, @NotNull CharOut out, boolean selection) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridUtil", "extractValues"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/datagrid/DataGridUtil", "extractValues"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/datagrid/DataGridUtil", "extractValues"));
        }
        if (extractor instanceof TranspositionAwareDefaultExtractor) {
            Project project = DataGridUtil.getProject(dataGrid);
            boolean transposed = dataGrid.isTransposed() && DataExtractorProperties.isTranspositionAllowed(project);
            ((TranspositionAwareDefaultExtractor)extractor).setTransposedMode(transposed);
        }
        int[] columns = (selection ? dataGrid.getSelectionModel().getSelectedColumns() : dataGrid.getDataModel().getColumnIndices()).asArray();
        List<DataConsumer.Row> rows = selection ? DataGridUtil.getSelectedRows(dataGrid) : dataGrid.getDataModel().getRows();
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        ExtractorsUtil.extract(out, dialect, false, dataGrid.getDataModel().getColumns(), extractor, rows, columns);
        CharOut charOut = out;
        if (charOut == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "extractValues"));
        }
        return charOut;
    }

    @NotNull
    public static List<DataConsumer.Row> getSelectedRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridUtil", "getSelectedRows"));
        }
        ModelIndexSet rowIndices = dataGrid.getSelectionModel().getSelectedRows();
        List<DataConsumer.Row> rows = dataGrid.getDataModel().getRows(rowIndices);
        List<DataConsumer.Row> list = rows.isEmpty() ? dataGrid.getDataModel().getRows() : rows;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataGridUtil", "getSelectedRows"));
        }
        return list;
    }
}

