/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDataHookUpBase<Row, Column>
implements GridDataHookUp<Row, Column> {
    private final Project myProject;
    private final EventDispatcher<GridDataHookUp.RequestListener> myRequestEventDispatcher = EventDispatcher.create(GridDataHookUp.RequestListener.class);

    protected GridDataHookUpBase(Project project) {
        this.myProject = project;
    }

    @Override
    public void addRequestListener(@NotNull GridDataHookUp.RequestListener<Row, Column> listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/datagrid/GridDataHookUpBase", "addRequestListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/GridDataHookUpBase", "addRequestListener"));
        }
        this.myRequestEventDispatcher.addListener(listener, disposable);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpBase", "getProject"));
        }
        return project;
    }

    @Override
    @Nullable
    public GridFilteringModel getFilteringModel() {
        return null;
    }

    @Override
    @Nullable
    public GridSortingModel<Row, Column> getSortingModel() {
        return null;
    }

    @Override
    @Nullable
    public GridMutator<Row, Column> getMutator() {
        return null;
    }

    @Override
    public int getBusyCount() {
        return 0;
    }

    @Override
    public void cancelRequests() {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected void notifyRequestFinished(final @NotNull GridRequestSource<Row, Column> source, final boolean success) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/GridDataHookUpBase", "notifyRequestFinished"));
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ((GridDataHookUp.RequestListener)GridDataHookUpBase.this.myRequestEventDispatcher.getMulticaster()).requestFinished(source, success);
            }
        });
    }

    protected void notifyRequestError(final @NotNull GridRequestSource<Row, Column> source, final @Nullable String message, final @Nullable Throwable th) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/GridDataHookUpBase", "notifyRequestError"));
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ((GridDataHookUp.RequestListener)GridDataHookUpBase.this.myRequestEventDispatcher.getMulticaster()).error(source, message, th);
            }
        });
    }

    protected void notifyUpdateCountReceived(final @NotNull GridRequestSource<Row, Column> source, final int updateCount) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/GridDataHookUpBase", "notifyUpdateCountReceived"));
        }
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ((GridDataHookUp.RequestListener)GridDataHookUpBase.this.myRequestEventDispatcher.getMulticaster()).updateCountReceived(source, updateCount);
            }
        });
    }
}

