/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseForeignKey;
import com.intellij.database.dataSource.DatabaseIndex;
import com.intellij.database.dataSource.DatabaseTableData;
import com.intellij.database.dataSource.DatabaseTableFieldData;
import com.intellij.database.dataSource.DatabaseTableKey;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.sqlite.SqliteDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteDialect
extends AbstractDatabaseDialect
implements AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final MetaModel<DasObject> META_MODEL = MetaModel.builder().put(ObjectKind.NONE, ObjectKind.SCHEMA, DasNamespace.class).put(ObjectKind.SCHEMA, ObjectKind.TABLE, DasTable.class).put(ObjectKind.SCHEMA, ObjectKind.VIEW, DasTable.class).put(ObjectKind.TABLE, ObjectKind.COLUMN, DasColumn.class).put(ObjectKind.TABLE, ObjectKind.INDEX, DasIndex.class).put(ObjectKind.TABLE, ObjectKind.KEY, DasTableKey.class).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY, DasForeignKey.class).put(ObjectKind.TABLE, ObjectKind.CHECK, DasObject.class).put(ObjectKind.TABLE, ObjectKind.TRIGGER, DasTrigger.class).put(ObjectKind.VIEW, ObjectKind.COLUMN, DasColumn.class).build();
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    public SqliteDialect() {
        super(META_MODEL, new TypeHelper.SQLiteTypeHelper(), new KeywordHelper.SqliteKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new SqliteDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQLite" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getDisplayName"));
        }
        return "SQLite";
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.SQLITE;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Sqlite;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getIcon"));
        }
        return icon;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/SqliteDialect", "supportsProduct"));
        }
        return databaseProductName != null && databaseProductName.toLowerCase(Locale.ENGLISH).contains("sqlite");
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnComment"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnNullable"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.null.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsModifyColumn() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnName"));
        }
        builder.keywords("begin", "transaction").newStatement();
        DasTable t = from.getTable();
        Application application = ApplicationManager.getApplication();
        String uuid = application == null || application.isUnitTestMode() ? "_tmp" : UUID.randomUUID().toString().substring(0, 4);
        String tableName = t.getName();
        String newTableName = tableName + uuid;
        DatabaseTableData table = new DatabaseTableData(tableName, DasUtil.getSchema((DasObject)t), DasUtil.getCatalog((DasObject)t), t.getKind());
        DialectUtils.getRenameTableSQL(builder, table, newTableName).newStatement();
        for (DasColumn info : DasUtil.getColumns((DasObject)t)) {
            DatabaseTableFieldData col = new DatabaseTableFieldData(info.equals(from) ? toName : info.getName(), (DasTypedObject)info, table);
            table.getColumns().add(col);
        }
        for (DasIndex idx : DasUtil.getIndices((DasTable)t)) {
            DasColumn[] cols = SqliteDialect.newKeyColumns((MultiRef<? extends DasTypedObject>)idx.getColumnsRef(), table, toName, from);
            table.getIndices().add(new DatabaseIndex(idx.getName(), true, cols));
        }
        for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)t)) {
            if (!(fk instanceof DatabaseForeignKey)) continue;
            table.getForeignKeys().add(new DatabaseForeignKey(fk.getName(), true, SqliteDialect.newKeyColumns((MultiRef<? extends DasTypedObject>)fk.getColumnsRef(), table, toName, from), SqliteDialect.refColumns(fk)));
        }
        DasTableKey key = DasUtil.getPrimaryKey((DasTable)t);
        if (key instanceof DatabaseTableKey) {
            ((DatabaseTableKey)key).resolveReferences((Collection)Collections.emptyList());
            DatabaseTableKey newPk = new DatabaseTableKey(key.getName(), true, SqliteDialect.newKeyColumns((MultiRef<? extends DasTypedObject>)key.getColumnsRef(), table, toName, from));
            table.setPrimaryKey(newPk);
        }
        this.sqlCreateTable(builder, ContainerUtil.newSmartList((Object)table), true, null).newStatement();
        builder.keywords("insert", "into").space().identifier(tableName).space().keyword("select").space().plain("*").space().keyword("from").space().identifier(newTableName).newStatement();
        DatabaseTableData tmpTable = new DatabaseTableData(newTableName, DasUtil.getSchema((DasObject)t), DasUtil.getCatalog((DasObject)t), t.getKind());
        this.sqlDropTable(builder, tmpTable, true, false, DasUtil.emptyModel()).newStatement();
        DdlBuilder ddlBuilder = builder.keyword("commit").newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    @NotNull
    private static DasColumn[] refColumns(@NotNull DasForeignKey fk) {
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/dialects/SqliteDialect", "refColumns"));
        }
        MultiRef ref = fk.getRefColumns();
        DasColumn[] cols = new DasColumn[ref.size()];
        int i = 0;
        for (DasTypedObject column : ref.resolveObjects()) {
            cols[i] = (DasColumn)column;
        }
        if (cols == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "refColumns"));
        }
        return cols;
    }

    @NotNull
    private static DasColumn[] newKeyColumns(@NotNull MultiRef<? extends DasTypedObject> ref, @NotNull DatabaseTableData table, @NotNull String toName, @NotNull DasColumn from) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dialects/SqliteDialect", "newKeyColumns"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "newKeyColumns"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/SqliteDialect", "newKeyColumns"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/SqliteDialect", "newKeyColumns"));
        }
        DasColumn[] cols = new DasColumn[ref.size()];
        int i = 0;
        for (DasTypedObject column : ref.resolveObjects()) {
            cols[i] = new DatabaseTableFieldData(column.equals(from) ? toName : column.getName(), column, table);
        }
        if (cols == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "newKeyColumns"));
        }
        return cols;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnType"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnType"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnType"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.type.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAlterColumnDefault"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/SqliteDialect", "sqlDropPrimaryKey"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.primary.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return false;
    }

    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return false;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/SqliteDialect", "sqlRenameTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getRenameTableSQL(builder, table, newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlCreateView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/SqliteDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/SqliteDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/SqliteDialect", "sqlCreateView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view, definition, "", this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlRenameView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/SqliteDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/SqliteDialect", "sqlRenameView"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/SqliteDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateIndexSQL(builder, index);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/SqliteDialect", "sqlDropIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index, indexName, null, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/SqliteDialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, false, false, "", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SqliteDialect", "sqlTableDefinition"));
        }
        Pair pair = Pair.create((Object)("select GROUP_CONCAT(s, ';\n') from (select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()) + "' and (type = 'table' or type = 'index') order by type desc)"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlTableDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull Connection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/SqliteDialect", "tryToLoadTableDefinition"));
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsDropPrimaryKey() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/SqliteDialect", "sqlCreateSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsDropColumn() {
        return false;
    }

    @Override
    public boolean supportsAddPrimaryKey() {
        return false;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/SqliteDialect", "sqlAlterSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/SqliteDialect", "sqlSequenceInformation"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/SqliteDialect", "sqlDropSequence"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/SqliteDialect", "sqlAddForeignKey"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.foreign.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/SqliteDialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/SqliteDialect", "sqlAddUniqueConstraint"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.unique", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumnAutoIncrement"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String sequenceName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumnAutoIncrement"));
        }
        if (sequenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequenceName", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumnAutoIncrement"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlDropColumn"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.drop", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlDropForeignKey"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/dialects/SqliteDialect", "sqlDropForeignKey"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.foreign.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/SqliteDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/SqliteDialect", "sqlDropConstraint"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.constraint", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumn"));
        }
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddColumnSQL(builder, column, true, true, true).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SqliteDialect", "sqlViewDefinition"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.view.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/SqliteDialect", "sqlProcedureDefinition"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/SqliteDialect", "isValidPlainIdentifier"));
        }
        char c0 = identifier.charAt(0);
        if (c0 != '_' && !Character.isLetter(c0)) {
            return false;
        }
        int len = identifier.length();
        for (int i = 1; i < len; ++i) {
            char c = identifier.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "qualifiedIdentifier"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/SqliteDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/SqliteDialect", "qualifiedIdentifier"));
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public boolean supportsDropForeignKey() {
        return false;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/SqliteDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/SqliteDialect", "sqlExplainPlan"));
        }
        if (analyze) {
            throw new UnsupportedOperationException("SQLite does not support EXPLAIN ANALYZE");
        }
        builder.keyword("explain").space().plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(true), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, !existing, true, true), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/SqliteDialect", "getTableEditorCaps"));
        }
        return tableEditorCaps;
    }
}

