/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNames {
    private static final Pattern SCALE_OPT = Pattern.compile("\\[([^\\[\\]]*)\\$s([^\\[\\]]*)\\]");
    private final THashMap<String, String> myTypeNames = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final TIntObjectHashMap<TreeMap<Integer, String>> myWeighted = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myDefaults = new TIntObjectHashMap();

    protected String get(int typecode) {
        return (String)this.myDefaults.get(typecode);
    }

    @Nullable
    public String get(int typecode, int size, int precision, int scale) {
        Map map = (Map)this.myWeighted.get(typecode);
        if (map != null && map.size() > 0) {
            for (Map.Entry o : map.entrySet()) {
                if (size > (Integer)o.getKey()) continue;
                return TypeNames.replace((String)o.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(typecode), size, precision, scale);
    }

    @Nullable
    private static String replace(String type, int size, int precision, int scale) {
        type = TypeNames.replaceOnceOrOpt(type, "$s", SCALE_OPT, scale);
        type = TypeNames.replaceOnce(type, "$l", size);
        return TypeNames.replaceOnce(type, "$p", precision);
    }

    public void put(int typecode, int capacity, String value) {
        this.registerType(value);
        TreeMap<Integer, String> map = (TreeMap<Integer, String>)this.myWeighted.get(typecode);
        if (map == null) {
            map = new TreeMap<Integer, String>();
            this.myWeighted.put(typecode, map);
        }
        map.put(capacity, value);
    }

    public void put(int typecode, String value) {
        this.registerType(value);
        this.myDefaults.put(typecode, (Object)value);
    }

    private void registerType(String value) {
        String item = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)value, (String)"("));
        ContainerUtil.putIfNotNull((Object)item, (Object)value, this.myTypeNames);
    }

    @NotNull
    public String getType(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        String value = (String)this.myTypeNames.get((Object)name);
        if (value != null) {
            String replace = TypeNames.replace(value, length, precision, scale);
            String string = replace == null ? name : replace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames", "getType"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        return string;
    }

    @Nullable
    static String replaceOnce(@Nullable String template, @NotNull String placeholder, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnce"));
        }
        if (template == null) {
            return null;
        }
        if (template.contains(placeholder) && replacement < 0) {
            return null;
        }
        return template.replace(placeholder, String.valueOf(replacement));
    }

    @Nullable
    static String replaceOnceOrOpt(@Nullable String template, @NotNull String placeholder, @NotNull Pattern pattern, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (template == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(template);
        if (!matcher.find()) {
            return TypeNames.replaceOnce(template, placeholder, replacement);
        }
        return matcher.replaceFirst(replacement <= 0 ? "" : "$1" + Matcher.quoteReplacement(String.valueOf(replacement)) + "$2");
    }

    public int findTypeCode(@NotNull String name) {
        String trim;
        int idx2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeNames", "findTypeCode"));
        }
        int idx = name.indexOf(40);
        String name1 = idx > -1 ? name.substring(0, idx) : name;
        String name2 = (String)this.myTypeNames.get((Object)name1);
        if (name2 == null) {
            return 1111;
        }
        int size = -1;
        if (name2.contains("$s") && (idx2 = StringUtil.indexOfAny((String)(trim = name2.substring(idx + 1).trim()), (String)" ,)")) > -1) {
            size = StringUtil.parseInt((String)trim.substring(0, idx2), (int)-1);
        }
        TIntObjectIterator it = this.myWeighted.iterator();
        while (it.hasNext()) {
            it.advance();
            for (Map.Entry e : ((TreeMap)it.value()).entrySet()) {
                String val = (String)e.getValue();
                if (size > (Integer)e.getKey() || !Comparing.equal((String)val, (String)name1, (boolean)false) && !Comparing.equal((String)val, (String)name2, (boolean)false)) continue;
                return it.key();
            }
        }
        it = this.myDefaults.iterator();
        while (it.hasNext()) {
            it.advance();
            String val = (String)it.value();
            if (!Comparing.equal((String)val, (String)name1, (boolean)false) && !Comparing.equal((String)val, (String)name2, (boolean)false)) continue;
            return it.key();
        }
        return 1111;
    }
}

