/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DbDiffCheckOption;
import com.intellij.database.diff.DbDiffElement;
import com.intellij.database.diff.DbMigrationAction;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class CompareDbElementsAction
extends DumbAwareAction {
    public CompareDbElementsAction() {
        super("Compare", null, AllIcons.Diff.Diff);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = CompareDbElementsAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.customSettings.put("IGNORE_ORDER", true);
        settings.customSettings.put("IGNORE_CASE", true);
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_ORDER", "Ignore &order", "alt O"));
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_CASE", "Ignore &case", "alt C"));
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.diff");
        Pair<DbDiffElement, DbDiffElement> pair = CompareDbElementsAction.getElements(e);
        assert (pair != null);
        ((DbDiffElement)((Object)pair.first)).setSettings(settings);
        ((DbDiffElement)((Object)pair.second)).setSettings(settings);
        DirDiffManager.getInstance((Project)project).showDiff((DiffElement)pair.first, (DiffElement)pair.second, settings, null);
    }

    @Nullable
    public static Pair<DbDiffElement, DbDiffElement> getElements(AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (elements == null || elements.length != 2) {
            return null;
        }
        if (elements[0].getClass() != elements[1].getClass() || !(elements[0] instanceof DbElement)) {
            return null;
        }
        DbElement e1 = (DbElement)elements[0];
        DbElement e2 = (DbElement)elements[1];
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        return Pair.create((Object)((Object)new DbDiffElement(e1)), (Object)((Object)new DbDiffElement(e2)));
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(CompareDbElementsAction.getEventProject((AnActionEvent)e) != null && CompareDbElementsAction.getElements(e) != null);
    }
}

