/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableDiffDividerDrawUtil {
    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerSeparatorPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparators"));
        }
        List<DiffDividerDrawUtil.DividerSeparator> polygons = TableDiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DiffDividerDrawUtil.DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    public static void paintSeparatorsOnScrollbar(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerSeparatorPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSeparatorsOnScrollbar"));
        }
        List<DiffDividerDrawUtil.DividerSeparator> polygons = TableDiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DiffDividerDrawUtil.DividerSeparator polygon : polygons) {
            polygon.paintOnScrollbar(gg, width);
        }
        config.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        TableDiffDividerDrawUtil.paintPolygons(gg, width, true, true, editor1, editor2, paintable);
    }

    public static void paintSimplePolygons(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintSimplePolygons"));
        }
        TableDiffDividerDrawUtil.paintPolygons(gg, width, true, false, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean paintBorder, boolean curved, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        List<DiffDividerDrawUtil.DividerPolygon> polygons = TableDiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DiffDividerDrawUtil.DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, paintBorder, curved);
        }
        config.restore();
    }

    public static void paintPolygonsOnScrollbar(@NotNull Graphics2D g, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerPaintable paintable) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygonsOnScrollbar"));
        }
        List<DiffDividerDrawUtil.DividerPolygon> polygons = TableDiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        for (DiffDividerDrawUtil.DividerPolygon polygon : polygons) {
            polygon.paintOnScrollbar(g, width);
        }
    }

    @NotNull
    public static List<DiffDividerDrawUtil.DividerPolygon> createVisiblePolygons(@NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        final ArrayList<DiffDividerDrawUtil.DividerPolygon> polygons = new ArrayList<DiffDividerDrawUtil.DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{TableDiffDividerDrawUtil.getTransformation(editor1), TableDiffDividerDrawUtil.getTransformation(editor2)};
        final DiffDividerDrawUtil.Interval leftInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor1);
        final DiffDividerDrawUtil.Interval rightInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DiffDividerDrawUtil.DividerPaintable.Handler(){

            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$1", "process"));
                }
                if (leftInterval.startLine > endLine1 && rightInterval.startLine > endLine2) {
                    return true;
                }
                if (leftInterval.endLine < startLine1 && rightInterval.endLine < startLine2) {
                    return false;
                }
                polygons.add(TableDiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color));
                return true;
            }

            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color, boolean resolved) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$1", "process"));
                }
                return this.process(startLine1, endLine1, startLine2, endLine2, color);
            }
        });
        ArrayList<DiffDividerDrawUtil.DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        return arrayList;
    }

    @NotNull
    public static List<DiffDividerDrawUtil.DividerSeparator> createVisibleSeparators(final @NotNull DiffSupport editor1, final @NotNull DiffSupport editor2, @NotNull DiffDividerDrawUtil.DividerSeparatorPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisibleSeparators"));
        }
        final ArrayList<DiffDividerDrawUtil.DividerSeparator> separators = new ArrayList<DiffDividerDrawUtil.DividerSeparator>();
        final Transformation[] transformations = new Transformation[]{TableDiffDividerDrawUtil.getTransformation(editor1), TableDiffDividerDrawUtil.getTransformation(editor2)};
        final DiffDividerDrawUtil.Interval leftInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor1);
        final DiffDividerDrawUtil.Interval rightInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DiffDividerDrawUtil.DividerSeparatorPaintable.Handler(){

            public boolean process(int line1, int line2) {
                if (leftInterval.startLine > line1 + 1 && rightInterval.startLine > line2 + 1) {
                    return true;
                }
                if (leftInterval.endLine < line1 && rightInterval.endLine < line2) {
                    return false;
                }
                int height1 = editor1.getLineHeight(line1);
                int height2 = editor2.getLineHeight(line2);
                separators.add(TableDiffDividerDrawUtil.createSeparator(transformations, line1, line2, height1, height2));
                return true;
            }
        });
        ArrayList<DiffDividerDrawUtil.DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisibleSeparators"));
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(final @NotNull DiffSupport editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getTransformation"));
        }
        Transformation transformation = new Transformation(){

            public int transform(int line) {
                int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
                int headerOffset = editor.getHeaderOffset();
                return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
            }
        };
        if (transformation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getTransformation"));
        }
        return transformation;
    }

    @NotNull
    private static DiffDividerDrawUtil.DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        int start1 = transformations[0].transform(startLine1) + 1;
        int end1 = transformations[0].transform(endLine1) + 1;
        int start2 = transformations[1].transform(startLine2) + 1;
        int end2 = transformations[1].transform(endLine2) + 1;
        DiffDividerDrawUtil.DividerPolygon dividerPolygon = new DiffDividerDrawUtil.DividerPolygon(start1, start2, end1, end2, color);
        if (dividerPolygon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        return dividerPolygon;
    }

    @NotNull
    private static DiffDividerDrawUtil.DividerSeparator createSeparator(@NotNull Transformation[] transformations, int line1, int line2, int height1, int height2) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createSeparator"));
        }
        int start1 = transformations[0].transform(line1);
        int start2 = transformations[1].transform(line2);
        DiffDividerDrawUtil.DividerSeparator dividerSeparator = new DiffDividerDrawUtil.DividerSeparator(start1, start2, start1 + height1, start2 + height2);
        if (dividerSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createSeparator"));
        }
        return dividerSeparator;
    }

    @NotNull
    private static DiffDividerDrawUtil.Interval getVisibleInterval(DiffSupport editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        DiffDividerDrawUtil.Interval interval = new DiffDividerDrawUtil.Interval(position1.line, position2.line);
        if (interval == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getVisibleInterval"));
        }
        return interval;
    }
}

