/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorTableResultPanel
extends TableResultPanel {
    private Map<String, InitialColumnProperties> myInitialColumnProperties;

    public EditorTableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/EditorTableResultPanel", "<init>"));
        }
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/editor/EditorTableResultPanel", "<init>"));
        }
        super(project, hookUp, DataGridUtil.getGridPopupActions());
        this.myInitialColumnProperties = Collections.emptyMap();
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        super.columnsAdded(columnIndices);
        this.myInitialColumnProperties = Collections.emptyMap();
    }

    @NotNull
    public List<String> getFiltersHistory() {
        ImmutableList<String> immutableList = this.myFilterPanel.getHistory();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/EditorTableResultPanel", "getFiltersHistory"));
        }
        return immutableList;
    }

    public void setFiltersHistory(@NotNull List<String> history) {
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/database/editor/EditorTableResultPanel", "setFiltersHistory"));
        }
        this.myFilterPanel.setHistory(history);
    }

    @Override
    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/editor/EditorTableResultPanel", "isInitiallyDisabled"));
        }
        if (super.isInitiallyDisabled(column)) {
            return true;
        }
        InitialColumnProperties properties = this.myInitialColumnProperties != null ? this.myInitialColumnProperties.get(column.name) : null;
        return properties != null && !properties.enabled;
    }

    @Override
    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/editor/EditorTableResultPanel", "getInitialContentLanguage"));
        }
        if (this.myInitialColumnProperties == null) {
            return super.getInitialContentLanguage(column);
        }
        InitialColumnProperties properties = this.myInitialColumnProperties.get(column.name);
        Language fromInitialProperties = properties != null ? properties.language : Language.ANY;
        return fromInitialProperties == Language.ANY ? super.getInitialContentLanguage(column) : fromInitialProperties;
    }

    void setInitialColumnProperties(@NotNull Map<String, InitialColumnProperties> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/editor/EditorTableResultPanel", "setInitialColumnProperties"));
        }
        this.myInitialColumnProperties = properties;
    }

    static class InitialColumnProperties {
        public final boolean enabled;
        public final Language language;

        public InitialColumnProperties(boolean enabled, @NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/editor/EditorTableResultPanel$InitialColumnProperties", "<init>"));
            }
            this.enabled = enabled;
            this.language = language;
        }
    }
}

