/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataExtractorProperties {
    private static final String PROPERTY_HONOR_TRANSPOSED_MODE = "Console.TableResult.HonorTransposedMode";
    private static final String PROPERTY_DEFAULT_EXTRACTOR_FACTORY = "Console.TableResult.DefaultCopyAction";

    private DataExtractorProperties() {
    }

    @NotNull
    public static DataExtractorFactory getCurrentExtractorFactory(@Nullable Project project) {
        PropertiesComponent storage = project == null ? null : PropertiesComponent.getInstance((Project)project);
        String factoryName = storage != null ? storage.getValue(PROPERTY_DEFAULT_EXTRACTOR_FACTORY) : null;
        DataExtractorFactory factory = factoryName != null ? DataExtractorFactories.find(factoryName) : null;
        DataExtractorFactory dataExtractorFactory = factory != null ? factory : DataExtractorFactories.getDefault();
        if (dataExtractorFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorProperties", "getCurrentExtractorFactory"));
        }
        return dataExtractorFactory;
    }

    public static void setCurrentExtractorFactory(@NotNull Project project, @NotNull DataExtractorFactory f) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/extractors/DataExtractorProperties", "setCurrentExtractorFactory"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/database/extractors/DataExtractorProperties", "setCurrentExtractorFactory"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(PROPERTY_DEFAULT_EXTRACTOR_FACTORY, f.getName());
    }

    public static boolean isTranspositionAllowed(@Nullable Project project) {
        return project == null || PropertiesComponent.getInstance((Project)project).getBoolean(PROPERTY_HONOR_TRANSPOSED_MODE, true);
    }

    public static void setTranspositionAllowed(@NotNull Project project, boolean allowed) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/extractors/DataExtractorProperties", "setTranspositionAllowed"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(PROPERTY_HONOR_TRANSPOSED_MODE, allowed, true);
    }
}

