/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DataType;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatter {
    private static final int MIN_IMAGE_BYTES = 100;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;
    private static final long PG_DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    private static final long PG_DATE_POSITIVE_INFINITY = 9223372036825200000L;
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private static final ConcurrentMap<DataConsumer.Column, Format> ourFormatCache = ContainerUtil.createConcurrentSoftMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private SimpleDateFormat myDateFormat;
    private SimpleDateFormat myTimeFormat;
    private DecimalFormat myNumberFormat;
    private DecimalFormat myBigIntFormat;
    private static final MyMap<Object> ourToObject = new MyMap();
    private final MyMap<String> myToString = new MyMap();

    public ObjectFormatter() {
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return o;
            }
        });
        this.myToString.register(Object[].class, new Converter<Object[], String>(){

            @Override
            public String convert(Object[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.length == 0) {
                    return forDisplay ? "{}" : "";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                int arrayLength = Math.min(o.length, 100);
                for (int i = 0; i < arrayLength; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(ObjectFormatter.this.objectToString(o[i], column, dialect, true));
                }
                if (o.length > 100) {
                    sb.append(",...");
                }
                sb.append("}");
                return sb.toString();
            }
        });
        this.myToString.register(byte[].class, new Converter<byte[], String>(){

            @Override
            public String convert(byte[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (forDisplay && ObjectFormatter.isOracleGUID(o, column, dialect)) {
                    return DialectUtils.toHexString(o);
                }
                return ObjectFormatter.this.bytesToStringImpl(o, o.length, dialect, forDisplay);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                String text = new String(o);
                return ObjectFormatter.charToStringImpl(text, text.length(), forDisplay);
            }
        });
        this.myToString.register(Clob.class, new Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Clob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.charToStringImpl(trimmed > 0 ? o.getSubString(1L, trimmed) : "", length, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, new Converter<LobInfo.ClobInfo, String>(){

            @Override
            public String convert(LobInfo.ClobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dialect, o.length);
                }
                return ObjectFormatter.charToStringImpl(o.data, o.length, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, new Converter<LobInfo.FileClobInfo, String>(){

            @Override
            public String convert(LobInfo.FileClobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Blob.class, new Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Blob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), length, dialect, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, String>(){

            @Override
            public String convert(LobInfo.BlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dialect, o.length);
                }
                return ObjectFormatter.this.bytesToStringImpl(o.data, o.length, dialect, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, new Converter<LobInfo.FileBlobInfo, String>(){

            @Override
            public String convert(LobInfo.FileBlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getTimestampFormat(column, dialect), o, dialect);
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getTimeFormat().format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                SimpleDateFormat format = column == null || column.clazz == null ? ObjectFormatter.this.getDateFormat() : (column.clazz.endsWith("Timestamp") ? ObjectFormatter.this.getTimestampFormat(column, dialect) : (column.clazz.endsWith("Time") ? ObjectFormatter.this.getTimeFormat() : ObjectFormatter.this.getDateFormat()));
                return ObjectFormatter.dateToString(format, o, dialect);
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getBigIntFormat().format(o);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.this.getDecimalFormat(column).format(o);
            }
        });
        this.myToString.register(ImageInfo.class, new Converter<ImageInfo, String>(){

            @Override
            public String convert(ImageInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (!forDisplay && o.bytes != null) {
                    return ObjectFormatter.this.bytesToStringImpl(o.bytes, o.size, dialect, false);
                }
                return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
            }
        });
        this.myToString.register(TextInfo.class, new Converter<TextInfo, String>(){

            @Override
            public String convert(TextInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return forDisplay ? o.text : ObjectFormatter.bytesToString(o.bytes, dialect, false);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.isHstore(column) ? ObjectFormatter.hstoreToString(o, forDisplay) : null;
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (forDisplay) {
                    return String.valueOf(o);
                }
                DatabaseFamilyId familyId = dialect.getFamilyId();
                if (familyId.isTransactSql()) {
                    return o != false ? "1" : "0";
                }
                return String.valueOf(o);
            }
        });
    }

    private static boolean isOracleGUID(byte[] o, DataConsumer.Column column, DatabaseDialect dialect) {
        return dialect.getFamilyId().isOracle() && o != null && o.length == 16 && "RAW".equals(column.typeName);
    }

    public static boolean isHstore(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isHstore"));
        }
        return column.type == 1111 && "hstore".equals(column.typeName) && "java.util.Map".equals(column.clazz);
    }

    public static boolean isPostgresJsonx(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isPostgresJsonx"));
        }
        String typeName = column.typeName;
        return StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"json") || StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"jsonb");
    }

    public static boolean isPostgresArray(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isPostgresArray"));
        }
        return column.type == 2003;
    }

    private static String hstoreToString(Map<String, String> hstore, boolean forDisplay) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first) {
                sb.append(',');
                sb.append(forDisplay ? (char)'\n' : ' ');
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), !forDisplay, false);
            sb.append(" => ");
            ObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), !forDisplay, false);
            first = false;
        }
        return sb.toString();
    }

    public static StringBuilder appendHstoreValue(StringBuilder sb, String value, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value) : value);
        if (requiresQuotation) {
            sb.append('\"');
        }
        return sb;
    }

    private static String dateToString(@NotNull DateFormat format, @NotNull Date date, @Nullable DatabaseDialect dialect) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter", "dateToString"));
        }
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/database/extractors/ObjectFormatter", "dateToString"));
        }
        if (dialect == PostgresDialect.INSTANCE) {
            long time = date.getTime();
            if (9223372036825200000L == time) {
                return "infinity";
            }
            if (-9223372036832400000L == time) {
                return "-infinity";
            }
        }
        return format.format(date);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String charToStringImpl(@NotNull String text, long wholeLength, boolean bl) {
        void forDisplay;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/extractors/ObjectFormatter", "charToStringImpl"));
        }
        String string = forDisplay == false || (long)text.length() == wholeLength ? text : ObjectFormatter.valueToString(text, text.length(), wholeLength);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "charToStringImpl"));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String bytesToStringImpl(@NotNull byte[] o, long wholeLength, DatabaseDialect dialect, boolean bl) {
        void forDisplay;
        String stringValue;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/extractors/ObjectFormatter", "bytesToStringImpl"));
        }
        boolean truncated = wholeLength != (long)o.length;
        boolean wholeValueLoaded = !truncated && o.length < DatabaseSettings.getSettings().getMaxLobLength();
        String string = stringValue = wholeValueLoaded || forDisplay != false ? ObjectFormatter.tryDecodeString(o, CharsetToolkit.UTF8_CHARSET) : null;
        if (wholeValueLoaded && stringValue != null) {
            String string2 = stringValue;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "bytesToStringImpl"));
            }
            return string2;
        }
        if (forDisplay != false) {
            stringValue = stringValue != null ? stringValue : ObjectFormatter.bytesToString(o, dialect, true);
            String string3 = ObjectFormatter.valueToString(stringValue, o.length, wholeLength);
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "bytesToStringImpl"));
            }
            return string3;
        }
        String string4 = ObjectFormatter.bytesToString(o, dialect, false);
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "bytesToStringImpl"));
        }
        return string4;
    }

    private static String getValueNotLoadedString(DataConsumer.Column column, DatabaseDialect dialect, long wholeValueSize) {
        DataType dataType = column.asDataType();
        String type = dialect != null ? dialect.getTypeName(dataType) : StringUtil.notNullize((String)column.typeName, (String)"unknown");
        return "(" + StringUtil.toUpperCase((String)type) + "):" + ExtractorsUtil.getPresentableSize(wholeValueSize);
    }

    private static String valueToString(String value, long loadedLength, long wholeLength) {
        boolean truncated = wholeLength != loadedLength;
        CharOut out = CharOut.Util.newSink();
        out.append(ExtractorsUtil.getPresentableSize(wholeLength));
        if (!truncated) {
            out.append("\n").append(value);
        } else {
            out.append(" (").append(ExtractorsUtil.getPresentableSize(loadedLength)).append(" loaded)\n").append(value).append("...");
        }
        return out.toString();
    }

    @Nullable
    public static Object objectToObject(@Nullable Object o, DataConsumer.Column column) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)ourToObject.get(o.getClass());
        Object result = converter != null ? (Object)converter.convert(o, column, GenericDialect.INSTANCE, false) : null;
        return result != null ? result : ObjectFormatter.objectToObject(String.valueOf(o), column);
    }

    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result = converter != null ? (String)converter.convert(o, column, dialect, forDisplay) : null;
        result = result != null ? result : this.objectToString(String.valueOf(o), column, dialect, forDisplay);
        return (String)ObjectUtils.assertNotNull((Object)result);
    }

    @Nullable
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/ObjectFormatter", "getValueLiteral"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "getValueLiteral"));
        }
        Object value = column.getValue(row);
        return this.objectToString(value, column, dialect, forDisplay);
    }

    @NotNull
    public String getPlainValue(@NotNull DataConsumer.Column column, @NotNull DataConsumer.Row row, DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "getPlainValue"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/ObjectFormatter", "getPlainValue"));
        }
        String literal = this.getValueLiteral(row, column, dialect, true);
        if (literal == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "getPlainValue"));
            }
            return "null";
        }
        String string = literal;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "getPlainValue"));
        }
        return string;
    }

    @Nullable
    private static Object tryDetectObject(byte[] bytes) {
        ImageInfo image = ObjectFormatter.tryDetectImage(bytes);
        if (image != null) {
            return image;
        }
        TextInfo text = ObjectFormatter.tryDetectString(bytes);
        if (text != null) {
            return text;
        }
        return null;
    }

    @Nullable
    private static TextInfo tryDetectString(byte[] bytes) {
        BinaryLightVirtualFile file = new BinaryLightVirtualFile("detect-string", bytes);
        Trinity guessed = LoadTextUtil.guessFromContent((VirtualFile)file, (byte[])bytes, (int)bytes.length);
        return guessed == null ? null : new TextInfo(LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (VirtualFile)file).toString(), bytes);
    }

    @Nullable
    private static String tryDecodeString(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/extractors/ObjectFormatter", "tryDecodeString"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/extractors/ObjectFormatter", "tryDecodeString"));
        }
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            CharBuffer buf = d.decode(ByteBuffer.wrap(bytes));
            boolean bad = false;
            int len = buf.length();
            for (int i = 0; !bad && i < len; ++i) {
                char c = buf.charAt(i);
                bad = c < ' ' && c != '\n' && c != '\r' && c != '\t';
            }
            if (!bad) {
                return buf.toString();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ImageInfo tryDetectImage(final byte[] bytes) {
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    @Nullable
    private static BufferedImage readImage(byte[] bytes) {
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T extractImageData(byte[] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataExtractor", "com/intellij/database/extractors/ObjectFormatter", "extractImageData"));
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> readers = stream != null ? ImageIO.getImageReaders(stream) : ContainerUtil.emptyIterator();
            ImageReader reader = readers.hasNext() ? readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public SimpleDateFormat getDateFormat() {
        this.initFormats();
        return this.myDateFormat;
    }

    public SimpleDateFormat getTimeFormat() {
        this.initFormats();
        return this.myTimeFormat;
    }

    public SimpleDateFormat getTimestampFormat(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "getTimestampFormat"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/ObjectFormatter", "getTimestampFormat"));
        }
        Format format = (Format)ourFormatCache.get(column);
        if (format instanceof SimpleDateFormat) {
            return (SimpleDateFormat)format;
        }
        SimpleDateFormat result = ObjectFormatter.newTimestampFormat(column, dialect);
        ourFormatCache.putIfAbsent(column, result);
        return result;
    }

    private static SimpleDateFormat newTimestampFormat(DataConsumer.Column column, DatabaseDialect dialect) {
        int scale = column.scale;
        if (dialect.getFamilyId().isMysql() && column.type == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)column.typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)column.typeName))) {
            scale = column.precision - 20;
        }
        scale = Math.min(9, Math.max(0, scale));
        return new MyTimestampFormat(scale);
    }

    public DecimalFormat getDecimalFormat(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "getDecimalFormat"));
        }
        Format format = (Format)ourFormatCache.get(column);
        if (format instanceof DecimalFormat) {
            return (DecimalFormat)format;
        }
        DecimalFormat result = ObjectFormatter.isFloat(column) ? ObjectFormatter.newFloatFormat() : ObjectFormatter.newDecimalFormat();
        int fractionDigits = column.scale;
        result.setParseBigDecimal(BigDecimal.class.getName().equals(column.clazz));
        result.setMinimumFractionDigits(ObjectFormatter.isFloatingPoint(column) || ObjectFormatter.isH2DecimalWithUnspecifiedPrecision(column) ? 0 : fractionDigits);
        result.setMaximumFractionDigits(340);
        ourFormatCache.putIfAbsent(column, result);
        return result;
    }

    public static boolean isFloatingPoint(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isFloatingPoint"));
        }
        return ObjectFormatter.isFloat(column) || ObjectFormatter.isDouble(column);
    }

    private static boolean isFloat(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isFloat"));
        }
        return Float.class.getName().equals(column.clazz) || "oracle.sql.BINARY_FLOAT".equals(column.clazz);
    }

    private static boolean isDouble(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isDouble"));
        }
        return Double.class.getName().equals(column.clazz) || "oracle.sql.BINARY_DOUBLE".equals(column.clazz);
    }

    private static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/ObjectFormatter", "isH2DecimalWithUnspecifiedPrecision"));
        }
        return "DECIMAL".equals(column.typeName) && 65535 == column.precision && Short.MAX_VALUE == column.scale;
    }

    @NotNull
    private static String bytesToString(@NotNull byte[] bytes, DatabaseDialect dialect, boolean forDisplay) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/extractors/ObjectFormatter", "bytesToString"));
        }
        if (forDisplay) {
            String string = DialectUtils.toPresentableHexString(bytes);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "bytesToString"));
            }
            return string;
        }
        String string = dialect.getBinaryLiteralString(bytes);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ObjectFormatter", "bytesToString"));
        }
        return string;
    }

    private void initFormats() {
        if (this.myDateFormat != null) {
            return;
        }
        this.myDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.myTimeFormat = new SimpleDateFormat("HH:mm:ss");
        this.myNumberFormat = ObjectFormatter.newDecimalFormat();
        this.myNumberFormat.setParseIntegerOnly(true);
        this.myBigIntFormat = ObjectFormatter.newDecimalFormat();
        this.myBigIntFormat.setParseIntegerOnly(true);
        this.myBigIntFormat.setParseBigDecimal(true);
    }

    private static DecimalFormat newDecimalFormat() {
        return ObjectFormatter.configureDecimalFormat(new DecimalFormat());
    }

    private static DecimalFormat newFloatFormat() {
        return ObjectFormatter.configureDecimalFormat(new DecimalFormat(){

            @Override
            public Number parse(String text, ParsePosition pos) {
                Number n = super.parse(text, pos);
                return n != null ? Float.valueOf(n.floatValue()) : null;
            }

            @Override
            public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
                number = Double.valueOf(Float.toString((float)number));
                return super.format(number, result, fieldPosition);
            }
        });
    }

    private static DecimalFormat configureDecimalFormat(DecimalFormat format) {
        format.setGroupingUsed(false);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setNaN("NaN");
        format.setDecimalFormatSymbols(symbols);
        return format;
    }

    public NumberFormat getNumberFormat() {
        this.initFormats();
        return this.myNumberFormat;
    }

    public Format getBigIntFormat() {
        this.initFormats();
        return this.myBigIntFormat;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    static {
        Converter<Object, Object> identity = new Converter<Object, Object>(){

            @Override
            public Object convert(Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return o;
            }
        };
        ourToObject.put(Object[].class, identity);
        ourToObject.put(LobInfo.ClobInfo.class, identity);
        ourToObject.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, Object>(){

            @Override
            public Object convert(LobInfo.BlobInfo o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = ObjectFormatter.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        ourToObject.put(Boolean.class, identity);
        ourToObject.put(Number.class, identity);
        ourToObject.put(Timestamp.class, identity);
        ourToObject.put(Time.class, identity);
        ourToObject.register(Date.class, new Converter<Date, Object>(){

            @Override
            public Object convert(Date o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                if (column != null && column.clazz != null && column.clazz.endsWith("Timestamp")) {
                    return new Timestamp(o.getTime());
                }
                if (column != null && column.clazz != null && column.clazz.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        ourToObject.register(byte[].class, new Converter<byte[], Object>(){

            @Override
            public Object convert(byte[] o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                Object detectedObject = ObjectFormatter.tryDetectObject(o);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Clob.class, new Converter<Clob, Object>(){

            @Override
            public Object convert(Clob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(Blob.class, new Converter<Blob, Object>(){

            @Override
            public Object convert(Blob o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(String.class, new Converter<String, Object>(){

            @Override
            public Object convert(String o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return LobInfo.fromString((String)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Map.class, new Converter<Map, Object>(){

            @Override
            public Object convert(Map o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                return ObjectFormatter.isHstore(column) ? o : null;
            }
        });
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            ourToObject.register(ReservedCellValue.class, new Converter<ReservedCellValue, Object>(){

                @Override
                public Object convert(ReservedCellValue o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                    return o;
                }
            });
        }
    }

    private static class MyTimestampFormat
    extends SimpleDateFormat {
        private final int myScale;

        public MyTimestampFormat(int scale) {
            super("yyyy-MM-dd HH:mm:ss");
            this.myScale = scale;
        }

        @Override
        public String toPattern() {
            return super.toPattern() + (this.myScale > 0 ? '.' + StringUtil.repeatSymbol((char)'f', (int)this.myScale) : "");
        }

        @Override
        public StringBuffer format(@NotNull Date date, @NotNull StringBuffer toAppendTo, @NotNull FieldPosition pos) {
            if (date == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/database/extractors/ObjectFormatter$MyTimestampFormat", "format"));
            }
            if (toAppendTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAppendTo", "com/intellij/database/extractors/ObjectFormatter$MyTimestampFormat", "format"));
            }
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/database/extractors/ObjectFormatter$MyTimestampFormat", "format"));
            }
            StringBuffer buffer = super.format(date, toAppendTo, pos);
            if (date instanceof Timestamp && this.myScale > 0) {
                int nanos = ((Timestamp)date).getNanos();
                String nanosString = Integer.toString(nanos);
                int leadingZerosCount = 9 - nanosString.length();
                nanosString = StringUtil.repeatSymbol((char)'0', (int)leadingZerosCount) + nanosString;
                buffer.append(".");
                buffer.append(nanosString, 0, this.myScale);
            }
            return buffer;
        }

        @Override
        public Date parse(@NotNull String source, @NotNull ParsePosition parsePosition) {
            int nanos;
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/extractors/ObjectFormatter$MyTimestampFormat", "parse"));
            }
            if (parsePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsePosition", "com/intellij/database/extractors/ObjectFormatter$MyTimestampFormat", "parse"));
            }
            Date date = super.parse(source, parsePosition);
            if (date == null) {
                return null;
            }
            int n = nanos = this.myScale > 0 ? this.parseNanos(source, parsePosition) : 0;
            if (nanos < 0) {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                return null;
            }
            try {
                return new Timestamp(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), nanos);
            }
            catch (IllegalArgumentException e) {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                return null;
            }
        }

        private int parseNanos(String source, ParsePosition pos) {
            int end;
            int start = pos.getIndex();
            if (start < 0 || start >= source.length() || '.' != source.charAt(start++)) {
                return -1;
            }
            for (end = start; end < source.length() && source.charAt(end) >= '0' && source.charAt(end) <= '9'; ++end) {
            }
            int fractional = -1;
            try {
                fractional = Integer.parseInt(source.substring(start, end));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pos.setIndex(end);
            return fractional * (int)Math.pow(10.0, Math.max(1, 9 - (end - start)));
        }
    }

    public static class TextInfo {
        public final String text;
        public final byte[] bytes;

        public TextInfo(@NotNull String text, @NotNull byte[] bytes) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/extractors/ObjectFormatter$TextInfo", "<init>"));
            }
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/extractors/ObjectFormatter$TextInfo", "<init>"));
            }
            this.text = text;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextInfo info = (TextInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }
    }

    public static class ImageInfo {
        public final String format;
        public final int width;
        public final int height;
        public final int size;
        public final byte[] bytes;

        public ImageInfo(@NotNull String format, int width, int height, int size, @Nullable byte[] bytes) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter$ImageInfo", "<init>"));
            }
            this.format = format;
            this.width = width;
            this.height = height;
            this.size = size;
            this.bytes = bytes;
        }

        @Nullable
        public BufferedImage createImage() {
            return this.bytes != null ? ObjectFormatter.readImage(this.bytes) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo info = (ImageInfo)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            if (this.size != info.size) {
                return false;
            }
            if (!this.format.equals(info.format)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.format.hashCode();
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.size;
            result = 31 * result + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
            return result;
        }
    }

    private static abstract class ImageDataExtractor<T> {
        private ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }

    private static class MyMap<T>
    extends ConcurrentClassMap<Converter<Object, T>> {
        private MyMap() {
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/ObjectFormatter$MyMap", "register"));
            }
            super.put(aClass, value);
        }
    }

    static interface Converter<X, V> {
        public V convert(X var1, DataConsumer.Column var2, DatabaseDialect var3, boolean var4);
    }
}

