/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlValuesExtractor
extends DefaultValuesExtractor<DatabaseSettings.BaseState> {
    protected final DasTable myDatabaseTable;

    public SqlValuesExtractor(ObjectFormatter converter, DasTable databaseTable) {
        this(new DatabaseSettings.BaseState(), converter, databaseTable);
    }

    public SqlValuesExtractor(DatabaseSettings.BaseState state, ObjectFormatter converter, DasTable databaseTable) {
        super(state, converter);
        this.myDatabaseTable = databaseTable;
    }

    @Override
    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column) {
        if ("null" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SqlValuesExtractor", "getNullLiteral"));
        }
        return "null";
    }

    @Override
    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/SqlValuesExtractor", "getValueLiteral"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/SqlValuesExtractor", "getValueLiteral"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/SqlValuesExtractor", "getValueLiteral"));
        }
        String oraTemporal = this.getOracleDateTimestamp(row, column, dialect);
        if (oraTemporal != null) {
            String string = oraTemporal;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SqlValuesExtractor", "getValueLiteral"));
            }
            return string;
        }
        String string = super.getValueLiteral(row, column, dialect);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SqlValuesExtractor", "getValueLiteral"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull DatabaseDialect dialect, @NotNull String value) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/SqlValuesExtractor", "getStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/SqlValuesExtractor", "getStringValue"));
        }
        String fixedValue = StringUtil.replace((String)value, (String)"'", (String)"''");
        if (dialect.getFamilyId().isMysql() && value.indexOf(92) >= 0) {
            fixedValue = StringUtil.replace((String)value, (String)"\\", (String)"\\\\");
        }
        String string = "'" + fixedValue + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SqlValuesExtractor", "getStringValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("sql" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/SqlValuesExtractor", "getFileExtension"));
        }
        return "sql";
    }

    @Override
    public String getLineSeparator() {
        return "";
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new SqlExtractionBase(out, dialect, forceSkipHeader, allColumns, selectedColumns);
    }

    @Nullable
    private String getOracleDateTimestamp(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        int fractionalSeconds;
        String formattedValue;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/extractors/SqlValuesExtractor", "getOracleDateTimestamp"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/SqlValuesExtractor", "getOracleDateTimestamp"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/SqlValuesExtractor", "getOracleDateTimestamp"));
        }
        if (!dialect.getFamilyId().isOracle()) {
            return null;
        }
        Object value = column.getValue(row);
        if (!(value instanceof Timestamp)) {
            return null;
        }
        String function = "DATE".equals(column.typeName) ? "TO_DATE" : "TO_TIMESTAMP";
        SimpleDateFormat format = this.getFormatter().getTimestampFormat(column, dialect);
        try {
            formattedValue = format.format(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        String pattern = format.toPattern();
        String oraPattern = StringUtil.replace((String)pattern, (String[])new String[]{"yyyy", "dd", "HH", "mm", "ss"}, (String[])new String[]{"YYYY", "DD", "HH24", "MI", "SS"});
        int lastDotIdx = StringUtil.lastIndexOf((CharSequence)oraPattern, (char)'.', (int)0, (int)oraPattern.length());
        int n = fractionalSeconds = lastDotIdx != -1 ? oraPattern.length() - lastDotIdx - 1 : 0;
        if (fractionalSeconds > 0) {
            TextRange range = TextRange.create((int)lastDotIdx, (int)oraPattern.length());
            oraPattern = StringUtil.replaceSubstring((String)oraPattern, (TextRange)range, (String)(".FF" + fractionalSeconds));
        }
        return function + "('" + formattedValue + "', '" + oraPattern + "')";
    }

    protected class SqlExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected final DdlBuilder myDdlBuilder;

        public SqlExtractionBase(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dialect, forceSkipHeader, allColumns, selectedColumnIndices);
            this.myDdlBuilder = new DdlBuilder(this.myOutput).qualifyReferences(true).withDialect(dialect);
        }

        @Override
        protected void appendHeader(boolean appendNewLine) {
        }
    }
}

