/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DbNamespaceImpl
extends DbElementImpl<Object, DbElement>
implements DasNamespace {
    private final String myName;
    private final ObjectKind myKind;
    private final List<DasObject> myDelegates = ContainerUtil.newSmartList();

    DbNamespaceImpl(DbElement parent, String name, ObjectKind kind, Object delegate) {
        super(parent, delegate == null || delegate instanceof PsiElement ? DbDataSourceImpl.getNamespaceKey(name, kind, parent) : delegate);
        this.myName = name;
        this.myKind = kind;
    }

    @Override
    @NotNull
    public List<DasObject> getDelegates() {
        List<DasObject> list = this.myDelegates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbNamespaceImpl", "getDelegates"));
        }
        return list;
    }

    void addDelegate(DasObject o) {
        this.myDelegates.add(o);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbNamespaceImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.myKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbNamespaceImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    public Processor<DbElement> createDeclarationProcessor(final @NotNull PsiScopeProcessor processor, final @NotNull ResolveState state, final PsiElement lastParent, final @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbNamespaceImpl", "createDeclarationProcessor"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbNamespaceImpl", "createDeclarationProcessor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/psi/DbNamespaceImpl", "createDeclarationProcessor"));
        }
        return new Processor<DbElement>(){

            public boolean process(DbElement element) {
                if (lastParent == element) {
                    return true;
                }
                if (!processor.execute((PsiElement)element, state)) {
                    return false;
                }
                return !StringUtil.isEmpty((String)element.getName()) || element.processDeclarations(processor, state, lastParent, place);
            }
        };
    }
}

