/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPsiFacadeImpl
extends DbPsiFacade {
    private final Project myProject;
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final Map<DatabaseSystem, DbDataSource> myDataSourceMap = new WeakHashMap();
    private volatile State myState;
    private final Alarm myAlarm;

    public DbPsiFacadeImpl(Project project) {
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
    }

    public List<DbPsiManager> getDbManagers() {
        return this.getState().managers;
    }

    public void clearCaches(@Nullable DbDataSource selectedElement) {
        this.incModificationCount();
        if (selectedElement == null) {
            this.myState = null;
        } else {
            selectedElement.clearCaches();
        }
        PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ((ModificationTrackerListener)DbPsiFacadeImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)DbPsiFacadeImpl.this);
                DaemonCodeAnalyzer.getInstance((Project)DbPsiFacadeImpl.this.myProject).restart();
            }
        }, 300);
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<DbDataSource> getDataSources() {
        List<DbDataSource> list = this.getState().dataSources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getDataSources"));
        }
        return list;
    }

    @Nullable
    public DbDataSource findDataSource(String id) {
        return this.getState().dataSourcesMap.get(id);
    }

    public void addModificationTrackerListener(ModificationTrackerListener<DbPsiFacade> listener, Disposable parent) {
        this.myDispatcher.addListener(listener, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DbDataSource createDataSourceWrapperElement(@NotNull DatabaseSystem info, @NotNull DbPsiManagerSpi manager) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
        }
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        // MONITORENTER : map
        DbDataSource dataSource = this.myDataSourceMap.get(info);
        if (dataSource == null) {
            dataSource = new DbDataSourceImpl(this.getProject(), info, manager);
            this.myDataSourceMap.put(info, dataSource);
        }
        DbDataSource dbDataSource = dataSource;
        // MONITOREXIT : map
        if (dbDataSource != null) return dbDataSource;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State getState() {
        State state;
        State curState = this.myState;
        if (curState != null) {
            return curState;
        }
        if (this.myProject.isDefault()) {
            state = new State(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        } else {
            DbPsiManagerSpi[] managers = (DbPsiManagerSpi[])Extensions.getExtensions(DbPsiManagerSpi.EP_NAME, (AreaInstance)this.myProject);
            ArrayList result = ContainerUtil.newArrayList();
            for (DbPsiManagerSpi manager : managers) {
                result.addAll(manager.getDataSources());
            }
            state = new State(Arrays.asList(managers), result);
        }
        this.myState = state;
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        synchronized (map) {
            this.myDataSourceMap.values().retainAll(state.dataSources);
        }
        return state;
    }

    private static class State {
        final List<DbPsiManagerSpi> managers;
        final List<DbDataSource> dataSources;
        final Map<String, DbDataSource> dataSourcesMap;

        public State(List<DbPsiManagerSpi> spis, List<DbDataSource> array) {
            this.managers = spis;
            this.dataSources = array;
            this.dataSourcesMap = array.isEmpty() ? Collections.emptyMap() : new THashMap();
            for (DbDataSource element : array) {
                this.dataSourcesMap.put(element.getUniqueId(), element);
            }
        }
    }
}

