/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.autoconfig.JdbcDriversMappings;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManager;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDbPsiManager
extends BasicDbPsiManager<DataSource> {
    private static final DataSourceTemplate DEFAULT_TEMPLATE = new LocalDataSourceTemplate();
    private final DataSourceManagerEx myDataSourceManager;

    public DefaultDbPsiManager(DbPsiFacade dbFacade, DataSourceManager dataSourceManager) {
        super(dbFacade, dataSourceManager.getDataSources());
        this.myDataSourceManager = (DataSourceManagerEx)dataSourceManager;
        this.myDataSourceManager.addDataSourceListener(new DataSourceListener(){

            public void dataSourceAdded(@NotNull DataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager$1", "dataSourceAdded"));
                }
                DefaultDbPsiManager.this.getElementsMap().put(dataSource, ((DbPsiFacadeImpl)DefaultDbPsiManager.this.myDbFacade).createDataSourceWrapperElement((DatabaseSystem)dataSource, DefaultDbPsiManager.this));
                DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
            }

            public void dataSourceRemoved(@NotNull DataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager$1", "dataSourceRemoved"));
                }
                DefaultDbPsiManager.this.getElementsMap().remove(dataSource);
                DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
            }

            public void dataSourceChanged(DataSource dataSource) {
                if (dataSource == null) {
                    DefaultDbPsiManager.this.resetElementMap(DefaultDbPsiManager.this.myDataSourceManager.getDataSources());
                    DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
                } else {
                    DefaultDbPsiManager.this.myDbFacade.clearCaches(DefaultDbPsiManager.this.getElementsMap().get(dataSource));
                }
            }
        }, (Disposable)this.myDbFacade.getProject());
    }

    public void removeDataSource(DbDataSource element) {
        if (!(element.getDelegate() instanceof DataSource)) {
            throw new UnsupportedOperationException();
        }
        DataSource dataSource = (DataSource)element.getDelegate();
        this.processAddOrRemove(dataSource, false);
    }

    @Override
    public void setDataSourceName(@NotNull DbDataSource element, String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DefaultDbPsiManager", "setDataSourceName"));
        }
        if (!(element.getDelegate() instanceof DataSource)) {
            throw new UnsupportedOperationException();
        }
        DataSource dataSource = (DataSource)element.getDelegate();
        dataSource.setName(name);
        DataSourceManagerEx.getInstanceEx(element.getProject()).updateDataSource(dataSource);
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DefaultDbPsiManager", "getModificationTracker"));
        }
        ModificationTracker modificationTracker = (ModificationTracker)element.getDataSource().getDelegate();
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager", "getModificationTracker"));
        }
        return modificationTracker;
    }

    @NotNull
    public Configurable createDataSourceEditor(DbDataSource template) {
        LocalDataSource dataSource = (LocalDataSource)((Object)ObjectUtils.assertNotNull((Object)((Object)((LocalDataSource)((Object)template.getDelegate())))));
        DataSourceConfigurable dataSourceConfigurable = new DataSourceConfigurable(this, dataSource, template.getProject());
        if (dataSourceConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager", "createDataSourceEditor"));
        }
        return dataSourceConfigurable;
    }

    @NotNull
    public List<DataSourceTemplate> getDataSourceTemplates() {
        List<DataSourceTemplate> list = Collections.singletonList(DEFAULT_TEMPLATE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager", "getDataSourceTemplates"));
        }
        return list;
    }

    @Nullable
    public DataSourceTemplate getDataSourceTemplate(DbDataSource element) {
        Object delegate = element.getDelegate();
        return delegate instanceof LocalDataSource ? ((LocalDataSource)((Object)delegate)).getDatabaseDriver() : null;
    }

    public boolean canCreateDataSourceByFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files) {
        final ArrayList result = ContainerUtil.newArrayList();
        DataSourceRegistry registry = new DataSourceRegistry(this.myDbFacade.getProject());
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DatabaseSystem dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager$2", "onCreated"));
                }
                ContainerUtil.addIfNotNull((Collection)result, (Object)DefaultDbPsiManager.this.myDbFacade.findDataSource(dataSource.getUniqueId()));
            }
        };
        for (VirtualFile file : files) {
            String databaseName;
            JdbcDriversMappings.JdbcMapping jdbcMapping;
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType) || (jdbcMapping = JdbcDriversMappings.findMappingByDatabaseName(databaseName = ((DbStorageFileType)fileType).getDatabaseName())) == null) continue;
            String defaultName = DbUtil.createNewDataSourceName((Project)this.myDbFacade.getProject(), (String)file.getNameWithoutExtension());
            jdbcMapping.createDataSource(null, databaseName, defaultName, new FileBasedConfiguration(file), registry.getBuilder().onCreate(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myDbFacade.getProject(), registry, true);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager", "createDataSourceByFiles"));
        }
        return arrayList;
    }

    public void fireDataSourceUpdated(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DefaultDbPsiManager", "fireDataSourceUpdated"));
        }
        this.fireDataSourceUpdated((DataSource)element.getDelegate());
    }

    public void fireDataSourceUpdated(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager", "fireDataSourceUpdated"));
        }
        this.myDataSourceManager.updateDataSource(dataSource);
    }

    public void processAddOrRemove(final @NotNull DataSource dataSource, final boolean added) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager", "processAddOrRemove"));
        }
        Project project = this.myDbFacade.getProject();
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                if (added) {
                    DefaultDbPsiManager.this.myDataSourceManager.removeDataSource(dataSource);
                } else {
                    DefaultDbPsiManager.this.myDataSourceManager.addDataSource(dataSource);
                }
            }

            public void redo() throws UnexpectedUndoException {
                if (added) {
                    DefaultDbPsiManager.this.myDataSourceManager.addDataSource(dataSource);
                } else {
                    DefaultDbPsiManager.this.myDataSourceManager.removeDataSource(dataSource);
                }
            }
        };
        new WriteCommandAction(project, added ? DatabaseMessages.message((String)"command.name.add.data.source", (Object[])new Object[0]) : DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0]), new PsiFile[0], (UndoableAction)action, project){
            final /* synthetic */ UndoableAction val$action;
            final /* synthetic */ Project val$project;
            {
                this.val$action = undoableAction;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/psi/DefaultDbPsiManager$4", "run"));
                }
                this.val$action.redo();
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }
        }.execute();
    }

    @Override
    public DatabaseDialectEx getDatabaseDialect(@NotNull DbDataSource element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DefaultDbPsiManager", "getDatabaseDialect"));
        }
        Object delegate = element.getDelegate();
        return delegate instanceof RawConnectionConfig ? DbImplUtil.guessDatabaseDialect((RawConnectionConfig)delegate) : null;
    }

    @Override
    public void addDataSource(@NotNull DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager", "addDataSource"));
        }
        this.processAddOrRemove(dataSource, true);
    }

    public static boolean isDefaultTemplate(@NotNull DataSourceTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/psi/DefaultDbPsiManager", "isDefaultTemplate"));
        }
        return DEFAULT_TEMPLATE == template;
    }

    private static class LocalDataSourceTemplate
    implements DataSourceTemplate {
        private LocalDataSourceTemplate() {
        }

        @NotNull
        public String getName() {
            if ("Data Source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate", "getName"));
            }
            return "Data Source";
        }

        @NotNull
        public String getFullName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate", "getFullName"));
            }
            return string;
        }

        @NotNull
        public List<DataSourceTemplate> getSubConfigurations() {
            ArrayList arrayList = ContainerUtil.newArrayList(DatabaseDriverManager.getInstance().getDrivers());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate", "getSubConfigurations"));
            }
            return arrayList;
        }

        @NotNull
        public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate", "createDataSource"));
            }
            throw new UnsupportedOperationException("Abstract DataSource creation not supported");
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return DatabaseIcons.Dbms;
        }
    }

    private static class FileBasedConfiguration
    implements DataSourceConfiguration {
        private final VirtualFile myFile;

        public FileBasedConfiguration(VirtualFile file) {
            this.myFile = file;
        }

        @Override
        @Nullable
        public String getDatabase() {
            return VfsUtil.virtualToIoFile((VirtualFile)this.myFile).getAbsolutePath();
        }

        @Override
        @Nullable
        public String getHost() {
            return null;
        }

        @Override
        @Nullable
        public String getPort() {
            return null;
        }

        @Override
        @Nullable
        public String getUserName() {
            return null;
        }

        @Override
        @Nullable
        public String getPassword() {
            return null;
        }

        @Override
        @Nullable
        public String getOption(String name) {
            return null;
        }

        @Override
        @Nullable
        public VirtualFile getApplicationRoot() {
            return null;
        }
    }
}

