/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.MeasuringDataAuditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.ConsumerRunnable;

public class ConsoleDataAuditor
extends MeasuringDataAuditor {
    private final AbstractQueryLanguageConsole<?> myConsole;

    public ConsoleDataAuditor(AbstractQueryLanguageConsole<?> console) {
        this.myConsole = console;
        this.myConsole.getMessageBus().addAuditor(this);
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "requestStarted"));
        }
        super.requestStarted(context);
        this.myConsole.setCurrentTx(context.txMarker);
        this.myConsole.updateConsoleOnRequestStarted(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onStarted();
        }
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "requestFinished"));
        }
        super.requestFinished(context);
        this.myConsole.updateConsoleOnRequestFinished(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onFinished();
        }
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "txCompleted"));
        }
        super.txCompleted(context, commit);
        this.myConsole.setCurrentTx(DataRequest.START_NEW);
    }

    @Override
    public void print(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "print"));
        }
        this.myConsole.getHistoryLogger().print(context, message);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "error"));
        }
        super.error(context, message, th);
        this.myConsole.getHistoryLogger().error(context, message, th);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onError(message, th);
        }
        this.bringAttentionToOutput(context, true);
    }

    @Override
    protected void bringAttentionToOutput(final DataRequest.Context context, final boolean isError) {
        DbUIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ConsoleDataAuditor.this.myConsole.isValid()) {
                    return;
                }
                final ConsoleDataRequest cr = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
                final boolean wasShowing = ConsoleDataAuditor.this.myConsole.getUi().getComponent().isShowing();
                ConsumerRunnable runnable = new ConsumerRunnable(){

                    public void run() {
                        if (!ConsoleDataAuditor.this.myConsole.isValid()) {
                            return;
                        }
                        Content content = ConsoleDataAuditor.this.myConsole.getOutputContent();
                        if (content != null) {
                            boolean focus;
                            ConsoleDataAuditor.this.myConsole.getUi().setBouncing(content, true);
                            boolean bl = focus = !wasShowing || isError && cr == null || !isError && (cr == null || !(cr.resultType instanceof SqlTableType));
                            if (focus) {
                                ConsoleDataAuditor.this.myConsole.getUi().selectAndFocus(content, false, false);
                                ConsoleDataAuditor.this.myConsole.getHistoryLogger().scrollToEnd();
                            }
                        }
                    }
                };
                if (!(cr == null || cr.queryIndex != 0 && cr.hasNext)) {
                    ConsoleDataAuditor.this.myConsole.showConsole(true, false).done((Consumer)runnable);
                } else {
                    runnable.run();
                }
            }
        });
    }
}

