/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import icons.DatabaseIcons;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.Nullable;

public class AddRowAction
extends DumbAwareAction
implements GridAction {
    public AddRowAction() {
        super(null, null, DatabaseIcons.AddRow);
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean visible = dataGrid != null && dataGrid.isEditable();
        boolean bl = enabled = visible && AddRowAction.canAddRow(dataGrid);
        if (enabled && dataGrid.isEditing()) {
            enabled = !(e.getInputEvent() instanceof KeyEvent);
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.insertRow();
            DataGridUtil.focusDataGrid(e.getDataContext());
        }
    }

    public static boolean canAddRow(final @Nullable DataGrid dataGrid) {
        boolean canAddRow = dataGrid != null && dataGrid.isEditable() && dataGrid.isReady() && dataGrid.isRowsMutationSupported() && dataGrid.getDataModel().getColumnCount() != 0;
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        if (canAddRow && table != null) {
            return DasUtil.getColumns((DasObject)table).filter((Condition)new Condition<DasColumn>(){

                public boolean value(DasColumn columnInfo) {
                    return !DataGridUtil.findColumn(dataGrid, columnInfo.getName()).isValid(dataGrid) && !DasUtil.isAutoVal((DasColumn)columnInfo) && columnInfo.getDefault() == null && columnInfo.isNotNull();
                }
            }).isEmpty();
        }
        return canAddRow;
    }
}

