/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.diff.TableDiffTool;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ConsoleDataConsumer;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithGroup
extends ActionGroup {
    private static final AnAction[] EMPTY_ARRAY = new AnAction[]{new AnAction("Nothing to compare with"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }};

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/CompareWithGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Pair<String, GridDataHookUpManager.HookUpHandle> current = CompareWithGroup.getCurrentHookUp(e.getDataContext());
        if (current == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/CompareWithGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        CompareWithGroup.appendConsoles(result, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        CompareWithGroup.appendEditors(result, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        AnAction[] anActionArray = result.isEmpty() ? EMPTY_ARRAY : result.toArray(new AnAction[result.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/CompareWithGroup", "getChildren"));
        }
        return anActionArray;
    }

    private static void appendConsoles(@NotNull List<AnAction> result, @NotNull DataContext ctx, @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/run/actions/CompareWithGroup", "appendConsoles"));
        }
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/database/run/actions/CompareWithGroup", "appendConsoles"));
        }
        if (curName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curName", "com/intellij/database/run/actions/CompareWithGroup", "appendConsoles"));
        }
        if (curHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curHandle", "com/intellij/database/run/actions/CompareWithGroup", "appendConsoles"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        if (project == null) {
            return;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            for (Content content : console.getUi().getContents()) {
                GridDataHookUpManager.HookUpHandle handle;
                DataGrid grid = ConsoleDataConsumer.getDataGrid(content);
                if (grid == null || (handle = hookUpManager.getHandle(grid.getDataHookup())).equals(curHandle)) continue;
                result.add((AnAction)new MyDiffAction(curName, content.getTabName(), curHandle, handle));
            }
        }
    }

    private static void appendEditors(@NotNull List<AnAction> result, @NotNull DataContext ctx, @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/run/actions/CompareWithGroup", "appendEditors"));
        }
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/database/run/actions/CompareWithGroup", "appendEditors"));
        }
        if (curName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curName", "com/intellij/database/run/actions/CompareWithGroup", "appendEditors"));
        }
        if (curHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curHandle", "com/intellij/database/run/actions/CompareWithGroup", "appendEditors"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        if (project == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        for (FileEditor editor : editorManager.getAllEditors()) {
            GridDataHookUpManager.HookUpHandle handle;
            TableEditorBase tableEditor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editor, TableEditorBase.class));
            if (tableEditor == null || (handle = hookUpManager.getHandle(tableEditor.getDataGrid().getDataHookup())).equals(curHandle)) continue;
            result.add((AnAction)new MyDiffAction(curName, CompareWithGroup.getEditorTitle(tableEditor), curHandle, handle));
        }
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/database/run/actions/CompareWithGroup", "getCurrentHookUp"));
        }
        return (Pair)ObjectUtils.chooseNotNull(CompareWithGroup.getCurrentConsoleHookUp(ctx), CompareWithGroup.getCurrentEditorHookUp(ctx));
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentConsoleHookUp(@NotNull DataContext ctx) {
        DataGrid currentGrid;
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/database/run/actions/CompareWithGroup", "getCurrentConsoleHookUp"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext((DataContext)ctx, (boolean)false);
        if (contentManager == null || project == null) {
            return null;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        Content currentContent = contentManager.getSelectedContent();
        DataGrid dataGrid = currentGrid = currentContent != null ? ConsoleDataConsumer.getDataGrid(currentContent) : null;
        if (currentGrid == null) {
            return null;
        }
        return Pair.create((Object)currentContent.getTabName(), (Object)hookUpManager.getHandle(currentGrid.getDataHookup()));
    }

    @Nullable
    private static Pair<String, GridDataHookUpManager.HookUpHandle> getCurrentEditorHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/database/run/actions/CompareWithGroup", "getCurrentEditorHookUp"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(ctx);
        if (project == null || file == null) {
            return null;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance(project);
        TableEditorBase editor = (TableEditorBase)((Object)ObjectUtils.tryCast((Object)editorManager.getSelectedEditor(file), TableEditorBase.class));
        if (editor == null) {
            return null;
        }
        return Pair.create((Object)CompareWithGroup.getEditorTitle(editor), (Object)hookUpManager.getHandle(editor.getDataGrid().getDataHookup()));
    }

    private static String getEditorTitle(@NotNull TableEditorBase editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/actions/CompareWithGroup", "getEditorTitle"));
        }
        String name = "";
        if (editor instanceof DatabaseTableFileEditor) {
            name = ((DatabaseTableFileEditor)editor).getFile().getPresentableName();
        } else if (editor instanceof CsvTableFileEditor) {
            name = ((CsvTableFileEditor)editor).getFile().getPresentableName();
        }
        return name;
    }

    private static class MyDiffAction
    extends DumbAwareAction {
        private final String myName1;
        private final String myName2;
        GridDataHookUpManager.HookUpHandle myHandle1;
        GridDataHookUpManager.HookUpHandle myHandle2;

        public MyDiffAction(@NotNull String name1, @NotNull String name2, @NotNull GridDataHookUpManager.HookUpHandle handle1, @NotNull GridDataHookUpManager.HookUpHandle handle2) {
            if (name1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name1", "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction", "<init>"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name2", "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction", "<init>"));
            }
            if (handle1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle1", "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction", "<init>"));
            }
            if (handle2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle2", "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction", "<init>"));
            }
            super(name2);
            this.myName1 = name1;
            this.myName2 = name2;
            this.myHandle1 = handle1;
            this.myHandle2 = handle2;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            SimpleDiffRequest dr = new SimpleDiffRequest(this.myName1 + " vs " + this.myName2, (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle1, project), (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle2, project), this.myName1, this.myName2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }
    }
}

