/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.IdentityDataProducer;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.extractors.ui.ChooseExtractorForm;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseExtractorAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.ConsumerRunnable;

public abstract class DumpAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "update"));
        }
        Project project = e.getProject();
        Object dumpTarget = DumpAction.getDumpTarget(e);
        e.getPresentation().setEnabled(project != null && dumpTarget != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "actionPerformed"));
        }
        Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
        Object target = ObjectUtils.assertNotNull((Object)DumpAction.getDumpTarget(e));
        this.createHandler(project, target).performDump(e.getDataContext());
    }

    @Nullable
    private static Object getDumpTarget(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/DumpAction", "getDumpTarget"));
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() && !dataGrid.isEditing() ? dataGrid : null;
        }
        JdbcConsole console = JdbcConsole.getConsole(e);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (console != null && editor != null && DumpAction.getQueryText(console) != null) {
            return console;
        }
        Set<DbTable> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbTable.class);
        DbTable table = selection.size() == 1 ? (DbTable)ContainerUtil.getFirstItem(selection) : null;
        return table != null && DbImplUtil.canConnectTo((DbElement)table) ? table : null;
    }

    @Nullable
    private static String getQueryText(@Nullable JdbcConsole console) {
        TextRange r;
        if (console == null) {
            return null;
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console);
        ScriptModel.StatementIt sit = console.getScriptModel().subModel(range, false).statements();
        if (sit.advance() && (r = sit.range()).equals((Object)range)) {
            return sit.text(console.getPStorage(), Conditions.alwaysFalse());
        }
        return range.subSequence((CharSequence)console.getLanguageConsole().getEditorDocument().getText()).toString();
    }

    @NotNull
    protected abstract Handler createHandler(@NotNull Project var1, @NotNull Object var2);

    private static String getTargetDisplayName(Object target) {
        return target instanceof DataGrid ? ((DataGrid)target).getDisplayName() : (target instanceof JdbcConsole ? ((JdbcConsole)target).getDisplayName() : "'" + ((DbTable)target).getName() + "' data ");
    }

    public static class FileGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Object target = DumpAction.getDumpTarget(e);
            e.getPresentation().setEnabledAndVisible(target != null);
            if (target instanceof JdbcConsole) {
                e.getPresentation().setText("Execute to File");
                e.getPresentation().setIcon(AllIcons.Actions.Execute);
            } else {
                e.getPresentation().setText(this.getTemplatePresentation().getTextWithMnemonic(), true);
                e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
            }
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ChooseExtractorAction.ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)new Function<DataExtractorFactory, AnAction>(){

                public AnAction fun(DataExtractorFactory factory) {
                    return new ToFileWithCopyAction(factory);
                }
            });
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup", "getChildren"));
            }
            return anActionArray;
        }

        private static class ToFileWithCopyAction
        extends ToFile {
            private final DataExtractorFactory myExtractorFactory;

            public ToFileWithCopyAction(@NotNull DataExtractorFactory factory) {
                if (factory == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "<init>"));
                }
                this.myExtractorFactory = factory;
                this.getTemplatePresentation().setText(factory.getName());
            }

            @Override
            @NotNull
            protected Handler createHandler(@NotNull Project project, @NotNull Object target) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "createHandler"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "createHandler"));
                }
                FileHandler fileHandler = new FileHandler(project, target){

                    @Override
                    @Nullable
                    public DataExtractor createExtractor(@NotNull DataContext context) {
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction$1", "createExtractor"));
                        }
                        DataExtractor extractor = myExtractorFactory.createExtractor(context);
                        return extractor != null && this.chooseFileToDumpTo(extractor.getFileExtension()) ? extractor : null;
                    }
                };
                if (fileHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$FileGroup$ToFileWithCopyAction", "createHandler"));
                }
                return fileHandler;
            }
        }
    }

    private static class DumpRequest
    extends DataRequest.IsolatedQueryRequest {
        final ModelIndexSet<DataConsumer.Column> mySelectedColumns;
        final DataExtractor myExtractor;
        final DatabaseDialectEx myDialect;
        final CharOut myOutput;
        final ProgressIndicator myProgressIndicator;
        int myMaxRow;
        int myFirstRowNum;
        DataExtractor.Extraction myExtraction;

        protected DumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, String query, DataRequest.Constraints constraints, ModelIndexSet<DataConsumer.Column> columns, DataExtractor extractor, DatabaseDialectEx dialect, CharOut output) {
            super(owner, txMarker, query, constraints, null);
            this.mySelectedColumns = columns;
            this.myExtractor = extractor;
            this.myDialect = dialect;
            this.myOutput = output;
            this.myProgressIndicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$DumpRequest", "setColumns"));
            }
            AbstractQueryLanguageConsole.LOG.assertTrue(resultSetIndex == this.constraints.resultSetNumber);
            this.myFirstRowNum = firstRowNum;
            this.myExtraction = this.myExtractor.startExtraction(this.myOutput, this.myDialect, false, ContainerUtil.list((Object[])columns), this.mySelectedColumns != null ? this.mySelectedColumns.asArray() : ArrayUtil.EMPTY_INT_ARRAY);
            this.myProgressIndicator.setText("Saving...");
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$DumpRequest", "addRows"));
            }
            this.myProgressIndicator.checkCanceled();
            if (rows.isEmpty()) {
                return;
            }
            this.myMaxRow = rows.get((int)(rows.size() - 1)).rowNum;
            if (rows.get((int)0).rowNum > this.myFirstRowNum && this.myExtractor instanceof DefaultValuesExtractor && !(this.myExtractor instanceof FormatBasedExtractor)) {
                this.myOutput.append(((DefaultValuesExtractor)this.myExtractor).getLineSeparator());
            }
            this.myExtraction.addData(rows);
            this.myProgressIndicator.setText("Saving... " + this.myMaxRow + " rows / " + ExtractorsUtil.getPresentableSize(this.myOutput.length()) + " chars loaded");
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$DumpRequest", "afterLastRowAdded"));
            }
            this.myExtraction.complete();
        }
    }

    private static abstract class Handler {
        final Project myProject;
        final DbTable myTable;
        final DataGrid myGrid;
        final String myQueryText;
        final DatabaseDialectEx myDialect;
        final ModelIndexSet<DataConsumer.Column> mySelectedColumns;
        final String myTitle;
        final int myResultSetIndex;
        final NotNullFunction<DataExtractor, DataRequest> myRunner;
        CharOut myOutput;
        ProgressIndicator myProgressIndicator;

        Handler(@NotNull Project project, @NotNull String title, @NotNull Object target) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            this.myProject = project;
            this.myTitle = title;
            this.myTable = (DbTable)ObjectUtils.tryCast((Object)target, DbTable.class);
            this.myGrid = (DataGrid)ObjectUtils.tryCast((Object)target, DataGrid.class);
            if (this.myGrid != null) {
                this.myDialect = DataGridUtil.getDatabaseDialect(this.myGrid);
                this.myResultSetIndex = DataGridUtil.getResultSetIndex(this.myGrid);
                this.mySelectedColumns = this.myGrid.getVisibleColumns();
                DataProducer producer = null;
                DataRequest.Owner owner = DataRequest.newOwner();
                GridPagingModel pageModel = this.myGrid.getDataHookup().getPageModel();
                if (pageModel.isFirstPage() && pageModel.isLastPage()) {
                    producer = new IdentityDataProducer(new DataConsumer.Composite(new DataConsumer[0]), this.myGrid.getDataModel().getColumns(), ContainerUtil.newArrayList(this.myGrid.getDataModel().getRows()), this.myResultSetIndex);
                    this.myQueryText = StringUtil.notNullize((String)DataGridUtil.getQueryText(this.myGrid));
                } else {
                    DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(this.myGrid);
                    if (hookUp != null) {
                        owner = hookUp;
                        producer = hookUp.getMessageBus().getDataProducer();
                    }
                    this.myQueryText = DataGridUtil.getQueryText(this.myGrid);
                }
                this.myRunner = producer != null ? this.newSimpleRunner(producer, owner) : null;
            } else if (this.myTable != null) {
                this.myResultSetIndex = 1;
                this.myDialect = DbImplUtil.getDatabaseDialect((DbElement)this.myTable);
                this.myQueryText = DbImplUtil.createSelectAllQuery((DasTable)this.myTable, this.myDialect).getStatement();
                this.mySelectedColumns = null;
                LocalDataSource dataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)this.myTable.getDataSource());
                this.myRunner = this.newEngineRunner(dataSource);
            } else if (target instanceof JdbcConsole) {
                JdbcConsole console = (JdbcConsole)target;
                this.myResultSetIndex = 1;
                this.myQueryText = (String)ObjectUtils.assertNotNull((Object)DumpAction.getQueryText(console));
                this.mySelectedColumns = null;
                this.myRunner = this.newSimpleRunner(console.getMessageBus().getDataProducer(), console);
                LocalDataSource dataSource = console.getDataSource();
                this.myDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(dataSource), (Object)GenericDialect.INSTANCE);
            } else {
                throw new AssertionError();
            }
        }

        Handler(@NotNull Project project, @NotNull String query, @NotNull DatabaseDialectEx dialect, int resultSetIndex, @NotNull DataProducer producer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/run/actions/DumpAction$Handler", "<init>"));
            }
            this.myProject = project;
            this.myTitle = query;
            this.myTable = null;
            this.myGrid = null;
            this.myQueryText = query;
            this.myDialect = dialect;
            this.myResultSetIndex = resultSetIndex;
            this.mySelectedColumns = null;
            this.myRunner = this.newSimpleRunner(producer, DataRequest.newOwner());
        }

        private NotNullFunction<DataExtractor, DataRequest> newSimpleRunner(final DataProducer producer, final DataRequest.Owner owner) {
            return new NotNullFunction<DataExtractor, DataRequest>(){

                @NotNull
                public DataRequest fun(DataExtractor extractor) {
                    DataRequest.TxMarker txMarker = owner instanceof DataRequest.OwnerEx ? ((DataRequest.OwnerEx)owner).getCurrentTx() : DataRequest.NONE;
                    DataRequest request = this.createDumpRequest(owner, txMarker, extractor);
                    producer.processRequest(request);
                    DataRequest dataRequest = request;
                    if (dataRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$Handler$1", "fun"));
                    }
                    return dataRequest;
                }
            };
        }

        private NotNullFunction<DataExtractor, DataRequest> newEngineRunner(final LocalDataSource dataSource) {
            return new NotNullFunction<DataExtractor, DataRequest>(){

                @NotNull
                public DataRequest fun(DataExtractor extractor) {
                    final DataRequest.OwnerEx owner = DataRequest.newOwnerEx(myProject);
                    JdbcEngine engine = new JdbcEngine(myProject, DataBus.shortCircuit(owner.getMessageBus()), dataSource, null);
                    Disposer.register((Disposable)owner, (Disposable)engine);
                    DataRequest request = this.createDumpRequest(owner, DataRequest.AUTO_COMMIT, extractor);
                    request.getPromise().processed((Consumer)new ConsumerRunnable(){

                        public void run() {
                            Disposer.dispose((Disposable)owner);
                        }
                    });
                    owner.getMessageBus().getDataProducer().processRequest(request);
                    DataRequest dataRequest = request;
                    if (dataRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$Handler$2", "fun"));
                    }
                    return dataRequest;
                }
            };
        }

        @Nullable
        DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$Handler", "createExtractor"));
            }
            return DataExtractorProperties.getCurrentExtractorFactory((Project)CommonDataKeys.PROJECT.getData(context)).createExtractor(context);
        }

        void processError(@Nullable String message, @Nullable Throwable th) {
            String text = message != null ? message : (th != null ? ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)DataSourceUiUtil.LOG) : null);
            DataSourceUiUtil.showNotification(this.myProject, this.myTitle, text, true);
        }

        public void performDump(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$Handler", "performDump"));
            }
            if (this.myRunner == null || this.myQueryText == null) {
                return;
            }
            DataExtractor extractor = this.createExtractor(context);
            if (extractor != null) {
                ProgressManager.getInstance().run((Task)this.buildTask(extractor));
            }
        }

        @NotNull
        public Task.Backgroundable buildTask(final @NotNull DataExtractor extractor) {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/run/actions/DumpAction$Handler", "buildTask"));
            }
            Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, this.myTitle){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/run/actions/DumpAction$Handler$3", "run"));
                    }
                    myProgressIndicator = indicator;
                    indicator.setText("Initializing output...");
                    indicator.setIndeterminate(true);
                    final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
                    try {
                        myOutput = this.createOutput();
                        indicator.setText("Running query...");
                        ((DataRequest)myRunner.fun((Object)extractor)).getPromise().processed((Consumer)new ConsumerRunnable(){

                            public void run() {
                                result.set((Object)true);
                            }
                        });
                        result.get();
                        return;
                    }
                    catch (Exception ex) {
                        this.processError(null, ex);
                        return;
                    }
                    finally {
                        if (myOutput != null) {
                            try {
                                this.destroyOutput(extractor);
                            }
                            catch (Exception ex) {
                                this.processError(null, ex);
                            }
                            finally {
                                myOutput = null;
                            }
                        }
                    }
                }
            };
            if (backgroundable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$Handler", "buildTask"));
            }
            return backgroundable;
        }

        @NotNull
        DataRequest createDumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, DataExtractor extractor) {
            DumpRequest dumpRequest = new DumpRequest(owner, txMarker, this.myQueryText, DataRequest.newConstraints(0, -1, this.myResultSetIndex), this.mySelectedColumns, extractor, this.myDialect, this.myOutput);
            if (dumpRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$Handler", "createDumpRequest"));
            }
            return dumpRequest;
        }

        abstract void destroyOutput(@NotNull DataExtractor var1) throws Exception;

        abstract CharOut createOutput() throws Exception;
    }

    public static class FileHandler
    extends Handler {
        File myFile;
        BufferedWriter myWriter;

        FileHandler(@NotNull Project project, @NotNull Object target) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            super(project, "Save " + DumpAction.getTargetDisplayName(target) + " to file", target);
        }

        public FileHandler(@NotNull Project project, int resultSetIndex, @NotNull File file, @NotNull DatabaseDialectEx dialect, @NotNull DataProducer producer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/run/actions/DumpAction$FileHandler", "<init>"));
            }
            super(project, file.getName(), dialect, resultSetIndex, producer);
            this.myFile = file;
        }

        @Override
        CharOut createOutput() throws Exception {
            this.myWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), CharsetToolkit.UTF8_CHARSET));
            return CharOut.Util.newSink(this.myWriter);
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/actions/DumpAction$FileHandler", "createExtractor"));
            }
            DataExtractorFactory extractorFactory = ChooseExtractorForm.chooseExtractorFactory(this.myProject, this.myGrid);
            DataExtractor extractor = extractorFactory != null ? extractorFactory.createExtractor(context) : null;
            return extractor != null && this.chooseFileToDumpTo(extractor.getFileExtension()) ? extractor : null;
        }

        protected boolean chooseFileToDumpTo(@NotNull String fileExtension) {
            String tableOrQuery;
            String defaultFileName;
            if (fileExtension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/intellij/database/run/actions/DumpAction$FileHandler", "chooseFileToDumpTo"));
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Data To File", "Save all table data to file", new String[0]);
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
            VirtualFileWrapper wrapper = dialog.save(null, defaultFileName = FileUtil.sanitizeFileName((String)(tableOrQuery = this.myTable == null ? this.myQueryText.substring(0, Math.min(40, this.myQueryText.length())) : QNameUtil.getQualifiedName((DbElement)this.myTable))) + "." + fileExtension);
            if (wrapper == null) {
                return false;
            }
            VirtualFile virtualFile = wrapper.getVirtualFile(true);
            if (virtualFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])new VirtualFile[]{virtualFile})) {
                String message = "Cannot write file: " + wrapper.getFile().getPath();
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, MessageType.WARNING).notify(this.myProject);
                return false;
            }
            this.myFile = wrapper.getFile();
            return true;
        }

        @Override
        void destroyOutput(@NotNull DataExtractor extractor) throws Exception {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/run/actions/DumpAction$FileHandler", "destroyOutput"));
            }
            try {
                this.myWriter.close();
            }
            finally {
                this.myWriter = null;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }
    }

    public static class ClipboardHandler
    extends Handler {
        public ClipboardHandler(@NotNull Project project, @NotNull Object target) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$ClipboardHandler", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$ClipboardHandler", "<init>"));
            }
            super(project, "Copy " + DumpAction.getTargetDisplayName(target) + " to clipboard", target);
        }

        @Override
        CharOut createOutput() {
            return CharOut.Util.newSink();
        }

        @Override
        void destroyOutput(@NotNull DataExtractor extractor) {
            if (extractor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/run/actions/DumpAction$ClipboardHandler", "destroyOutput"));
            }
            String data = this.myOutput.toString();
            this.myOutput = null;
            boolean htmlNeeded = extractor.getFileExtension().contains("htm");
            Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((Transferable)content){
                final /* synthetic */ Transferable val$content;
                {
                    this.val$content = transferable;
                }

                @Override
                public void run() {
                    CopyPasteManager.getInstance().setContents(this.val$content);
                }
            });
        }
    }

    public static class ToFile
    extends DumpAction {
        @Override
        @NotNull
        protected Handler createHandler(@NotNull Project project, @NotNull Object target) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$ToFile", "createHandler"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$ToFile", "createHandler"));
            }
            FileHandler fileHandler = new FileHandler(project, target);
            if (fileHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToFile", "createHandler"));
            }
            return fileHandler;
        }
    }

    public static class ToClipboard
    extends DumpAction {
        @Override
        @NotNull
        protected ClipboardHandler createHandler(@NotNull Project project, @NotNull Object target) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHandler"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHandler"));
            }
            ClipboardHandler clipboardHandler = new ClipboardHandler(project, target);
            if (clipboardHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DumpAction$ToClipboard", "createHandler"));
            }
            return clipboardHandler;
        }
    }
}

