/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ParametersPanel
extends JPanel {
    private final Project myProject;
    private final DialogBuilder myDialog;
    private final ScriptModel<?> myScriptModel;
    private final ScriptModel.PStorage myStorage;
    private final JBTable myTable;
    private final ListTableModel<Object> myTableModel;
    private final EditorTextField myValueField;
    private int myMaxParamNameLength;
    private SimpleTextAttributes myParamAttrs;

    protected ParametersPanel(Project project, ScriptModel<?> scriptModel, ScriptModel.PStorage storage, Disposable parent) {
        super(new BorderLayout());
        this.myProject = project;
        this.myScriptModel = scriptModel;
        this.myStorage = storage;
        this.myDialog = parent instanceof DialogBuilder ? (DialogBuilder)parent : null;
        this.myTableModel = new ListTableModel(this.createColumnInfos());
        this.myValueField = new EditorTextField("", this.myProject, (FileType)SqlLanguage.getInstance().getAssociatedFileType());
        this.myTable = new TableView(this.myTableModel);
        this.myTable.setTableHeader(null);
        this.myTable.setRowSelectionAllowed(false);
        this.myTable.setSelectionMode(0);
        this.myTable.setShowGrid(true);
        this.myTable.setStriped(true);
        this.myTable.setExpandableItemsEnabled(false);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (ParametersPanel.this.myTable.isEditing()) {
                    TableUtil.stopEditing((JTable)ParametersPanel.this.myTable);
                } else {
                    TableUtil.editCellAt((JTable)ParametersPanel.this.myTable, (int)ParametersPanel.this.myTable.getSelectedRow(), (int)ParametersPanel.this.myTable.getSelectedColumn());
                }
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("Console.TableResult.EditValue").getShortcutSet(), (JComponent)this.myTable);
        this.updateColorScheme();
        EditorColorsManager.getInstance().addEditorColorsListener(new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                ParametersPanel.this.updateColorScheme();
            }
        }, parent);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ParametersPanel.this.amITheFocusOwner()) {
                    Object o;
                    int row = ParametersPanel.this.myTable.getSelectedRow();
                    Object object = o = row < 0 ? null : ParametersPanel.this.myTableModel.getItem(row);
                    if (o == null) {
                        ParametersPanel.this.selectRanges((Iterable<TextRange>)JBIterable.empty());
                    } else if (o instanceof PObject) {
                        String name = ((PObject)o).name;
                        ArrayList result = ContainerUtil.newArrayList();
                        for (ScriptModel.ParamIt it : ParametersPanel.this.myScriptModel.parameters().asCursor()) {
                            it.next();
                            if (!Comparing.equal((String)name, (String)it.name())) continue;
                            result.add(it.range());
                        }
                        ParametersPanel.this.selectRanges(result);
                    }
                }
            }
        });
        this.myTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ParametersPanel.this.myProject.isDisposed()) {
                    return;
                }
                if (!ParametersPanel.this.amITheFocusOwner()) {
                    ParametersPanel.this.selectRanges((Iterable<TextRange>)JBIterable.empty());
                }
            }
        });
        if (this.myDialog != null) {
            ListSelectionListener selectionListener = new ListSelectionListener(){
                int prevIdx = -1;

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ListSelectionModel rowModel = ParametersPanel.this.myTable.getSelectionModel();
                    int selection = rowModel.getMaxSelectionIndex();
                    int rowCount = ParametersPanel.this.myTable.getModel().getRowCount();
                    int idx = -1;
                    if (!(selection <= -1 || ParametersPanel.this.myTable.isCellEditable(selection, 1) || (idx = selection + (selection < this.prevIdx ? -1 : 1)) >= 0 && idx <= rowCount)) {
                        idx = this.prevIdx;
                    }
                    if (idx >= 0 && idx < rowCount) {
                        rowModel.addSelectionInterval(idx, idx);
                        this.prevIdx = idx;
                    } else {
                        this.prevIdx = selection;
                    }
                }
            };
            this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
            this.onModelUpdated();
        }
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable), "Center");
    }

    private void updateColorScheme() {
        TextAttributes attributes;
        Color fColor;
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font font = colorsScheme.getFont(EditorFontType.PLAIN);
        this.myTable.setFont(font);
        this.myValueField.setFont(font);
        Color bColor = colorsScheme.getColor(DatabaseColors.GRID_SELECTION_BACKGROUND);
        if (bColor != null) {
            this.myTable.setSelectionBackground(bColor);
        }
        if ((fColor = colorsScheme.getColor(DatabaseColors.GRID_SELECTION_FOREGROUND)) != null) {
            this.myTable.setSelectionForeground(fColor);
        }
        this.myParamAttrs = (attributes = colorsScheme.getAttributes(DatabaseColors.CONSOLE_PARAMETER)) == null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes);
    }

    public static boolean hasUnassignedParameters(ScriptModel<?> model, ScriptModel.PStorage storage) {
        for (ScriptModel.StatementIt sit : model.statements().asCursor()) {
            for (ScriptModel.ParamIt pit : sit.parameters().asCursor()) {
                if (!ParametersPanel.isParameterUnassigned(pit.name(), storage)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParameterUnassigned(String name, ScriptModel.PStorage storage) {
        return storage.getValue((Object)name) == null;
    }

    public static boolean ensureAllParametersAreSet(Project project, String title, ScriptModel<?> model, ScriptModel.PStorage storage) {
        final DialogBuilder builder = new DialogBuilder(project);
        builder.setTitle(title);
        builder.addOkAction();
        builder.addCancelAction();
        builder.setOkActionEnabled(false);
        builder.setDimensionServiceKey("com.intellij.database.run.ParametersPanel.Standalone");
        final ParametersPanel paramPanel = new ParametersPanel(project, model, storage, (Disposable)builder);
        JPanel panel = new JPanel(new BorderLayout(10, 4));
        panel.add((Component)paramPanel, "Center");
        builder.setCenterPanel((JComponent)panel);
        builder.setOkOperation(new Runnable(){

            @Override
            public void run() {
                paramPanel.commit();
                builder.getDialogWrapper().close(0);
            }
        });
        builder.getOkAction().setText(BundleBase.replaceMnemonicAmpersand((String)"E&xecute"));
        builder.getCancelAction().setText(CommonBundle.getCloseButtonText());
        builder.setPreferredFocusComponent((JComponent)paramPanel.myTable);
        paramPanel.myTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                paramPanel.myTable.changeSelection(0, 1, false, false);
                paramPanel.parameterValueSet(null);
                e.getComponent().removeFocusListener(this);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return builder.show() == 0;
    }

    protected void selectRanges(Iterable<TextRange> parameterRanges) {
    }

    private boolean amITheFocusOwner() {
        Component owner = FocusManager.getCurrentManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, this);
    }

    private ColumnInfo[] createColumnInfos() {
        ColoredTableCellRenderer renderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof PObject) {
                    PObject po = (PObject)value;
                    SimpleTextAttributes paramAttrs = ParametersPanel.this.myParamAttrs;
                    this.append(po.displayName, paramAttrs);
                    if (!po.description.isEmpty()) {
                        int count = Math.max(2, Math.min(15, ParametersPanel.this.myMaxParamNameLength) - po.displayName.length());
                        String space = StringUtil.repeat((String)" ", (int)count);
                        this.append(space, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append(po.description.get(0), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        this.append("_", paramAttrs);
                        this.append(po.description.get(2), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else if (value instanceof String) {
                    this.append((String)value, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                } else if (value == null) {
                    this.append("<null>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        };
        AbstractTableCellEditor editor = new AbstractTableCellEditor(){

            public Component getTableCellEditorComponent(JTable table, Object o, boolean b, int column, int row) {
                JComponent c = ParametersPanel.this.myValueField.getComponent();
                ParametersPanel.this.myValueField.setText(o == null ? null : String.valueOf(o));
                ParametersPanel.this.myValueField.selectAll();
                c.setBorder(UIUtil.getTableFocusCellHighlightBorder());
                return c;
            }

            public Object getCellEditorValue() {
                return ParametersPanel.this.myValueField.getText();
            }
        };
        return new ColumnInfo[]{new ColumnInfo<PObject, PObject>(DatabaseMessages.message((String)"jdbc.console.parameter.name.column.title", (Object[])new Object[0]), (TableCellRenderer)renderer){
            final /* synthetic */ TableCellRenderer val$renderer;
            {
                this.val$renderer = tableCellRenderer;
                super(x0);
            }

            public PObject valueOf(PObject o) {
                return o;
            }

            public boolean isCellEditable(PObject o) {
                return false;
            }

            public TableCellRenderer getRenderer(PObject o) {
                return this.val$renderer;
            }
        }, new ColumnInfo<PObject, String>(DatabaseMessages.message((String)"jdbc.console.parameter.value.column.title", (Object[])new Object[0]), (TableCellRenderer)renderer, (TableCellEditor)editor){
            final /* synthetic */ TableCellRenderer val$renderer;
            final /* synthetic */ TableCellEditor val$editor;
            {
                this.val$renderer = tableCellRenderer;
                this.val$editor = tableCellEditor;
                super(x0);
            }

            public String valueOf(PObject o) {
                Object v = ParametersPanel.this.myStorage.getValue((Object)o.name);
                return v == null ? null : String.valueOf(v);
            }

            public boolean isCellEditable(PObject o) {
                return true;
            }

            public void setValue(PObject o, String value) {
                String adjusted = StringUtil.nullize((String)value);
                Object oldValue = ParametersPanel.this.myStorage.putValue((Object)o.name, (Object)adjusted);
                if (Comparing.equal((Object)oldValue, (Object)adjusted)) {
                    return;
                }
                ParametersPanel.this.parameterValueSet(o);
            }

            public TableCellRenderer getRenderer(PObject o) {
                return this.val$renderer;
            }

            public TableCellEditor getEditor(PObject o) {
                return this.val$editor;
            }
        }};
    }

    private void parameterValueSet(@Nullable PObject o) {
        if (this.myDialog == null) {
            return;
        }
        boolean okEnabled = !ParametersPanel.hasUnassignedParameters(this.myScriptModel, this.myStorage);
        this.myDialog.setOkActionEnabled(okEnabled);
        List items = this.myTableModel.getItems();
        int index = items.indexOf(o);
        int len = items.size();
        for (int i = index + 1; i != index; ++i) {
            if (i >= len) {
                if (index == -1) break;
                i = -1;
                continue;
            }
            PObject p = (PObject)ObjectUtils.tryCast(items.get(i), PObject.class);
            if (p == null || !ParametersPanel.isParameterUnassigned(p.name, this.myStorage)) continue;
            final int nextRow = i;
            ModalityState state = ModalityState.current();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!ParametersPanel.this.myDialog.getDialogWrapper().isShowing()) {
                        return;
                    }
                    ParametersPanel.this.myTable.changeSelection(nextRow, 1, false, false);
                    TableUtil.editCellAt((JTable)ParametersPanel.this.myTable, (int)nextRow, (int)1);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable, state);
            break;
        }
    }

    public void onModelUpdated() {
        this.myMaxParamNameLength = 0;
        THashSet visited = ContainerUtil.newTroveSet();
        ArrayList newItems = ContainerUtil.newArrayList();
        for (ScriptModel.ParamIt it : this.myScriptModel.parameters().asCursor()) {
            String name = it.name();
            if (!visited.add((Object)name)) continue;
            PObject p = new PObject();
            p.name = name;
            p.displayName = it.displayName();
            p.description = JBIterable.from((Iterable)it.description()).toList();
            this.myMaxParamNameLength = Math.max(this.myMaxParamNameLength, p.displayName.length());
            newItems.add(p);
        }
        if (!this.myTableModel.getItems().equals(newItems)) {
            this.myTableModel.setItems((List)newItems);
            this.myTableModel.fireTableStructureChanged();
        }
        if (newItems.isEmpty()) {
            this.myTable.getEmptyText().setText("No parameters present");
        }
    }

    public void caretPositionChanged(int offset) {
        if (this.amITheFocusOwner()) {
            return;
        }
        int row = this.getRowForOffset(offset);
        if (row > -1) {
            this.myTable.changeSelection(row, 1, false, false);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        } else {
            this.myTable.clearSelection();
        }
    }

    public void tryEditParameterValue(int offset) {
        int row = this.getRowForOffset(offset);
        if (row <= -1) {
            return;
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTable, true);
        this.myTable.changeSelection(row, 1, false, false);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        TableUtil.editCellAt((JTable)this.myTable, (int)row, (int)1);
    }

    private int getRowForOffset(int offset) {
        String name = (String)this.myScriptModel.subModel(TextRange.from((int)offset, (int)0), true).parameters().asCursor().filter(ScriptModelUtil.AT_OFFSET2(offset)).transform(ScriptModelUtil.TO_NAME).first();
        if (name == null) {
            return -1;
        }
        int i = 0;
        for (Object o : this.myTableModel.getItems()) {
            if (o instanceof PObject && ((PObject)o).name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void commit() {
        TableUtil.stopEditing((JTable)this.myTable);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    private static class PObject {
        String name;
        String displayName;
        List<String> description;

        private PObject() {
        }
    }
}

