/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;

class TableTransferHandler
extends TransferHandler {
    private final TableResultPanel myResultPanel;
    private int myType;

    public TableTransferHandler(@NotNull TableResultPanel resultPanel) {
        if (resultPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultPanel", "com/intellij/database/run/ui/TableTransferHandler", "<init>"));
        }
        this.myResultPanel = resultPanel;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        Component comp;
        Object[] flavors = support != null ? support.getDataFlavors() : null;
        Component component = comp = support != null ? support.getComponent() : null;
        if (flavors != null && comp != null) {
            Point at;
            try {
                at = support.getDropLocation().getDropPoint();
            }
            catch (Exception e) {
                at = null;
            }
            if (at != null) {
                DataConsumer.Column column;
                boolean isStringFlavor = ArrayUtil.find((Object[])flavors, (Object)DataFlavor.stringFlavor) != -1;
                boolean isFileFlavor = FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])flavors);
                int columnAtPoint = this.myResultPanel.getTable().columnAtPoint(at);
                List<DataConsumer.Column> columns = this.myResultPanel.getDataModel().getColumns();
                DataConsumer.Column column2 = column = columnAtPoint >= 1 && columnAtPoint <= columns.size() ? columns.get(columnAtPoint - 1) : null;
                if (column != null) {
                    this.myType = column.type;
                    if (this.isLikeString() || this.isLikeInt() || this.isLikeDouble()) {
                        return isStringFlavor;
                    }
                    if (this.isLikeClob()) {
                        return isStringFlavor || isFileFlavor;
                    }
                    if (this.isLikeBlob()) {
                        return isFileFlavor;
                    }
                }
            }
        }
        return false;
    }

    private boolean isLikeClob() {
        return this.myType == -1 || this.myType == -16 || this.myType == 2005;
    }

    private boolean isLikeBlob() {
        return this.myType == -2 || this.myType == -4 || this.myType == -3 || this.myType == 2004;
    }

    private boolean isLikeDouble() {
        return this.myType == 7 || this.myType == 6 || this.myType == 8 || this.myType == 3 || this.myType == 2;
    }

    private boolean isLikeInt() {
        return this.myType == 4 || this.myType == 5 || this.myType == -6 || this.myType == -5 || this.myType == 2;
    }

    private boolean isLikeString() {
        return this.myType == 1 || this.myType == 12;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (!(comp instanceof JTable)) {
            return false;
        }
        JTable table = (JTable)comp;
        JTable.DropLocation location = table.getDropLocation();
        if (location == null) {
            return false;
        }
        int column = location.getColumn();
        int row = location.getRow();
        List list = FileCopyPasteUtil.getFileList((Transferable)t);
        try {
            boolean oneFileTransferred;
            boolean bl = oneFileTransferred = list != null && list.size() == 1;
            if (oneFileTransferred) {
                File file = (File)ContainerUtil.getFirstItem((List)list);
                if (file == null) {
                    return false;
                }
                LobInfo.FileBlobInfo value = null;
                if (this.isLikeBlob()) {
                    value = new LobInfo.FileBlobInfo(file);
                }
                if (this.isLikeClob()) {
                    Charset charset = CharsetToolkit.guessEncoding((File)file, (int)1024, (Charset)EncodingProjectManager.getInstance((Project)this.myResultPanel.getProject()).getDefaultCharset());
                    value = new LobInfo.FileClobInfo(file, charset == null ? "" : charset.name());
                }
                if (value != null) {
                    table.setValueAt(value, row, column);
                    return true;
                }
                return false;
            }
            String data = (String)t.getTransferData(DataFlavor.stringFlavor);
            if (this.isLikeInt()) {
                new BigInteger(data);
            } else if (this.isLikeDouble()) {
                new BigDecimal(data);
            }
            if (data != null) {
                table.setValueAt(data, row, column);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!(c instanceof JTable)) {
            return null;
        }
        JTable table = (JTable)c;
        int column = table.getSelectedColumn();
        int row = table.getSelectedRow();
        Object at = this.myResultPanel.getTable().getValueAt(row, column);
        if (at instanceof Number) {
            at = at.toString();
        }
        if (at instanceof String) {
            return new StringSelection((String)at);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

