/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class GridSelection {
    private final int[] myRows;
    private final int[] myColumns;

    private GridSelection(int[] rows, int[] columns) {
        this.myRows = rows;
        this.myColumns = columns;
    }

    @NotNull
    public static GridSelection store(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "store"));
        }
        GridSelection gridSelection = new GridSelection(table.getSelectedRows(), table.getSelectedColumns());
        if (gridSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridSelection", "store"));
        }
        return gridSelection;
    }

    public void restore(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "restore"));
        }
        table.clearSelection();
        GridSelection.setColumnSelection(table, this.myColumns);
        GridSelection.setRowSelection(table, this.myRows);
    }

    public GridSelection transpose() {
        return new GridSelection(this.myColumns, this.myRows);
    }

    public static void setColumnSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setColumnSelection"));
        }
        GridSelection.setSelection(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, selection);
    }

    public static void setRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setRowSelection"));
        }
        GridSelection.setSelection(table.getSelectionModel(), false, table.getRowCount() - 1, selection);
    }

    public static void addRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addRowSelection"));
        }
        GridSelection.setSelection(table.getSelectionModel(), true, table.getRowCount() - 1, selection);
    }

    private static void setSelection(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int ... selection) {
        if (maxSelectionIdx < 0) {
            return;
        }
        if (!add) {
            selectionModel.clearSelection();
        }
        for (int index : selection) {
            GridSelection.setSelectionInterval(selectionModel, true, maxSelectionIdx, index, index);
        }
    }

    public static void setColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setColumnSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void addColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addColumnSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), true, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void setRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setRowSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), false, table.getRowCount() - 1, idx0, idx1);
    }

    public static void addRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addRowSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), true, table.getRowCount() - 1, idx0, idx1);
    }

    private static void setSelectionInterval(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int idx0, int idx1) {
        if (maxSelectionIdx < 0) {
            return;
        }
        idx0 = GridSelection.index(idx0, maxSelectionIdx);
        idx1 = GridSelection.index(idx1, maxSelectionIdx);
        if (add) {
            selectionModel.addSelectionInterval(idx0, idx1);
        } else {
            selectionModel.setSelectionInterval(idx0, idx1);
        }
    }

    private static int index(int idx, int maxIdx) {
        return Math.max(0, Math.min(idx, maxIdx));
    }
}

