/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.CalendarView;
import java.awt.Container;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultTimestampEditorFactory
extends FormatBasedGridCellEditorFactory {
    DefaultTimestampEditorFactory() {
    }

    @Override
    @NotNull
    protected Format getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        SimpleDateFormat simpleDateFormat = grid.getObjectFormatter().getTimestampFormat(c, DataGridUtil.getDatabaseDialect(grid));
        if (simpleDateFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getFormat"));
        }
        return simpleDateFormat;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        return ExtractorsUtil.guessJdbcType(c) == 93 ? 1 : 0;
    }

    @Override
    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(final @NotNull DataGrid grid, Project project, @NotNull Format format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor.WithBrowseButton withBrowseButton = new FormatBasedGridCellEditor.WithBrowseButton(project, grid, format, value, nullValue, initiator){

            @Override
            @Nullable
            public Object getValue() {
                Object v = super.getValue();
                return v instanceof Timestamp ? v : (v instanceof Date ? new Timestamp(((Date)v).getTime()) : v);
            }

            @Override
            protected void browseButtonPressed() {
                final CalendarView calendarView = new CalendarView();
                calendarView.setFocusCycleRoot(true);
                Object value = this.getValue();
                calendarView.setDate(value instanceof Date ? (Date)value : new Date());
                final JBPopup popup = this.createPopup((JComponent)calendarView, (JComponent)((Container)calendarView.getComponent(0)).getComponent(0));
                calendarView.registerEnterHandler(new Runnable(){

                    @Override
                    public void run() {
                        this.getTextField().setText(this.format(new Timestamp(calendarView.getDate().getTime())));
                        popup.closeOk(null);
                        grid.stopEditing();
                    }
                });
                this.showPopup(popup);
            }
        };
        if (withBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTimestampEditorFactory", "createEditorImpl"));
        }
        return withBrowseButton;
    }
}

