/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridColumnTypeInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTextRendererFactory
implements GridCellRendererFactory {
    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory", "supportsDialect"));
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull GridColumnTypeInfo columnTypeInfo) {
        if (columnTypeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTypeInfo", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory", "supportsColumn"));
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer createRenderer(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory", "createRenderer"));
        }
        TextRenderer textRenderer = new TextRenderer(grid);
        if (textRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory", "createRenderer"));
        }
        return textRenderer;
    }

    private static class TextRenderer
    extends GridCellRenderer {
        private final Map<Object, String> myValueTextCache;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;

        public TextRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "<init>"));
            }
            super(grid);
            this.myValueTextCache = ContainerUtil.createConcurrentWeakKeySoftValueMap((int)10, (float)0.75f, (int)1, (TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
            new UiNotifyConnector((Component)grid.getComponent(), (Activatable)new Activatable.Adapter(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getSuitability"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getSuitability"));
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
            EditorEx editor;
            EditorColorsScheme scheme;
            if (rowIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getComponent"));
            }
            if (columnIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getComponent"));
            }
            if (this.myComponent == null) {
                this.myComponent = new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(DataGridUtil.getProject(this.myGrid), null, false);
            }
            if ((scheme = (editor = this.myComponent.getEditor()).getColorsScheme()) instanceof DelegateColorScheme) {
                ((DelegateColorScheme)scheme).setDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            }
            scheme.setEditorFontSize(this.myGrid.getPreferredFocusedComponent().getFont().getSize());
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            Object value = this.myGrid.getDataModel().getValueAt(rowIdx, columnIdx);
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value);
            TextAttributes attributes = !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
            String valueText = this.getValueText(rowIdx, columnIdx, value);
            this.myComponent.setText(valueText, attributes, selected);
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getComponent"));
            }
            return abbreviatingRendererComponent;
        }

        @NotNull
        private String getValueText(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value) {
            if (rowIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getValueText"));
            }
            if (columnIdx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getValueText"));
            }
            if (value == null || value instanceof ReservedCellValue) {
                String string = ((ReservedCellValue)((Object)ObjectUtils.notNull((Object)((Object)((ReservedCellValue)((Object)value))), (Object)((Object)ReservedCellValue.NULL)))).getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getValueText"));
                }
                return string;
            }
            String cachedText = this.myValueTextCache.get(value);
            if (cachedText != null) {
                String string = cachedText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getValueText"));
                }
                return string;
            }
            DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.assertNotNull((Object)this.myGrid.getDataModel().getRow(rowIdx));
            DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)this.myGrid.getDataModel().getColumn(columnIdx));
            String text = TextRenderer.getDisplayString(this.myGrid.getObjectFormatter().getPlainValue(column, row, DataGridUtil.getDatabaseDialect(this.myGrid)));
            this.myValueTextCache.put(value, text);
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getValueText"));
            }
            return string;
        }

        private static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer", "getDisplayString"));
            }
            if (DataGridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s) {
            int end;
            for (end = s.length(); end > 0 && s.charAt(end - 1) <= ' '; --end) {
            }
            return s.substring(0, end);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        private static TextAttributesKey getAttributesKey(@Nullable Object value) {
            if (value == null) {
                return DatabaseColors.GRID_NULL_VALUE;
            }
            if (value instanceof ObjectFormatter.ImageInfo) {
                return DatabaseColors.GRID_IMAGE_VALUE;
            }
            if (DataGridUtil.isFailedToLoad(value)) {
                return DatabaseColors.GRID_ERROR_VALUE;
            }
            if (value instanceof LobInfo.FileClobInfo || value instanceof LobInfo.FileBlobInfo) {
                return DatabaseColors.GRID_UPLOAD_VALUE;
            }
            return null;
        }
    }
}

